/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.modelquery.XMLCatalogIdResolver;
import org.eclipse.wst.xml.core.tests.util.FileUtil;

public class TestCatalogRetrivalAndModelCreation
extends TestCase {
    public static final String LOCAL_SCHEMA_FILE = "file:///usr/tmp/mySchemaSchema.xsd";
    public static final String LOCAL_SCHEMA_DIR = "file:///usr/tmp/schemas/";
    public static final String LOCAL_SCHEMA_DIR_REWRITTEN = "file:///usr/tmp/schemas/example.dtd";

    public void testKnownNotExist() throws MalformedURLException, IOException {
        String JUNK_STRING = "doesNotExistTest";
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(JUNK_STRING, null);
        TestCatalogRetrivalAndModelCreation.assertNull((String)("expected no match for " + JUNK_STRING), (Object)resolved);
    }

    public void removedtestWAPFORUM() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD WML 1.1//EN");
    }

    public void testXHTML10() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Strict//EN");
    }

    public void testXHTML10T() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Transitional//EN");
    }

    public void testXHTML10F() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Frameset//EN");
    }

    public void testXHTML10B() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML Basic 1.0//EN");
    }

    public void testXHTML11() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.1//EN");
    }

    public void testXHTML11_xmlresolver() throws MalformedURLException, IOException {
        String EXPECTED_PUBLICID = "-//W3C//DTD XHTML 1.1//EN";
        String baseLocation = "http://www.example.org/testXHTML11.xml";
        XMLCatalogIdResolver resolver = new XMLCatalogIdResolver(baseLocation, null);
        String resolvedXML_Id = resolver.resolve(baseLocation, EXPECTED_PUBLICID, null);
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolvedXL_Cat = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        TestCatalogRetrivalAndModelCreation.assertEquals((String)resolvedXL_Cat, (String)resolvedXML_Id);
    }

    public void testCMXHTML11() throws MalformedURLException, IOException {
        this.doCMTest("-//W3C//DTD XHTML 1.1//EN");
    }

    public void removedtestXHTML10M() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD XHTML Mobile 1.0//EN");
    }

    public void removedtestWAP13() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD WML 1.3//EN");
    }

    public void test2001Schema() throws MalformedURLException, IOException {
        this.doURITest("http://www.w3.org/2001/XMLSchema");
    }

    public void testExternalDTD() throws MalformedURLException, IOException {
        this.doCM_directURITest("http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd");
    }

    public void test2001SchemaCMDirect() throws MalformedURLException, IOException {
        this.doCM_directURITest("http://www.w3.org/2001/XMLSchema.xsd");
    }

    public void test2001SchemaCMCatalog() throws MalformedURLException, IOException {
        this.doURI_CMTest("http://www.w3.org/2001/XMLSchema");
    }

    public void testInvoiceRemote() throws MalformedURLException, IOException {
        this.doCM_directURITest_checkElementCount("http://www.eclipse.org/webtools/wst/components/xsd/tests/dtd-references/Invoice.dtd", 18);
    }

    public void testInvoiceRemoteIndirect() throws MalformedURLException, IOException {
        this.doCM_directURITest_checkElementCount("http://www.eclipse.org/webtools/wst/components/xsd/tests/dtd-references/IndirectInvoice.dtd", 18);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11SystemSuffix() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        ISuffixEntry systemSuffix = (ISuffixEntry)xmlCatalog.createCatalogElement(41);
        systemSuffix.setSuffix("XMLSchema.xsd");
        systemSuffix.setURI(LOCAL_SCHEMA_FILE);
        xmlCatalog.addCatalogElement((ICatalogElement)systemSuffix);
        try {
            String resolved = xmlCatalog.resolveSystem("http://www.w3.org/2001/XMLSchema.xsd");
            TestCatalogRetrivalAndModelCreation.assertEquals((String)LOCAL_SCHEMA_FILE, (String)resolved);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)systemSuffix);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)systemSuffix);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11UriSuffix() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        ISuffixEntry uriSuffix = (ISuffixEntry)xmlCatalog.createCatalogElement(42);
        uriSuffix.setSuffix("XMLSchema.xsd");
        uriSuffix.setURI(LOCAL_SCHEMA_FILE);
        xmlCatalog.addCatalogElement((ICatalogElement)uriSuffix);
        try {
            String resolved = xmlCatalog.resolveURI("http://www.w3.org/2001/XMLSchema.xsd");
            TestCatalogRetrivalAndModelCreation.assertEquals((String)LOCAL_SCHEMA_FILE, (String)resolved);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)uriSuffix);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)uriSuffix);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11RewriteSystem() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        IRewriteEntry systemSuffix = (IRewriteEntry)xmlCatalog.createCatalogElement(21);
        systemSuffix.setStartString("http://www.example.org/dtds/");
        systemSuffix.setRewritePrefix(LOCAL_SCHEMA_DIR);
        xmlCatalog.addCatalogElement((ICatalogElement)systemSuffix);
        try {
            String resolved = xmlCatalog.resolveSystem("http://www.example.org/dtds/example.dtd");
            TestCatalogRetrivalAndModelCreation.assertEquals((String)LOCAL_SCHEMA_DIR_REWRITTEN, (String)resolved);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)systemSuffix);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)systemSuffix);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11RewriteUri() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        IRewriteEntry uriSuffix = (IRewriteEntry)xmlCatalog.createCatalogElement(22);
        uriSuffix.setStartString("urn:fisk:");
        uriSuffix.setRewritePrefix(LOCAL_SCHEMA_DIR);
        xmlCatalog.addCatalogElement((ICatalogElement)uriSuffix);
        try {
            String resolved = xmlCatalog.resolveURI("urn:fisk:example.dtd");
            TestCatalogRetrivalAndModelCreation.assertEquals((String)LOCAL_SCHEMA_DIR_REWRITTEN, (String)resolved);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)uriSuffix);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)uriSuffix);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11DelegatePublic() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        IDelegateCatalog publicDelegate = (IDelegateCatalog)xmlCatalog.createCatalogElement(31);
        File delegateCat = this.makeTempFile("delegatePublic", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"\r\n       prefer=\"public\">\r\n    <public publicId=\"-//Example//an example V1.0.0//EN\"\r\n            uri=\"file:///example.dtd\"/>\r\n</catalog>");
        publicDelegate.setStartString("-//Example//");
        publicDelegate.setCatalogLocation(delegateCat.toURI().toString());
        xmlCatalog.addCatalogElement((ICatalogElement)publicDelegate);
        try {
            String resolved = xmlCatalog.resolvePublic("-//Example//an example V1.0.0//EN", "example.dtd");
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"file:///example.dtd", (String)resolved);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)publicDelegate);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)publicDelegate);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11DelegateSystem() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        IDelegateCatalog systemDelegate = (IDelegateCatalog)xmlCatalog.createCatalogElement(32);
        File delegateCat = this.makeTempFile("delegateSystem", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\r\n    <system systemId=\"http://funky.org/dog\" uri=\"file:///funky-dog.dtd\"/>\r\n    <systemSuffix systemIdSuffix=\"/cat.dtd\" uri=\"file:///smellycat.xsd\"/>\r\n    <rewriteSystem systemIdStartString=\"http://funky.org/parrots/\" rewritePrefix=\"file:///dtds/parrots/\"/>\r\n</catalog>");
        systemDelegate.setStartString("http://funky.org/");
        systemDelegate.setCatalogLocation(delegateCat.toURI().toString());
        xmlCatalog.addCatalogElement((ICatalogElement)systemDelegate);
        try {
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"try systemId entry", (String)"file:///funky-dog.dtd", (String)xmlCatalog.resolveSystem("http://funky.org/dog"));
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"try systemSuffix entry", (String)"file:///smellycat.xsd", (String)xmlCatalog.resolveSystem("http://funky.org/some/cat.dtd"));
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"try rewriteSystem entry", (String)"file:///dtds/parrots/macaw.xsd", (String)xmlCatalog.resolveSystem("http://funky.org/parrots/macaw.xsd"));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)systemDelegate);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)systemDelegate);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCatalog11DelegateUri() throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        IDelegateCatalog uriDelegate = (IDelegateCatalog)xmlCatalog.createCatalogElement(33);
        File delegateCat = this.makeTempFile("delegateUri", "<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\r\n    <uri name=\"urn:funky:dog\" uri=\"file:///funky-dog.dtd\"/>\r\n    <uriSuffix uriSuffix=\":cat\" uri=\"file:///smellycat.dtd\"/>\r\n    <rewriteURI uriStartString=\"urn:funky:fish:\" rewritePrefix=\"file:///dtds/\"/>\r\n</catalog>");
        uriDelegate.setStartString("urn:funky:");
        uriDelegate.setCatalogLocation(delegateCat.toURI().toString());
        xmlCatalog.addCatalogElement((ICatalogElement)uriDelegate);
        try {
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"uri entry", (String)"file:///funky-dog.dtd", (String)xmlCatalog.resolveURI("urn:funky:dog"));
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"uriSuffix entry", (String)"file:///smellycat.dtd", (String)xmlCatalog.resolveURI("urn:funky:where-is-my:cat"));
            TestCatalogRetrivalAndModelCreation.assertEquals((String)"rewriteUri entry", (String)"file:///dtds/parrot.dtd", (String)xmlCatalog.resolveURI("urn:funky:fish:parrot.dtd"));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            xmlCatalog.removeCatalogElement((ICatalogElement)uriDelegate);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        xmlCatalog.removeCatalogElement((ICatalogElement)uriDelegate);
    }

    private File makeTempFile(String name, String contents) throws IOException {
        File delegateCat = FileUtil.makeFileFor("catalogs", name, "cat");
        FileWriter fw = new FileWriter(delegateCat);
        fw.write(contents);
        fw.close();
        return delegateCat;
    }

    private void doTest(String EXPECTED_PUBLICID) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_PUBLICID), (Object)resolved);
    }

    private void doCMTest(String EXPECTED_PUBLICID) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(resolved, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_PUBLICID), (Object)contentModel);
    }

    private void doCM_directURITest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(EXPECTED_URI, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_URI), (Object)contentModel);
    }

    private void doCM_directURITest_checkElementCount(String EXPECTED_URI, int count) throws MalformedURLException, IOException {
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(EXPECTED_URI, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_URI), (Object)contentModel);
        int actualCount = contentModel.getElements().getLength();
        TestCatalogRetrivalAndModelCreation.assertEquals((String)("count of element declarations found for content model create from " + EXPECTED_URI), (int)contentModel.getElements().getLength(), (int)actualCount);
    }

    private void doURITest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolveURI(EXPECTED_URI);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_URI), (Object)resolved);
    }

    void doURI_CMTest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolveURI(EXPECTED_URI);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_URI), (Object)resolved);
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(resolved, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_URI), (Object)contentModel);
    }
}

