/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class ElementImplTests
extends TestCase {
    private static final String contents = "<elementPrefix:localName attrPrefix:local='lorem' xmlns:elementPrefix='urn:prefix' xmlns:attributePrefix='urn:attribute:prefix' />";

    public ElementImplTests() {
    }

    public ElementImplTests(String name) {
        super(name);
    }

    public void testElementImplPrefix() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute prefix was not as expected", (String)"elementPrefix", (String)documentElement.getPrefix());
    }

    public void testElementImplLocalName() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"localName", (String)documentElement.getLocalName());
    }

    public void testAttrBasedElementNamespace() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element documentElement = model.getDocument().getDocumentElement();
        ElementImplTests.assertNotNull((String)"no document element found", (Object)documentElement);
        ElementImplTests.assertNotNull((String)"Namespace was not found.", (Object)documentElement.getNamespaceURI());
        String namespace = documentElement.getNamespaceURI();
        ElementImplTests.assertEquals((String)"attribute local name was not as expected", (String)"urn:prefix", (String)namespace);
    }

    public void testNamespaceURIOnCreation() {
        IDOMModel model = (IDOMModel)StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        model.getStructuredDocument().set(contents);
        Element element = model.getDocument().createElement("simple");
        ElementImplTests.assertNull((String)"namespace was found", (Object)element.getNamespaceURI());
        Element element2 = model.getDocument().createElementNS("http://lorem.ipsum", "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", (String)"http://lorem.ipsum", (String)element2.getNamespaceURI());
        Element element3 = model.getDocument().createElementNS(null, "complex");
        ElementImplTests.assertEquals((String)"attribute namespace URI was not as expected", null, (String)element3.getNamespaceURI());
    }
}

