/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.scalability;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.tests.performance.internal.scalability.ScalabilityTestCase;
import org.eclipse.wst.common.tests.performance.internal.util.EditorTestHelper;

public abstract class OpenEditorTestCase
extends ScalabilityTestCase {
    protected IFile file;

    protected abstract String getEditorId();

    protected abstract String getBundleId();

    protected abstract String getFilePath();

    protected void setUp() throws Exception {
        super.setUp();
        IProject project = this.createProject("sp");
        String bundleId = this.getBundleId();
        this.file = this.copyFile(bundleId, this.getFilePath(), (IContainer)project);
        this.joinBackgroundJobs(3000);
    }

    public void execute() throws Exception {
        this.tagAsSummary(this.getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
        this.startMeasuring();
        this.openEditor(this.getEditorId(), this.file);
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void openEditor(String editorId, IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart editor = workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId, true);
        EditorTestHelper.runEventQueue((IWorkbenchPart)editor);
        workbenchWindow.getActivePage().closeEditor(editor, false);
        try {
            EditorTestHelper.joinBackgroundActivities();
        }
        catch (CoreException e) {
            OpenEditorTestCase.fail((String)e.getMessage());
        }
    }
}

