/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.scalability;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.test.performance.Dimension;
import org.eclipse.wst.common.tests.performance.internal.scalability.ScalabilityTestCase;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public abstract class ValidatorTestCase
extends ScalabilityTestCase {
    protected IProject _project;

    protected abstract String getValidatorId();

    protected abstract String getBundleId();

    protected abstract String getFilePath();

    public static void enableOnlyTheseValidators(String validatorName) throws InvocationTargetException {
        Validator[] vals;
        Validator[] validatorArray = vals = ValManager.getDefault().getValidatorsCopy();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean enable = v.getValidatorClassname().startsWith(validatorName);
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        ValidatorTestCase.saveV1Preferences(vals);
    }

    public static void saveV1Preferences(Validator[] validators) throws InvocationTargetException {
        GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
        LinkedList<ValidatorMetaData> manual = new LinkedList<ValidatorMetaData>();
        LinkedList<ValidatorMetaData> build = new LinkedList<ValidatorMetaData>();
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            Validator.V1 v1 = v.asV1Validator();
            if (v1 != null) {
                if (v1.isManualValidation()) {
                    manual.add(v1.getVmd());
                }
                if (v1.isBuildValidation()) {
                    build.add(v1.getVmd());
                }
            }
            ++n2;
        }
        ValidatorMetaData[] array = new ValidatorMetaData[manual.size()];
        gc.setEnabledManualValidators(manual.toArray(array));
        array = new ValidatorMetaData[build.size()];
        gc.setEnabledBuildValidators(build.toArray(array));
        gc.passivate();
        gc.store();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.turnoffAutoBuild();
        this._project = this.createProject("sp");
        String bundleId = this.getBundleId();
        this.copyFile(bundleId, this.getFilePath(), (IContainer)this._project, 50, "sample-", ".html");
    }

    private void turnoffAutoBuild() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wd = ws.getDescription();
        if (wd.isAutoBuilding()) {
            wd.setAutoBuilding(false);
            ws.setDescription(wd);
        }
    }

    public void testValidateProject() throws CoreException {
        this.tagAsSummary(this.getClassName(), new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.USED_JAVA_HEAP});
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        IProject[] projects = new IProject[]{this._project};
        int i = 0;
        while (i < 3) {
            this.startMeasuring();
            vf.validate(projects, true, false, (IProgressMonitor)monitor);
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

