/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests.performance.internal.util;

import java.util.logging.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.tests.performance.internal.util.DisplayHelper;

public class EditorTestHelper {
    public static void runEventQueue() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window != null) {
            EditorTestHelper.runEventQueue(window.getShell());
        }
    }

    public static void runEventQueue(IWorkbenchPart part) {
        EditorTestHelper.runEventQueue(part.getSite().getShell());
    }

    public static void runEventQueue(Shell shell) {
        EditorTestHelper.runEventQueue(shell.getDisplay());
    }

    public static void runEventQueue(Display display) {
        while (display.readAndDispatch()) {
        }
    }

    public static void runEventQueue(long millis) {
        EditorTestHelper.runEventQueue(EditorTestHelper.getActiveDisplay(), millis);
    }

    public static void runEventQueue(IWorkbenchPart part, long millis) {
        EditorTestHelper.runEventQueue(part.getSite().getShell(), millis);
    }

    public static void runEventQueue(Shell shell, long millis) {
        EditorTestHelper.runEventQueue(shell.getDisplay(), millis);
    }

    public static void runEventQueue(Display display, long minTime) {
        if (display != null) {
            DisplayHelper.sleep(display, minTime);
        } else {
            EditorTestHelper.sleep((int)minTime);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void forceFocus() {
        Shell shell;
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] wbWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (wbWindows.length == 0) {
                return;
            }
            window = wbWindows[0];
        }
        if ((shell = window.getShell()) != null && !shell.isDisposed()) {
            shell.forceActive();
            shell.forceFocus();
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getActivePage() : null;
    }

    public static Display getActiveDisplay() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getShell().getDisplay() : null;
    }

    public static void joinBackgroundActivities() throws CoreException {
        Logger.global.entering("EditorTestHelper", "joinBackgroundActivities");
        Logger.global.finer("join builder");
        boolean interrupted = true;
        while (interrupted) {
            try {
                Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
        Logger.global.finer("join indexer");
        EditorTestHelper.joinJobs(0L, 0L, 500L);
        Logger.global.exiting("EditorTestHelper", "joinBackgroundActivities");
    }

    public static boolean joinJobs(long minTime, long maxTime, long intervalTime) {
        Logger.global.entering("EditorTestHelper", "joinJobs");
        EditorTestHelper.runEventQueue(minTime);
        DisplayHelper helper = new DisplayHelper(){

            public boolean condition() {
                return EditorTestHelper.allJobsQuiet();
            }
        };
        boolean quiet = helper.waitForCondition(EditorTestHelper.getActiveDisplay(), maxTime > 0L ? maxTime : Long.MAX_VALUE, intervalTime);
        Logger.global.exiting("EditorTestHelper", "joinJobs", new Boolean(quiet));
        return quiet;
    }

    public static void sleep(int intervalTime) {
        try {
            Thread.sleep(intervalTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean allJobsQuiet() {
        IJobManager jobManager = Platform.getJobManager();
        Job[] jobs = jobManager.find(null);
        int i = 0;
        while (i < jobs.length) {
            Job job = jobs[i];
            int state = job.getState();
            if (state == 4 || state == 2) {
                Logger.global.finest(job.getName());
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isViewShown(String viewId) {
        return EditorTestHelper.getActivePage().findViewReference(viewId) != null;
    }

    public static boolean showView(String viewId, boolean show) throws PartInitException {
        boolean shown;
        IWorkbenchPage activePage = EditorTestHelper.getActivePage();
        IViewReference view = activePage.findViewReference(viewId);
        boolean bl = shown = view != null;
        if (shown != show) {
            if (show) {
                activePage.showView(viewId);
            } else {
                activePage.hideView(view);
            }
        }
        return shown;
    }

    public static void bringToTop() {
        EditorTestHelper.getActiveWorkbenchWindow().getShell().forceActive();
    }

    public static String showPerspective(String perspective) throws WorkbenchException {
        String shownPerspective = EditorTestHelper.getActivePage().getPerspective().getId();
        if (!perspective.equals(shownPerspective)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            workbench.showPerspective(perspective, activeWindow);
        }
        return shownPerspective;
    }
}

