/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IGroup;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;

public final class BasicTests
extends TestCase {
    private static final String PLUGIN_ID = "org.eclipse.wst.common.project.facet.core.tests";
    public static IProjectFacet f1;
    public static IProjectFacetVersion f1v10;
    public static IProjectFacetVersion f1v12;
    public static IProjectFacetVersion f1v121;
    public static IProjectFacetVersion f1v13;
    public static IProjectFacetVersion f1v20;
    public static IProjectFacet f2;
    public static IProjectFacetVersion f2v35;
    public static IProjectFacetVersion f2v35a;
    public static IProjectFacetVersion f2v47;
    public static IProjectFacetVersion f2v47b;
    public static IProjectFacetVersion f2v47c;
    public static IProjectFacet f2ext;
    public static IProjectFacetVersion f2extv10;
    public static IProjectFacet f3a;
    public static IProjectFacetVersion f3av10;
    public static IProjectFacetVersion f3av20;
    public static IProjectFacet f3b;
    public static IProjectFacetVersion f3bv10;
    public static IProjectFacetVersion f3bv20;
    public static IProjectFacet f3c;
    public static IProjectFacetVersion f3cv10;
    public static IProjectFacetVersion f3cv20;

    static {
        try {
            f1 = ProjectFacetsManager.getProjectFacet((String)"facet1");
            f1v10 = f1.getVersion("1.0");
            f1v12 = f1.getVersion("1.2");
            f1v121 = f1.getVersion("1.2.1");
            f1v13 = f1.getVersion("1.3");
            f1v20 = f1.getVersion("2.0");
            f2 = ProjectFacetsManager.getProjectFacet((String)"facet2");
            f2v35 = f2.getVersion("3.5");
            f2v35a = f2.getVersion("3.5#a");
            f2v47 = f2.getVersion("4.7");
            f2v47b = f2.getVersion("4.7#b");
            f2v47c = f2.getVersion("4.7#c");
            f2ext = ProjectFacetsManager.getProjectFacet((String)"facet2ext");
            f2extv10 = f2ext.getVersion("1.0");
            f3a = ProjectFacetsManager.getProjectFacet((String)"facet3a");
            f3av10 = f3a.getVersion("1.0");
            f3av20 = f3a.getVersion("2.0");
            f3b = ProjectFacetsManager.getProjectFacet((String)"facet3b");
            f3bv10 = f3b.getVersion("1.0");
            f3bv20 = f3b.getVersion("2.0");
            f3c = ProjectFacetsManager.getProjectFacet((String)"facet3c");
            f3cv10 = f3c.getVersion("1.0");
            f3cv20 = f3c.getVersion("2.0");
        }
        catch (Exception exception) {}
    }

    private BasicTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Basic Tests");
        suite.addTest((Test)new BasicTests("testProjectFacetExtensionPoint"));
        suite.addTest((Test)new BasicTests("testProjectFacetVersionExtensionPoint"));
        suite.addTest((Test)new BasicTests("testCategoryExtensionPoint"));
        suite.addTest((Test)new BasicTests("testDefaultVersionComparator"));
        suite.addTest((Test)new BasicTests("testCustomVersionComparator"));
        suite.addTest((Test)new BasicTests("testVersionExpressions"));
        suite.addTest((Test)new BasicTests("testVersionExpressionsWithUnknownVersions"));
        suite.addTest((Test)new BasicTests("testConstraints"));
        suite.addTest((Test)new BasicTests("testConstraintApi"));
        return suite;
    }

    public void testProjectFacetExtensionPoint() {
        BasicTests.assertTrue((boolean)ProjectFacetsManager.isProjectFacetDefined((String)"facet1"));
        IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"facet1");
        BasicTests.assertTrue((boolean)ProjectFacetsManager.getProjectFacets().contains(f1));
        BasicTests.assertEquals((String)f1.getId(), (String)"facet1");
        BasicTests.assertEquals((String)f1.getLabel(), (String)"Facet 1");
        BasicTests.assertEquals((String)f1.getDescription(), (String)"This is the description of facet1.");
        BasicTests.assertEquals((String)f1.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)ProjectFacetsManager.isProjectFacetDefined((String)"facet2"));
        IProjectFacet f2 = ProjectFacetsManager.getProjectFacet((String)"facet2");
        BasicTests.assertTrue((boolean)ProjectFacetsManager.getProjectFacets().contains(f2));
        BasicTests.assertEquals((String)f2.getId(), (String)"facet2");
        BasicTests.assertEquals((String)f2.getLabel(), (String)"facet2");
        BasicTests.assertEquals((String)f2.getDescription(), (String)"");
        BasicTests.assertEquals((String)f2.getPluginId(), (String)PLUGIN_ID);
    }

    public void testProjectFacetVersionExtensionPoint() {
        BasicTests.assertTrue((boolean)f1.hasVersion("1.0"));
        IProjectFacetVersion f1v10 = f1.getVersion("1.0");
        BasicTests.assertEquals((String)f1v10.getVersionString(), (String)"1.0");
        BasicTests.assertEquals((Object)f1v10.getProjectFacet(), (Object)f1);
        BasicTests.assertEquals((String)f1v10.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f1.hasVersion("1.2"));
        IProjectFacetVersion f1v12 = f1.getVersion("1.2");
        BasicTests.assertEquals((String)f1v12.getVersionString(), (String)"1.2");
        BasicTests.assertEquals((Object)f1v12.getProjectFacet(), (Object)f1);
        BasicTests.assertEquals((String)f1v12.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f1.hasVersion("1.2.1"));
        IProjectFacetVersion f1v121 = f1.getVersion("1.2.1");
        BasicTests.assertEquals((String)f1v121.getVersionString(), (String)"1.2.1");
        BasicTests.assertEquals((Object)f1v121.getProjectFacet(), (Object)f1);
        BasicTests.assertEquals((String)f1v121.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f1.hasVersion("1.3"));
        IProjectFacetVersion f1v13 = f1.getVersion("1.3");
        BasicTests.assertEquals((String)f1v13.getVersionString(), (String)"1.3");
        BasicTests.assertEquals((Object)f1v13.getProjectFacet(), (Object)f1);
        BasicTests.assertEquals((String)f1v13.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f1.hasVersion("2.0"));
        IProjectFacetVersion f1v20 = f1.getVersion("2.0");
        BasicTests.assertEquals((String)f1v20.getVersionString(), (String)"2.0");
        BasicTests.assertEquals((Object)f1v20.getProjectFacet(), (Object)f1);
        BasicTests.assertEquals((String)f1v20.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertEquals((Object)f1.getVersions(), TestUtils.asSet(f1v10, f1v12, f1v121, f1v13, f1v20));
        BasicTests.assertTrue((boolean)f2.hasVersion("3.5"));
        IProjectFacetVersion f2v35 = f2.getVersion("3.5");
        BasicTests.assertEquals((String)f2v35.getVersionString(), (String)"3.5");
        BasicTests.assertEquals((Object)f2v35.getProjectFacet(), (Object)f2);
        BasicTests.assertEquals((String)f2v35.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f2.hasVersion("3.5#a"));
        IProjectFacetVersion f2v35a = f2.getVersion("3.5#a");
        BasicTests.assertEquals((String)f2v35a.getVersionString(), (String)"3.5#a");
        BasicTests.assertEquals((Object)f2v35a.getProjectFacet(), (Object)f2);
        BasicTests.assertEquals((String)f2v35a.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f2.hasVersion("4.7"));
        IProjectFacetVersion f2v47 = f2.getVersion("4.7");
        BasicTests.assertEquals((String)f2v47.getVersionString(), (String)"4.7");
        BasicTests.assertEquals((Object)f2v47.getProjectFacet(), (Object)f2);
        BasicTests.assertEquals((String)f2v47.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f2.hasVersion("4.7#b"));
        IProjectFacetVersion f2v47b = f2.getVersion("4.7#b");
        BasicTests.assertEquals((String)f2v47b.getVersionString(), (String)"4.7#b");
        BasicTests.assertEquals((Object)f2v47b.getProjectFacet(), (Object)f2);
        BasicTests.assertEquals((String)f2v47b.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertTrue((boolean)f2.hasVersion("4.7#c"));
        IProjectFacetVersion f2v47c = f2.getVersion("4.7#c");
        BasicTests.assertEquals((String)f2v47c.getVersionString(), (String)"4.7#c");
        BasicTests.assertEquals((Object)f2v47c.getProjectFacet(), (Object)f2);
        BasicTests.assertEquals((String)f2v47c.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertEquals((Object)f2.getVersions(), TestUtils.asSet(f2v35, f2v35a, f2v47, f2v47b, f2v47c));
        BasicTests.assertFalse((boolean)f2.hasVersion("6.9"));
        try {
            f2.getVersion("6.9");
            BasicTests.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testCategoryExtensionPoint() {
        BasicTests.assertTrue((boolean)ProjectFacetsManager.isCategoryDefined((String)"cat1"));
        ICategory cat1 = ProjectFacetsManager.getCategory((String)"cat1");
        BasicTests.assertTrue((boolean)ProjectFacetsManager.getCategories().contains(cat1));
        BasicTests.assertEquals((String)cat1.getId(), (String)"cat1");
        BasicTests.assertEquals((String)cat1.getLabel(), (String)"Category 1");
        BasicTests.assertEquals((String)cat1.getDescription(), (String)"This is the category description.");
        BasicTests.assertEquals((String)cat1.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertEquals((Object)cat1.getProjectFacets(), TestUtils.asSet(f2, f2ext));
        BasicTests.assertEquals((Object)f2.getCategory(), (Object)cat1);
        BasicTests.assertEquals((Object)f2ext.getCategory(), (Object)cat1);
        BasicTests.assertTrue((boolean)ProjectFacetsManager.isCategoryDefined((String)"cat2"));
        ICategory cat2 = ProjectFacetsManager.getCategory((String)"cat2");
        BasicTests.assertTrue((boolean)ProjectFacetsManager.getCategories().contains(cat2));
        BasicTests.assertEquals((String)cat2.getId(), (String)"cat2");
        BasicTests.assertEquals((String)cat2.getLabel(), (String)"cat2");
        BasicTests.assertEquals((String)cat2.getDescription(), (String)"");
        BasicTests.assertEquals((String)cat2.getPluginId(), (String)PLUGIN_ID);
        BasicTests.assertEquals((Object)cat2.getProjectFacets(), TestUtils.asSet(f3a, f3b, f3c));
        BasicTests.assertEquals((Object)f3a.getCategory(), (Object)cat2);
        BasicTests.assertEquals((Object)f3b.getCategory(), (Object)cat2);
        BasicTests.assertEquals((Object)f3c.getCategory(), (Object)cat2);
    }

    public void testDefaultVersionComparator() throws CoreException {
        Comparator comp = f1.getVersionComparator();
        BasicTests.assertEquals((String)comp.getClass().getName(), (String)"org.eclipse.wst.common.project.facet.core.DefaultVersionComparator");
        BasicTests.assertTrue((comp.compare("1.0", "1.2") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2", "1.2.1") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2.1", "2.0") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2", "1.0") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2.1", "1.2") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("2.0", "1.2.1") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.0", "1.0") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2", "1.2") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("1.2.1", "1.2.1") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("2.0", "2.0") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v10.compareTo((Object)f1v12) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v12.compareTo((Object)f1v121) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v121.compareTo((Object)f1v20) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v12.compareTo((Object)f1v10) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v121.compareTo((Object)f1v12) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v20.compareTo((Object)f1v121) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v10.compareTo((Object)f1v10) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v12.compareTo((Object)f1v12) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v121.compareTo((Object)f1v121) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f1v20.compareTo((Object)f1v20) == 0 ? 1 : 0) != 0);
        BasicTests.assertEquals((Object)f1.getLatestVersion(), (Object)f1v20);
        List asc = f1.getSortedVersions(true);
        BasicTests.assertEquals((int)asc.size(), (int)5);
        BasicTests.assertEquals(asc.get(0), (Object)f1v10);
        BasicTests.assertEquals(asc.get(1), (Object)f1v12);
        BasicTests.assertEquals(asc.get(2), (Object)f1v121);
        BasicTests.assertEquals(asc.get(3), (Object)f1v13);
        BasicTests.assertEquals(asc.get(4), (Object)f1v20);
        List desc = f1.getSortedVersions(false);
        BasicTests.assertEquals((int)desc.size(), (int)5);
        BasicTests.assertEquals(desc.get(0), (Object)f1v20);
        BasicTests.assertEquals(desc.get(1), (Object)f1v13);
        BasicTests.assertEquals(desc.get(2), (Object)f1v121);
        BasicTests.assertEquals(desc.get(3), (Object)f1v12);
        BasicTests.assertEquals(desc.get(4), (Object)f1v10);
    }

    public void testCustomVersionComparator() throws CoreException {
        Comparator comp = f2.getVersionComparator();
        BasicTests.assertEquals((String)comp.getClass().getName(), (String)"org.eclipse.wst.common.project.facet.core.tests.support.CustomVersionComparator");
        BasicTests.assertTrue((comp.compare("3.5", "4.7") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("3.5", "3.5#a") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("4.7#c", "4.7#b") < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("4.7", "3.5") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("3.5#a", "3.5") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("4.7#b", "4.7#c") > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("3.5", "3.5") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("3.5#a", "3.5#a") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("4.7", "4.7") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((comp.compare("4.7#b", "4.7#b") == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v35.compareTo((Object)f2v47) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v35.compareTo((Object)f2v35a) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v47c.compareTo((Object)f2v47b) < 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v47.compareTo((Object)f2v35) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v35a.compareTo((Object)f2v35) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v47b.compareTo((Object)f2v47c) > 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v35.compareTo((Object)f2v35) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v35a.compareTo((Object)f2v35a) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v47.compareTo((Object)f2v47) == 0 ? 1 : 0) != 0);
        BasicTests.assertTrue((f2v47b.compareTo((Object)f2v47b) == 0 ? 1 : 0) != 0);
        BasicTests.assertEquals((Object)f2.getLatestVersion(), (Object)f2v47b);
        List asc = f2.getSortedVersions(true);
        BasicTests.assertEquals((int)asc.size(), (int)5);
        BasicTests.assertEquals(asc.get(0), (Object)f2v35);
        BasicTests.assertEquals(asc.get(1), (Object)f2v35a);
        BasicTests.assertEquals(asc.get(2), (Object)f2v47);
        BasicTests.assertEquals(asc.get(3), (Object)f2v47c);
        BasicTests.assertEquals(asc.get(4), (Object)f2v47b);
        List desc = f2.getSortedVersions(false);
        BasicTests.assertEquals((int)desc.size(), (int)5);
        BasicTests.assertEquals(desc.get(0), (Object)f2v47b);
        BasicTests.assertEquals(desc.get(1), (Object)f2v47c);
        BasicTests.assertEquals(desc.get(2), (Object)f2v47);
        BasicTests.assertEquals(desc.get(3), (Object)f2v35a);
        BasicTests.assertEquals(desc.get(4), (Object)f2v35);
    }

    public void testVersionExpressions() throws CoreException {
        BasicTests.assertEquals((Object)f1.getVersions("1.2"), TestUtils.asSet(f1v12));
        BasicTests.assertEquals((Object)f1.getVersions("1.2,1.3"), TestUtils.asSet(f1v12, f1v13));
        BasicTests.assertEquals((Object)f1.getVersions("1.0,1.2,1.2.1,1.3,2.0"), TestUtils.asSet(f1v10, f1v12, f1v121, f1v13, f1v20));
        BasicTests.assertEquals((Object)f1.getVersions("[1.2"), TestUtils.asSet(f1v12, f1v121, f1v13, f1v20));
        BasicTests.assertEquals((Object)f1.getVersions("(1.2"), TestUtils.asSet(f1v121, f1v13, f1v20));
        BasicTests.assertEquals((Object)f1.getVersions("1.3]"), TestUtils.asSet(f1v10, f1v12, f1v121, f1v13));
        BasicTests.assertEquals((Object)f1.getVersions("1.3)"), TestUtils.asSet(f1v10, f1v12, f1v121));
        BasicTests.assertEquals((Object)f1.getVersions("[1.2-1.3]"), TestUtils.asSet(f1v12, f1v121, f1v13));
        BasicTests.assertEquals((Object)f1.getVersions("[1.2-1.3)"), TestUtils.asSet(f1v12, f1v121));
        BasicTests.assertEquals((Object)f1.getVersions("(1.2-1.3]"), TestUtils.asSet(f1v121, f1v13));
        BasicTests.assertEquals((Object)f1.getVersions("1.0,(1.2-1.3],2.0"), TestUtils.asSet(f1v10, f1v121, f1v13, f1v20));
    }

    public void testVersionExpressionsWithUnknownVersions() throws CoreException {
        BasicTests.assertEquals((Object)f1.getVersions("[0.5-1.2]"), TestUtils.asSet(f1v10, f1v12));
        BasicTests.assertEquals((Object)f1.getVersions("[1.2.2-2.0]"), TestUtils.asSet(f1v13, f1v20));
        BasicTests.assertEquals((Object)f1.getVersions("[0.5-10.0)"), TestUtils.asSet(f1v10, f1v12, f1v121, f1v13, f1v20));
        BasicTests.assertEquals((Object)f1.getVersions("[10.0-25]"), Collections.emptySet());
        BasicTests.assertEquals((Object)f1.getVersions("3.0,4.5"), Collections.emptySet());
        BasicTests.assertEquals((Object)f1.getVersions("5.7"), Collections.emptySet());
    }

    public void testConstraints() {
        BasicTests.assertFalse((boolean)f2v35.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        BasicTests.assertTrue((boolean)f2v35.getConstraint().check(TestUtils.asSet(f1v10)).isOK());
        BasicTests.assertFalse((boolean)f2v35.getConstraint().check(TestUtils.asSet(f1v12)).isOK());
        BasicTests.assertFalse((boolean)f2v35.getConstraint().check(TestUtils.asSet(f1v121)).isOK());
        BasicTests.assertFalse((boolean)f2v35.getConstraint().check(TestUtils.asSet(f1v13)).isOK());
        BasicTests.assertFalse((boolean)f2v35.getConstraint().check(TestUtils.asSet(f1v20)).isOK());
        BasicTests.assertFalse((boolean)f2v35a.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        BasicTests.assertFalse((boolean)f2v35a.getConstraint().check(TestUtils.asSet(f1v10)).isOK());
        BasicTests.assertTrue((boolean)f2v35a.getConstraint().check(TestUtils.asSet(f1v12)).isOK());
        BasicTests.assertTrue((boolean)f2v35a.getConstraint().check(TestUtils.asSet(f1v121)).isOK());
        BasicTests.assertFalse((boolean)f2v35a.getConstraint().check(TestUtils.asSet(f1v13)).isOK());
        BasicTests.assertFalse((boolean)f2v35a.getConstraint().check(TestUtils.asSet(f1v20)).isOK());
        BasicTests.assertFalse((boolean)f2v47.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        BasicTests.assertFalse((boolean)f2v47.getConstraint().check(TestUtils.asSet(f1v10)).isOK());
        BasicTests.assertFalse((boolean)f2v47.getConstraint().check(TestUtils.asSet(f1v12)).isOK());
        BasicTests.assertFalse((boolean)f2v47.getConstraint().check(TestUtils.asSet(f1v121)).isOK());
        BasicTests.assertTrue((boolean)f2v47.getConstraint().check(TestUtils.asSet(f1v13)).isOK());
        BasicTests.assertTrue((boolean)f2v47.getConstraint().check(TestUtils.asSet(f1v20)).isOK());
        BasicTests.assertFalse((boolean)f2v47b.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        BasicTests.assertFalse((boolean)f2v47b.getConstraint().check(TestUtils.asSet(f1v10)).isOK());
        BasicTests.assertFalse((boolean)f2v47b.getConstraint().check(TestUtils.asSet(f1v12)).isOK());
        BasicTests.assertFalse((boolean)f2v47b.getConstraint().check(TestUtils.asSet(f1v121)).isOK());
        BasicTests.assertTrue((boolean)f2v47b.getConstraint().check(TestUtils.asSet(f1v13)).isOK());
        BasicTests.assertTrue((boolean)f2v47b.getConstraint().check(TestUtils.asSet(f1v20)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check((Collection)Collections.EMPTY_SET).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v10)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v12)).isOK());
        BasicTests.assertTrue((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v121)).isOK());
        BasicTests.assertTrue((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v13)).isOK());
        BasicTests.assertTrue((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3av10)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3av20)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3bv10)).isOK());
        BasicTests.assertTrue((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3bv20)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3cv10)).isOK());
        BasicTests.assertFalse((boolean)f2v47c.getConstraint().check(TestUtils.asSet(f1v20, f3cv20)).isOK());
    }

    public void testConstraintApi() {
        BasicTests.assertEquals((String)IConstraint.Type.AND.name(), (String)"and");
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"and") == IConstraint.Type.AND ? 1 : 0) != 0);
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"aNd") == IConstraint.Type.AND ? 1 : 0) != 0);
        BasicTests.assertEquals((String)IConstraint.Type.OR.name(), (String)"or");
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"or") == IConstraint.Type.OR ? 1 : 0) != 0);
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"oR") == IConstraint.Type.OR ? 1 : 0) != 0);
        BasicTests.assertEquals((String)IConstraint.Type.REQUIRES.name(), (String)"requires");
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"requires") == IConstraint.Type.REQUIRES ? 1 : 0) != 0);
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"rEqUiRes") == IConstraint.Type.REQUIRES ? 1 : 0) != 0);
        BasicTests.assertEquals((String)IConstraint.Type.CONFLICTS.name(), (String)"conflicts");
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"conflicts") == IConstraint.Type.CONFLICTS ? 1 : 0) != 0);
        BasicTests.assertTrue((IConstraint.Type.valueOf((String)"cOnFlIcTs") == IConstraint.Type.CONFLICTS ? 1 : 0) != 0);
        BasicTests.assertTrue((boolean)ProjectFacetsManager.isGroupDefined((String)"group1"));
        IGroup g = ProjectFacetsManager.getGroup((String)"group1");
        BasicTests.assertEquals((String)g.getId(), (String)"group1");
        BasicTests.assertEquals((Object)g.getMembers(), TestUtils.asSet(f2v47c, f3cv10, f3cv20));
        IConstraint root = f2v47c.getConstraint();
        BasicTests.checkConstraint(root, IConstraint.Type.AND, null, null, null, null);
        IConstraint c1 = (IConstraint)root.getOperand(0);
        BasicTests.checkConstraint(c1, IConstraint.Type.OR, null, null, null);
        IConstraint c2 = (IConstraint)c1.getOperand(0);
        BasicTests.checkConstraint(c2, IConstraint.Type.REQUIRES, f1, "1.2.1", Boolean.FALSE);
        c2 = (IConstraint)c1.getOperand(1);
        BasicTests.checkConstraint(c2, IConstraint.Type.REQUIRES, f1, "1.3", Boolean.FALSE);
        c2 = (IConstraint)c1.getOperand(2);
        BasicTests.checkConstraint(c2, IConstraint.Type.REQUIRES, f1, "2.0", Boolean.FALSE);
        c1 = (IConstraint)root.getOperand(1);
        BasicTests.checkConstraint(c1, IConstraint.Type.CONFLICTS, f3a, "*");
        c1 = (IConstraint)root.getOperand(2);
        BasicTests.checkConstraint(c1, IConstraint.Type.CONFLICTS, f3b, "1.0");
        c1 = (IConstraint)root.getOperand(3);
        BasicTests.checkConstraint(c1, IConstraint.Type.CONFLICTS, g);
    }

    private static void checkConstraint(IConstraint c, IConstraint.Type expectedType, Object expectedOperand) {
        BasicTests.checkConstraint(c, expectedType, new Object[]{expectedOperand});
    }

    private static void checkConstraint(IConstraint c, IConstraint.Type expectedType, Object expectedOperand1, Object expectedOperand2) {
        BasicTests.checkConstraint(c, expectedType, new Object[]{expectedOperand1, expectedOperand2});
    }

    private static void checkConstraint(IConstraint c, IConstraint.Type expectedType, Object expectedOperand1, Object expectedOperand2, Object expectedOperand3) {
        BasicTests.checkConstraint(c, expectedType, new Object[]{expectedOperand1, expectedOperand2, expectedOperand3});
    }

    private static void checkConstraint(IConstraint c, IConstraint.Type expectedType, Object expectedOperand1, Object expectedOperand2, Object expectedOperand3, Object expectedOperand4) {
        BasicTests.checkConstraint(c, expectedType, new Object[]{expectedOperand1, expectedOperand2, expectedOperand3, expectedOperand4});
    }

    private static void checkConstraint(IConstraint c, IConstraint.Type expectedType, Object[] expectedOperands) {
        BasicTests.assertEquals((Object)c.getType(), (Object)expectedType);
        int count = c.getOperands().size();
        BasicTests.assertEquals((int)count, (int)expectedOperands.length);
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < count) {
            Object operand = c.getOperand(i);
            Object expected = expectedOperands[i];
            if (expected != null) {
                if (expected instanceof String && !(operand instanceof String)) {
                    BasicTests.assertEquals((Object)operand.toString(), (Object)expected);
                } else {
                    BasicTests.assertEquals((Object)operand, (Object)expected);
                }
            }
            list.add(c.getOperand(i));
            ++i;
        }
        BasicTests.assertEquals((Object)c.getOperands(), list);
    }
}

