/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.tests.AbstractTests;
import org.eclipse.wst.common.project.facet.core.tests.support.TestUtils;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventDeliveryTests
extends AbstractTests {
    private static IProjectFacet f1 = ProjectFacetsManager.getProjectFacet((String)"edt_f1");
    private static IProjectFacetVersion f1v10 = f1.getVersion("1.0");
    private static IProjectFacetVersion f1v20 = f1.getVersion("2.0");
    private static IProjectFacet f2 = ProjectFacetsManager.getProjectFacet((String)"edt_f2");
    private static IProjectFacetVersion f2v11 = f2.getVersion("1.1");
    private static IProjectFacetVersion f2v21 = f2.getVersion("2.1");
    private static IProjectFacet f3 = ProjectFacetsManager.getProjectFacet((String)"edt_f3");
    private static IProjectFacetVersion f3v12 = f3.getVersion("1.2");
    private static IProjectFacetVersion f3v22 = f3.getVersion("2.2");
    private static IProjectFacet f4 = ProjectFacetsManager.getProjectFacet((String)"edt_f4");
    private static IProjectFacetVersion f4v13 = f4.getVersion("1.3");
    private static IProjectFacetVersion f4v23 = f4.getVersion("2.3");

    private EventDeliveryTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Event Delivery Tests");
        suite.addTest((Test)new EventDeliveryTests("testEventsAtProjectCreation1"));
        suite.addTest((Test)new EventDeliveryTests("testEventsAtProjectCreation2"));
        suite.addTest((Test)new EventDeliveryTests("testEventsAtProjectCreation3"));
        suite.addTest((Test)new EventDeliveryTests("testEventDelivery"));
        return suite;
    }

    public void testEventsAtProjectCreation1() throws CoreException {
        FullExtensionBasedListener.reset();
        this.createFacetedProject("testEventsAtProjectCreation1");
        EventDeliveryTests.assertEquals((int)FullExtensionBasedListener.retrieveEvents().size(), (int)0);
    }

    public void testEventsAtProjectCreation2() throws CoreException {
        IFacetedProject fpj = ProjectFacetsManager.create((String)"testEventsAtProjectCreation2", null, null);
        IProject pj = fpj.getProject();
        this.addResourceToCleanup((IResource)pj);
        fpj.installProjectFacet(f1v10, null, null);
        fpj.installProjectFacet(f2v11, null, null);
        pj.delete(false, false, null);
        FullExtensionBasedListener.reset();
        pj.create(null);
        pj.open(null);
        IFacetedProject fpjNew = ProjectFacetsManager.create((IProject)pj);
        EventDeliveryTests.assertTrue((boolean)fpjNew.hasProjectFacet(f1v10));
        EventDeliveryTests.assertTrue((boolean)fpjNew.hasProjectFacet(f2v11));
        EventDeliveryTests.assertEquals((int)FullExtensionBasedListener.retrieveEvents().size(), (int)0);
        EventDeliveryTests.assertTrue((fpj != fpjNew ? 1 : 0) != 0);
    }

    public void testEventsAtProjectCreation3() throws CoreException {
        FullExtensionBasedListener.reset();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        File wsLocation = wsRoot.getLocation().toFile();
        File pjLocation = new File(wsLocation, "testEventsAtProjectCreation3");
        FileUtil.copyFromPlugin((String)"org.eclipse.wst.common.project.facet.core.tests", (IPath)new Path("resources/EventDeliveryTests.testEventsAtProjectCreation3/.project"), (File)new File(pjLocation, ".project"));
        FileUtil.copyFromPlugin((String)"org.eclipse.wst.common.project.facet.core.tests", (IPath)new Path("resources/EventDeliveryTests.testEventsAtProjectCreation3/.settings/org.eclipse.wst.common.project.facet.core.xml"), (File)new File(pjLocation, ".settings/org.eclipse.wst.common.project.facet.core.xml"));
        IProject pj = wsRoot.getProject("testEventsAtProjectCreation3");
        pj.create(null);
        pj.open(null);
        this.addResourceToCleanup((IResource)pj);
        IFacetedProject fpj = ProjectFacetsManager.create((IProject)pj);
        EventDeliveryTests.assertTrue((boolean)fpj.hasProjectFacet(f1v10));
        EventDeliveryTests.assertTrue((boolean)fpj.hasProjectFacet(f2v11));
        EventDeliveryTests.assertEquals((int)FullExtensionBasedListener.retrieveEvents().size(), (int)0);
    }

    public void testEventDelivery() throws CoreException {
        IFacetedProject fpj = this.createFacetedProject();
        Listener fullListenerProjectApi = new Listener(null, null);
        fpj.addListener((IFacetedProjectListener)fullListenerProjectApi, new IFacetedProjectEvent.Type[0]);
        final Listener fullListenerGlobalApi = new Listener(null, null);
        FacetedProjectFramework.addListener((IFacetedProjectListener)fullListenerGlobalApi, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[0]);
        Listener partialListenerProjectApi = new Listener(null, null);
        fpj.addListener((IFacetedProjectListener)partialListenerProjectApi, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRE_INSTALL, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED});
        final Listener partialListenerGlobalApi = new Listener(null, null);
        FacetedProjectFramework.addListener((IFacetedProjectListener)partialListenerGlobalApi, (IFacetedProjectEvent.Type[])new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRE_INSTALL, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED});
        if (FullExtensionBasedListener.instance != null) {
            FullExtensionBasedListener.instance.retrieveDeliveredEvents();
        }
        if (PartialExtensionBasedListener.instance != null) {
            PartialExtensionBasedListener.instance.retrieveDeliveredEvents();
        }
        this.addTearDownOperation(new Runnable(){

            public void run() {
                FacetedProjectFramework.removeListener((IFacetedProjectListener)fullListenerGlobalApi);
                FacetedProjectFramework.removeListener((IFacetedProjectListener)partialListenerGlobalApi);
            }
        });
        fpj.setFixedProjectFacets(TestUtils.asSet(f1, f2));
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep1);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep1);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep1);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep1);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep1);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep1);
        fpj.modify(TestUtils.asSet(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f1v10, null), new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f2v11, null), new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, f3v12, null)), null);
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep2);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep2);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep2);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep2);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep2);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep2);
        fpj.installProjectFacet(f4v13, null, null);
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep3);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep3);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep3);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep3);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep3);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep3);
        fpj.uninstallProjectFacet(f3v12, null, null);
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep4);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep4);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep4);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep4);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep4);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep4);
        fpj.setFixedProjectFacets(TestUtils.asSet(f4));
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep5);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep5);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep5);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep5);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep5);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep5);
        fpj.modify(TestUtils.asSet(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, f1v20, null), new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, f4v23, null)), null);
        EventDeliveryTests.check(fullListenerProjectApi, Resources.fullStep6);
        EventDeliveryTests.check(fullListenerGlobalApi, Resources.fullStep6);
        EventDeliveryTests.check(FullExtensionBasedListener.instance, Resources.fullStep6);
        EventDeliveryTests.check(partialListenerProjectApi, Resources.partialStep6);
        EventDeliveryTests.check(partialListenerGlobalApi, Resources.partialStep6);
        EventDeliveryTests.check(PartialExtensionBasedListener.instance, Resources.partialStep6);
    }

    private static String toString(List<IFacetedProjectEvent> events) {
        StringBuilder buf = new StringBuilder();
        for (IFacetedProjectEvent event : events) {
            buf.append(event.toString()).append('\n');
        }
        return buf.toString();
    }

    private static void check(Listener listener, String expectedEvents) {
        String actual = EventDeliveryTests.toString(listener.retrieveDeliveredEvents()).trim();
        String expected = expectedEvents.trim();
        EventDeliveryTests.assertEquals((String)expected, (String)actual);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FullExtensionBasedListener
    extends Listener {
        public static Listener instance = null;

        public FullExtensionBasedListener() {
            instance = this;
        }

        public static void reset() {
            if (instance != null) {
                instance.retrieveDeliveredEvents();
            }
        }

        public static List<IFacetedProjectEvent> retrieveEvents() {
            if (instance != null) {
                return instance.retrieveDeliveredEvents();
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Listener
    implements IFacetedProjectListener {
        private final List<IFacetedProjectEvent> events = new ArrayList<IFacetedProjectEvent>();

        private Listener() {
        }

        public final void handleEvent(IFacetedProjectEvent event) {
            this.events.add(event);
        }

        public final List<IFacetedProjectEvent> retrieveDeliveredEvents() {
            ArrayList<IFacetedProjectEvent> result = new ArrayList<IFacetedProjectEvent>(this.events);
            this.events.clear();
            return result;
        }

        /* synthetic */ Listener(Listener listener, Listener listener2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartialExtensionBasedListener
    extends Listener {
        public static Listener instance = null;

        public PartialExtensionBasedListener() {
            instance = this;
        }

        public static void reset() {
            if (instance != null) {
                instance.retrieveDeliveredEvents();
            }
        }

        public static List<IFacetedProjectEvent> retrieveEvents() {
            if (instance != null) {
                return instance.retrieveDeliveredEvents();
            }
            return Collections.emptyList();
        }
    }

    public static final class Resources
    extends NLS {
        public static String fullStep1;
        public static String fullStep2;
        public static String fullStep3;
        public static String fullStep4;
        public static String fullStep5;
        public static String fullStep6;
        public static String partialStep1;
        public static String partialStep2;
        public static String partialStep3;
        public static String partialStep4;
        public static String partialStep5;
        public static String partialStep6;

        static {
            Resources.initializeMessages((String)EventDeliveryTests.class.getName(), Resources.class);
        }
    }
}

