/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.jaxb21;

import org.eclipse.jpt.common.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.jaxb21.JaxbTypeItemLabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbClassItemLabelProvider
extends JaxbTypeItemLabelProvider {
    public JaxbClassItemLabelProvider(JaxbClass jaxbPersistentClass, DelegatingContentAndLabelProvider labelProvider) {
        super((JaxbType)jaxbPersistentClass, labelProvider);
    }

    public JaxbClass getModel() {
        return (JaxbClass)super.getModel();
    }

    protected PropertyValueModel<Image> buildImageModel() {
        return new JaxbClassImageModel(this.getModel());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JaxbClassImageModel
    extends AspectPropertyValueModelAdapter<JaxbClass, Image> {
        protected final PropertyValueModel<Boolean> isXmlRegistryModel;
        protected final PropertyValueModel<JaxbClassMapping> mappingModel;
        protected final PropertyValueModel<Boolean> isXmlTransientModel;
        protected final PropertyChangeListener propertyChangeListener;

        public JaxbClassImageModel(JaxbClass subject) {
            super((PropertyValueModel)new StaticPropertyValueModel((Object)subject));
            this.isXmlRegistryModel = this.buildIsXmlRegistryModel();
            this.mappingModel = this.buildMappingModel();
            this.isXmlTransientModel = this.buildIsXmlTransientModel();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        protected PropertyValueModel<Boolean> buildIsXmlRegistryModel() {
            return new PropertyAspectAdapter<JaxbClass, Boolean>("xmlRegistry", JaxbClassItemLabelProvider.this.getModel()){

                protected Boolean buildValue_() {
                    if (((JaxbClass)this.subject).getXmlRegistry() != null) {
                        return true;
                    }
                    return false;
                }
            };
        }

        protected PropertyValueModel<JaxbClassMapping> buildMappingModel() {
            return new PropertyAspectAdapter<JaxbClass, JaxbClassMapping>("mapping", JaxbClassItemLabelProvider.this.getModel()){

                protected JaxbClassMapping buildValue_() {
                    return ((JaxbClass)this.subject).getMapping();
                }
            };
        }

        protected PropertyValueModel<Boolean> buildIsXmlTransientModel() {
            return new PropertyAspectAdapter<JaxbClassMapping, Boolean>(this.mappingModel, new String[]{"xmlTransient"}){

                protected Boolean buildValue_() {
                    return ((JaxbClassMapping)this.subject).isXmlTransient();
                }
            };
        }

        protected PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    JaxbClassImageModel.this.propertyChanged();
                }
            };
        }

        protected Image buildValue_() {
            if (this.mappingModel.getValue() != null) {
                if (this.isXmlTransientModel.getValue() == Boolean.TRUE) {
                    return JptJaxbUiPlugin.getImage("full/obj16/jaxb_transient_class");
                }
            } else if (this.isXmlRegistryModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiPlugin.getImage("full/obj16/jaxb_registry");
            }
            return JptJaxbUiPlugin.getImage("full/obj16/jaxb_class");
        }

        protected void engageSubject_() {
            this.isXmlRegistryModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.addPropertyChangeListener("value", this.propertyChangeListener);
        }

        protected void disengageSubject_() {
            this.isXmlRegistryModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.removePropertyChangeListener("value", this.propertyChangeListener);
        }
    }
}

