/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal;

import java.sql.Connection;
import java.util.EventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IManagedConnectionListener;
import org.eclipse.datatools.connectivity.IManagedConnectionOfflineListener;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseObject;
import org.eclipse.jpt.jpa.db.internal.DTPDatabaseWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPForeignKeyWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPSequenceWrapper;
import org.eclipse.jpt.jpa.db.internal.DTPTableWrapper;

final class DTPConnectionProfileWrapper
implements DTPDatabaseObject,
ConnectionProfile {
    private final IConnectionProfile dtpConnectionProfile;
    private final DatabaseIdentifierAdapter identifierAdapter;
    private final IManagedConnection dtpManagedConnection;
    private final LocalConnectionListener connectionListener;
    private DTPDatabaseWrapper database;
    private static final String LIVE_DTP_CONNECTION_TYPE = Connection.class.getName();
    private static final String OFFLINE_DTP_CONNECTION_TYPE = ConnectionInfo.class.getName();
    private static final String DATABASE_PRODUCT_PROP_ID = "org.eclipse.datatools.connectivity.server.version";

    DTPConnectionProfileWrapper(IConnectionProfile dtpConnectionProfile, DatabaseIdentifierAdapter identifierAdapter) {
        this.dtpConnectionProfile = dtpConnectionProfile;
        this.identifierAdapter = identifierAdapter;
        this.dtpManagedConnection = this.buildDTPManagedConnection();
        this.connectionListener = new LocalConnectionListener();
    }

    private IManagedConnection buildDTPManagedConnection() {
        return this.dtpConnectionProfile.getManagedConnection(this.getDTPConnectionType());
    }

    private String getDTPConnectionType() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode() ? OFFLINE_DTP_CONNECTION_TYPE : LIVE_DTP_CONNECTION_TYPE;
    }

    public String getName() {
        return this.dtpConnectionProfile.getName();
    }

    public String getIdentifier(String javaIdentifier) {
        throw new UnsupportedOperationException();
    }

    public String getIdentifier() {
        throw new UnsupportedOperationException();
    }

    public DTPConnectionProfileWrapper getConnectionProfile() {
        return this;
    }

    public synchronized DTPDatabaseWrapper getDatabase() {
        if (this.database == null) {
            this.database = this.buildDatabase();
        }
        return this.database;
    }

    public String getProviderID() {
        return this.dtpConnectionProfile.getProviderId();
    }

    public String getInstanceID() {
        return this.dtpConnectionProfile.getInstanceID();
    }

    public String getDatabaseName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
    }

    public String getDatabaseProduct() {
        return this.getProperty(DATABASE_PRODUCT_PROP_ID);
    }

    public String getDatabaseVendor() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.vendor");
    }

    public String getDatabaseVersion() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.version");
    }

    public String getDriverClassName() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
    }

    public String getURL() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public String getUserName() {
        String userName = this.getProperty("org.eclipse.datatools.connectivity.db.username");
        return this.extractUserName(userName.trim());
    }

    private String extractUserName(String userName) {
        String[] strings = userName.split("\\s+");
        if (strings.length == 3 && strings[1].equalsIgnoreCase("as")) {
            return strings[0];
        }
        return userName;
    }

    public String getUserPassword() {
        return this.getProperty("org.eclipse.datatools.connectivity.db.password");
    }

    public String getDriverDefinitionID() {
        return this.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public String getDriverJarList() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getJarList();
    }

    public String getDriverName() {
        return DriverManager.getInstance().getDriverInstanceByID(this.getDriverDefinitionID()).getName();
    }

    public boolean isActive() {
        return this.isConnected() || this.isWorkingOffline();
    }

    public boolean isInactive() {
        return !this.isActive();
    }

    public boolean isConnected() {
        return this.dtpManagedConnection.isConnected() && !this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean isDisconnected() {
        return !this.isConnected();
    }

    public void connect() {
        if (this.isDisconnected()) {
            this.checkStatus(this.dtpConnectionProfile.connect());
        }
    }

    public void disconnect() {
        this.checkStatus(this.dtpConnectionProfile.disconnect());
    }

    public Connection getJDBCConnection() {
        return this.getConnectionInfo().getSharedConnection();
    }

    public boolean isWorkingOffline() {
        return this.dtpManagedConnection.isWorkingOffline();
    }

    public boolean supportsWorkOfflineMode() {
        return this.dtpConnectionProfile.supportsWorkOfflineMode();
    }

    public IStatus saveWorkOfflineData() {
        return this.dtpConnectionProfile.saveWorkOfflineData();
    }

    public boolean canWorkOffline() {
        return this.dtpConnectionProfile.canWorkOffline();
    }

    public IStatus workOffline() {
        return this.dtpConnectionProfile.workOffline();
    }

    public synchronized void addConnectionListener(ConnectionListener listener) {
        if (this.hasNoListeners()) {
            this.startListening();
        }
        this.connectionListener.addConnectionListener(listener);
    }

    private void startListening() {
        this.dtpManagedConnection.addConnectionListener((IManagedConnectionListener)this.connectionListener);
        if (this.database != null && this.isConnected()) {
            this.database.startListening();
        }
    }

    public synchronized void removeConnectionListener(ConnectionListener listener) {
        this.connectionListener.removeConnectionListener(listener);
        if (this.hasNoListeners()) {
            this.stopListening();
        }
    }

    private void stopListening() {
        if (this.database != null && this.isConnected()) {
            this.database.stopListening();
        }
        this.dtpManagedConnection.removeConnectionListener((IManagedConnectionListener)this.connectionListener);
    }

    boolean hasNoListeners() {
        return this.connectionListener.hasNoListeners();
    }

    boolean hasAnyListeners() {
        return this.connectionListener.hasAnyListeners();
    }

    private void checkStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.checkStatus(child);
                ++n2;
            }
        }
        throw new RuntimeException(status.getMessage(), status.getException());
    }

    private DTPDatabaseWrapper buildDatabase() {
        return this.isInactive() ? null : new DTPDatabaseWrapper(this, this.buildDTPDatabase());
    }

    private Database buildDTPDatabase() {
        return this.isWorkingOffline() ? this.buildOfflineDTPDatabase() : this.buildLiveDTPDatabase();
    }

    private Database buildOfflineDTPDatabase() {
        return this.getConnectionInfo().getSharedDatabase();
    }

    private ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.dtpManagedConnection.getConnection().getRawConnection();
    }

    private Database buildLiveDTPDatabase() {
        return ProfileUtil.getDatabase((DatabaseIdentifier)new DatabaseIdentifier(this.getName(), this.getDatabaseName()), (boolean)true);
    }

    synchronized void clearDatabase() {
        if (this.database != null) {
            if (this.isConnected()) {
                this.database.stopListening();
            }
            this.database = null;
        }
    }

    public boolean treatIdentifiersAsDelimited() {
        return this.identifierAdapter.treatIdentifiersAsDelimited();
    }

    void databaseChanged(DTPDatabaseWrapper db) {
        this.connectionListener.databaseChanged(db);
    }

    void catalogChanged(DTPCatalogWrapper catalog) {
        this.connectionListener.catalogChanged(catalog);
    }

    void schemaChanged(DTPSchemaWrapper schema) {
        this.connectionListener.schemaChanged(schema);
    }

    void sequenceChanged(DTPSequenceWrapper sequence) {
        this.connectionListener.sequenceChanged(sequence);
    }

    void tableChanged(DTPTableWrapper table) {
        this.connectionListener.tableChanged(table);
    }

    void columnChanged(DTPColumnWrapper column) {
        this.connectionListener.columnChanged(column);
    }

    void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
        this.connectionListener.foreignKeyChanged(foreignKey);
    }

    private String getProperty(String propertyName) {
        return this.dtpConnectionProfile.getBaseProperties().getProperty(propertyName);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    private class LocalConnectionListener
    implements IManagedConnectionOfflineListener {
        private ListenerList<ConnectionListener> listenerList = new ListenerList(ConnectionListener.class);

        LocalConnectionListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listenerList.add((EventListener)listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listenerList.remove((EventListener)listener);
        }

        boolean hasNoListeners() {
            return this.listenerList.isEmpty();
        }

        boolean hasAnyListeners() {
            return !this.listenerList.isEmpty();
        }

        public void opened(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.opened(DTPConnectionProfileWrapper.this);
            }
        }

        public void modified(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.modified(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                if (listener.okToClose(DTPConnectionProfileWrapper.this)) continue;
                return false;
            }
            return true;
        }

        public void aboutToClose(ConnectEvent event) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.aboutToClose(DTPConnectionProfileWrapper.this);
            }
        }

        public void closed(ConnectEvent event) {
            DTPConnectionProfileWrapper.this.clearDatabase();
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.closed(DTPConnectionProfileWrapper.this);
            }
        }

        public boolean okToDetach(ConnectEvent event) {
            return this.okToClose(event);
        }

        public void aboutToDetach(ConnectEvent event) {
            this.closed(event);
        }

        public void workingOffline(ConnectEvent event) {
            this.opened(event);
        }

        public void aboutToAttach(ConnectEvent event) {
            this.closed(event);
        }

        void databaseChanged(DTPDatabaseWrapper db) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.databaseChanged(DTPConnectionProfileWrapper.this, db);
            }
        }

        void catalogChanged(DTPCatalogWrapper catalog) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.catalogChanged(DTPConnectionProfileWrapper.this, catalog);
            }
        }

        void schemaChanged(DTPSchemaWrapper schema) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.schemaChanged(DTPConnectionProfileWrapper.this, schema);
            }
        }

        void sequenceChanged(DTPSequenceWrapper sequence) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.sequenceChanged(DTPConnectionProfileWrapper.this, sequence);
            }
        }

        void tableChanged(DTPTableWrapper table) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.tableChanged(DTPConnectionProfileWrapper.this, table);
            }
        }

        void columnChanged(DTPColumnWrapper column) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.columnChanged(DTPConnectionProfileWrapper.this, column);
            }
        }

        void foreignKeyChanged(DTPForeignKeyWrapper foreignKey) {
            for (ConnectionListener listener : this.listenerList.getListeners()) {
                listener.foreignKeyChanged(DTPConnectionProfileWrapper.this, foreignKey);
            }
        }
    }
}

