/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionToolsTests
extends TestCase {
    private static String testStaticField;

    public ReflectionToolsTests(String name) {
        super(name);
    }

    public void testAllFields() {
        int fieldCount = 0;
        fieldCount += Vector.class.getDeclaredFields().length;
        fieldCount += AbstractList.class.getDeclaredFields().length;
        fieldCount += AbstractCollection.class.getDeclaredFields().length;
        Iterable fields = ReflectionTools.getAllFields(Vector.class);
        ReflectionToolsTests.assertEquals((int)(fieldCount += Object.class.getDeclaredFields().length), (int)CollectionTools.size((Iterable)fields));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.fieldNames(fields), (Object)"modCount"));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.fieldNames(fields), (Object)"serialVersionUID"));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.fieldNames(fields), (Object)"capacityIncrement"));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.fieldNames(fields), (Object)"elementCount"));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.fieldNames(fields), (Object)"elementData"));
        ReflectionToolsTests.assertTrue((boolean)((Field)fields.iterator().next()).isAccessible());
    }

    public void testAllMethods() {
        int methodCount = 0;
        methodCount += Vector.class.getDeclaredMethods().length;
        methodCount += AbstractList.class.getDeclaredMethods().length;
        methodCount += AbstractCollection.class.getDeclaredMethods().length;
        Iterable methods = ReflectionTools.getAllMethods(Vector.class);
        ReflectionToolsTests.assertEquals((int)(methodCount += Object.class.getDeclaredMethods().length), (int)CollectionTools.size((Iterable)methods));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.methodNames(methods), (Object)"wait"));
        ReflectionToolsTests.assertTrue((boolean)CollectionTools.contains(this.methodNames(methods), (Object)"addElement"));
        ReflectionToolsTests.assertTrue((boolean)((Method)methods.iterator().next()).isAccessible());
    }

    public void testNewInstanceClass() {
        Vector v = (Vector)ReflectionTools.newInstance(Vector.class);
        ReflectionToolsTests.assertNotNull((Object)v);
        ReflectionToolsTests.assertEquals((int)0, (int)v.size());
    }

    public void testNewInstanceClassClassObject() {
        int initialCapacity = 200;
        Vector v = (Vector)ReflectionTools.newInstance(Vector.class, Integer.TYPE, (Object)new Integer(initialCapacity));
        ReflectionToolsTests.assertNotNull((Object)v);
        ReflectionToolsTests.assertEquals((int)0, (int)v.size());
        Object[] elementData = (Object[])ReflectionTools.getFieldValue((Object)v, (String)"elementData");
        ReflectionToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
    }

    public void testNewInstanceClassClassArrayObjectArray() {
        boolean exCaught;
        block4: {
            int initialCapacity = 200;
            Class[] parmTypes = new Class[]{Integer.TYPE};
            Object[] parms = new Object[]{new Integer(initialCapacity)};
            Vector v = (Vector)ReflectionTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            ReflectionToolsTests.assertNotNull((Object)v);
            ReflectionToolsTests.assertEquals((int)0, (int)v.size());
            Object[] elementData = (Object[])ReflectionTools.getFieldValue((Object)v, (String)"elementData");
            ReflectionToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
            parms[0] = new Integer(-1);
            exCaught = false;
            try {
                v = (Vector)ReflectionTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
            ReflectionToolsTests.assertTrue((String)"RuntimeException not thrown", (boolean)exCaught);
            parmTypes[0] = String.class;
            parms[0] = "foo";
            exCaught = false;
            try {
                v = (Vector)ReflectionTools.newInstance(Vector.class, (Class[])parmTypes, (Object[])parms);
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)"NoSuchMethodException not thrown", (boolean)exCaught);
    }

    public void testFieldValue() {
        Object bogusFieldValue;
        boolean exCaught;
        block2: {
            int initialCapacity = 200;
            Vector v = new Vector(initialCapacity);
            Object[] elementData = (Object[])ReflectionTools.getFieldValue(v, (String)"elementData");
            ReflectionToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
            Integer modCountInteger = (Integer)ReflectionTools.getFieldValue(v, (String)"modCount");
            int modCount = modCountInteger;
            ReflectionToolsTests.assertEquals((int)0, (int)modCount);
            exCaught = false;
            bogusFieldValue = null;
            try {
                bogusFieldValue = ReflectionTools.getFieldValue(v, (String)"bogusField");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)("NoSuchFieldException not thrown: " + bogusFieldValue), (boolean)exCaught);
    }

    public void testExecuteMethodObjectString() {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ReflectionTools.executeMethod(v, (String)"size");
        ReflectionToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ReflectionTools.executeMethod(v, (String)"size");
        ReflectionToolsTests.assertEquals((int)1, (int)size);
    }

    public void testExecuteMethodObjectStringClassObject() {
        Vector v = new Vector();
        boolean booleanResult = (Boolean)ReflectionTools.executeMethod(v, (String)"add", Object.class, (Object)"foo");
        ReflectionToolsTests.assertTrue((boolean)booleanResult);
        ReflectionToolsTests.assertTrue((boolean)v.contains("foo"));
        Object voidResult = ReflectionTools.executeMethod(v, (String)"addElement", Object.class, (Object)"bar");
        ReflectionToolsTests.assertNull((Object)voidResult);
    }

    public void testExecuteMethodObjectStringClassArrayObjectArray() {
        Object bogusMethodReturnValue;
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Class[] parmTypes = new Class[]{Object.class};
            Object[] parms = new Object[]{"foo"};
            boolean booleanResult = (Boolean)ReflectionTools.executeMethod(v, (String)"add", (Class[])parmTypes, (Object[])parms);
            ReflectionToolsTests.assertTrue((boolean)booleanResult);
            ReflectionToolsTests.assertTrue((boolean)v.contains("foo"));
            exCaught = false;
            bogusMethodReturnValue = null;
            try {
                bogusMethodReturnValue = ReflectionTools.executeMethod(v, (String)"bogusMethod", (Class[])parmTypes, (Object[])parms);
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusMethodReturnValue), (boolean)exCaught);
    }

    public void testExecuteStaticMethodClassString() {
        Double randomObject = (Double)ReflectionTools.executeStaticMethod(Math.class, (String)"random");
        ReflectionToolsTests.assertNotNull((Object)randomObject);
        double random = randomObject;
        ReflectionToolsTests.assertTrue((random >= 0.0 ? 1 : 0) != 0);
        ReflectionToolsTests.assertTrue((random < 1.0 ? 1 : 0) != 0);
    }

    public void testExecuteStaticMethodClassStringClassObject() {
        String s = (String)ReflectionTools.executeStaticMethod(String.class, (String)"valueOf", Boolean.TYPE, (Object)Boolean.TRUE);
        ReflectionToolsTests.assertNotNull((Object)s);
        ReflectionToolsTests.assertEquals((String)"true", (String)s);
    }

    public void testExecuteStaticMethodClassStringClassArrayObjectArray() {
        Object bogusStaticMethodReturnValue;
        boolean exCaught;
        block5: {
            block4: {
                Class[] parmTypes = new Class[]{Boolean.TYPE};
                Object[] parms = new Object[]{Boolean.TRUE};
                String s = (String)ReflectionTools.executeStaticMethod(String.class, (String)"valueOf", (Class[])parmTypes, (Object[])parms);
                ReflectionToolsTests.assertNotNull((Object)s);
                ReflectionToolsTests.assertEquals((String)"true", (String)s);
                exCaught = false;
                bogusStaticMethodReturnValue = null;
                try {
                    bogusStaticMethodReturnValue = ReflectionTools.executeStaticMethod(String.class, (String)"bogusStaticMethod", (Class[])parmTypes, (Object[])parms);
                }
                catch (RuntimeException ex) {
                    if (!(ex.getCause() instanceof NoSuchMethodException)) break block4;
                    exCaught = true;
                }
            }
            ReflectionToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
            exCaught = false;
            try {
                bogusStaticMethodReturnValue = ReflectionTools.executeStaticMethod(String.class, (String)"toString");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block5;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusStaticMethodReturnValue), (boolean)exCaught);
    }

    public void testSetFieldValue() {
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Object[] newElementData = new Object[5];
            newElementData[0] = "foo";
            ReflectionTools.setFieldValue(v, (String)"elementData", (Object)newElementData);
            ReflectionTools.setFieldValue(v, (String)"elementCount", (Object)new Integer(1));
            ReflectionTools.setFieldValue(v, (String)"modCount", (Object)new Integer(1));
            ReflectionToolsTests.assertTrue((boolean)v.contains("foo"));
            exCaught = false;
            try {
                ReflectionTools.setFieldValue(v, (String)"bogusField", (Object)"foo");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testSetStaticFieldValue() {
        boolean exCaught;
        block2: {
            ReflectionTools.setStaticFieldValue(((Object)((Object)this)).getClass(), (String)"testStaticField", (Object)"new value");
            ReflectionToolsTests.assertEquals((String)testStaticField, (String)"new value");
            exCaught = false;
            try {
                ReflectionTools.setStaticFieldValue(((Object)((Object)this)).getClass(), (String)"bogusStaticField", (Object)"new value");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ReflectionToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }

    public void testSimpleName() {
        ReflectionToolsTests.assertEquals((String)"Vector", (String)Vector.class.getSimpleName());
        ReflectionToolsTests.assertEquals((String)"Entry", (String)Map.Entry.class.getSimpleName());
        ReflectionToolsTests.assertEquals((String)"int", (String)Integer.TYPE.getSimpleName());
        ReflectionToolsTests.assertEquals((String)"int[]", (String)int[].class.getSimpleName());
        ReflectionToolsTests.assertEquals((String)"int[][]", (String)int[][].class.getSimpleName());
        ReflectionToolsTests.assertEquals((String)"void", (String)Void.TYPE.getSimpleName());
    }

    public void testPackageName() {
        ReflectionToolsTests.assertEquals((String)"java.util", (String)Vector.class.getPackage().getName());
        ReflectionToolsTests.assertEquals((String)"java.util", (String)Map.Entry.class.getPackage().getName());
    }

    public void testArrayDepthFor() {
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepth(Vector.class));
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepth(Integer.TYPE));
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepth(Void.TYPE));
        ReflectionToolsTests.assertEquals((int)1, (int)ReflectionTools.getArrayDepth(Vector[].class));
        ReflectionToolsTests.assertEquals((int)1, (int)ReflectionTools.getArrayDepth(int[].class));
        ReflectionToolsTests.assertEquals((int)3, (int)ReflectionTools.getArrayDepth(Vector[][][].class));
        ReflectionToolsTests.assertEquals((int)3, (int)ReflectionTools.getArrayDepth(int[][][].class));
    }

    public void testElementTypeFor() {
        ReflectionToolsTests.assertEquals(Vector.class, (Object)ReflectionTools.getElementType(Vector.class));
        ReflectionToolsTests.assertEquals(Integer.TYPE, (Object)ReflectionTools.getElementType(Integer.TYPE));
        ReflectionToolsTests.assertEquals(Void.TYPE, (Object)ReflectionTools.getElementType(Void.TYPE));
        ReflectionToolsTests.assertEquals(Vector.class, (Object)ReflectionTools.getElementType(Vector[].class));
        ReflectionToolsTests.assertEquals(Integer.TYPE, (Object)ReflectionTools.getElementType(int[].class));
        ReflectionToolsTests.assertEquals(Vector.class, (Object)ReflectionTools.getElementType(Vector[][][].class));
        ReflectionToolsTests.assertEquals(Integer.TYPE, (Object)ReflectionTools.getElementType(int[][][].class));
    }

    public void testClassIsPrimitiveWrapperClass() {
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsPrimitiveWrapper(Void.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsPrimitiveWrapper(Boolean.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsPrimitiveWrapper(Integer.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsPrimitiveWrapper(Float.class));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsPrimitiveWrapper(String.class));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsPrimitiveWrapper(Void.TYPE));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsPrimitiveWrapper(Integer.TYPE));
    }

    public void testClassIsVariablePrimitiveWrapperClass() {
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Void.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Boolean.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Integer.class));
        ReflectionToolsTests.assertTrue((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Float.class));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(String.class));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Void.TYPE));
        ReflectionToolsTests.assertFalse((boolean)ReflectionTools.classIsVariablePrimitiveWrapper(Integer.TYPE));
    }

    public void testWrapperClass() {
        ReflectionToolsTests.assertEquals(Void.class, (Object)ReflectionTools.getWrapperClass(Void.TYPE));
        ReflectionToolsTests.assertEquals(Integer.class, (Object)ReflectionTools.getWrapperClass(Integer.TYPE));
        ReflectionToolsTests.assertEquals(Float.class, (Object)ReflectionTools.getWrapperClass(Float.TYPE));
        ReflectionToolsTests.assertEquals(Boolean.class, (Object)ReflectionTools.getWrapperClass(Boolean.TYPE));
        ReflectionToolsTests.assertNull((Object)ReflectionTools.getWrapperClass(String.class));
    }

    public void testClassForTypeDeclarationStringInt() throws Exception {
        ReflectionToolsTests.assertEquals(Integer.TYPE, (Object)ReflectionTools.getClassForTypeDeclaration((String)"int", (int)0));
        ReflectionToolsTests.assertEquals(int[].class, (Object)ReflectionTools.getClassForTypeDeclaration((String)"int", (int)1));
        ReflectionToolsTests.assertEquals(int[][][].class, (Object)ReflectionTools.getClassForTypeDeclaration((String)"int", (int)3));
        ReflectionToolsTests.assertEquals(Object.class, (Object)ReflectionTools.getClassForTypeDeclaration((String)"java.lang.Object", (int)0));
        ReflectionToolsTests.assertEquals(Object[][][].class, (Object)ReflectionTools.getClassForTypeDeclaration((String)"java.lang.Object", (int)3));
        ReflectionToolsTests.assertEquals(Void.TYPE, (Object)ReflectionTools.getClassForTypeDeclaration((String)"void", (int)0));
        try {
            ReflectionTools.getClassForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ReflectionToolsTests.fail((String)"should not get here...");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testCodeForClass() {
        ReflectionToolsTests.assertEquals((char)'I', (char)ReflectionTools.getCodeForClass(Integer.TYPE));
        ReflectionToolsTests.assertEquals((char)'B', (char)ReflectionTools.getCodeForClass(Byte.TYPE));
    }

    public void testClassNameForTypeDeclarationString() throws Exception {
        ReflectionToolsTests.assertEquals((String)"int", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int"));
        ReflectionToolsTests.assertEquals((String)"[I", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int[]"));
        ReflectionToolsTests.assertEquals((String)"[[I", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int [ ] [ ]"));
        ReflectionToolsTests.assertEquals((String)"java.lang.Object", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"java.lang.Object"));
        ReflectionToolsTests.assertEquals((String)"[Ljava.lang.Object;", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"java.lang.Object\t[]"));
        ReflectionToolsTests.assertEquals((String)"[[Ljava.lang.Object;", (String)ReflectionTools.getClassNameForTypeDeclaration((String)"java.lang.Object\t[]\t[]"));
    }

    public void testArrayDepthForTypeDeclarationString() throws Exception {
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"java.lang.Object"));
        ReflectionToolsTests.assertEquals((int)1, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"java.lang.Object[]"));
        ReflectionToolsTests.assertEquals((int)3, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"java.lang.Object[][][]"));
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"int"));
        ReflectionToolsTests.assertEquals((int)1, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"int[]"));
        ReflectionToolsTests.assertEquals((int)3, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"int[][][]"));
        ReflectionToolsTests.assertEquals((int)0, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"float"));
        ReflectionToolsTests.assertEquals((int)1, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"float [ ]"));
        ReflectionToolsTests.assertEquals((int)3, (int)ReflectionTools.getArrayDepthForTypeDeclaration((String)"float[] [] []"));
    }

    public void testElementTypeNameForTypeDeclarationString() throws Exception {
        ReflectionToolsTests.assertEquals((String)"java.lang.Object", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"java.lang.Object"));
        ReflectionToolsTests.assertEquals((String)"java.lang.Object", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"java.lang.Object[]"));
        ReflectionToolsTests.assertEquals((String)"java.lang.Object", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"java.lang.Object[][][]"));
        ReflectionToolsTests.assertEquals((String)"int", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"int"));
        ReflectionToolsTests.assertEquals((String)"int", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"int[]"));
        ReflectionToolsTests.assertEquals((String)"int", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"int[][][]"));
        ReflectionToolsTests.assertEquals((String)"float", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"float"));
        ReflectionToolsTests.assertEquals((String)"float", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"float [ ]"));
        ReflectionToolsTests.assertEquals((String)"float", (String)ReflectionTools.getElementTypeNameForTypeDeclaration((String)"float[] [] []"));
    }

    public void testClassNameForTypeDeclarationStringInt() throws Exception {
        ReflectionToolsTests.assertEquals((String)Integer.TYPE.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int", (int)0));
        ReflectionToolsTests.assertEquals((String)int[].class.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int", (int)1));
        ReflectionToolsTests.assertEquals((String)int[][][].class.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"int", (int)3));
        ReflectionToolsTests.assertEquals((String)Object.class.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"java.lang.Object", (int)0));
        ReflectionToolsTests.assertEquals((String)Object[][][].class.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"java.lang.Object", (int)3));
        ReflectionToolsTests.assertEquals((String)Void.TYPE.getName(), (String)ReflectionTools.getClassNameForTypeDeclaration((String)"void", (int)0));
        try {
            ReflectionTools.getClassNameForTypeDeclaration((String)Void.TYPE.getName(), (int)1);
            ReflectionToolsTests.fail((String)"should not get here...");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private Iterable<String> fieldNames(Iterable<Field> fields) {
        return new TransformationIterable<Field, String>(fields){

            protected String transform(Field field) {
                return field.getName();
            }
        };
    }

    private Iterable<String> methodNames(Iterable<Method> methods) {
        return new TransformationIterable<Method, String>(methods){

            protected String transform(Method method) {
                return method.getName();
            }
        };
    }
}

