/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import org.eclipse.jpt.common.utility.internal.SynchronizedObject;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObjectTests
extends MultiThreadedTestCase {
    private volatile SynchronizedObject<Object> so;
    volatile boolean timeoutOccurred;
    volatile Object value = new Object();
    volatile long startTime;
    volatile long endTime;
    volatile Object soValue;

    public SynchronizedObjectTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.so = new SynchronizedObject();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.soValue = null;
    }

    public void testAccessors() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNull());
        this.so.setNull();
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        SynchronizedObjectTests.assertSame(this.so, (Object)this.so.getMutex());
    }

    public void testWaitUntilNull() throws Exception {
        this.verifyWaitUntilNull(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNullTimeout() throws Exception {
        this.verifyWaitUntilNull(TICK);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilNull(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitUntilNullCommand(t2Timeout));
    }

    public void testWaitToSetValue() throws Exception {
        this.verifyWaitToSetValue(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout() throws Exception {
        this.verifyWaitToSetValue(TICK);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetValue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitToSetValueCommand(t2Timeout));
    }

    public void testExecute() throws Exception {
        this.so.setValue(null);
        Runnable r1 = this.buildRunnable(this.buildInitializeValueCommand(), this.so, 0L);
        Runnable r2 = this.buildRunnable(this.buildGetValueCommand(), this.so, TICK);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.soValue);
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TWO_TICKS + "): " + time), (time > TWO_TICKS ? 1 : 0) != 0);
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.so.setValue(this.value);
        Runnable r1 = this.buildRunnable(t1Command, this.so, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.so, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetNullCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) {
                sObject.setNull();
            }
        };
    }

    private Command buildWaitUntilNullCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.timeoutOccurred = !sObject.waitUntilNull(timeout);
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildWaitToSetValueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.timeoutOccurred = !sObject.waitToSetValue(SynchronizedObjectTests.this.value, timeout);
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Command buildInitializeValueCommand() {
        return new Command(){

            @Override
            public void execute(final SynchronizedObject<Object> sObject) throws InterruptedException {
                sObject.execute(new org.eclipse.jpt.common.utility.Command(){

                    public void execute() {
                        try {
                            Thread.sleep(5L * TICK);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        sObject.setValue((Object)"foo");
                    }
                });
            }
        };
    }

    private Command buildGetValueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.soValue = sObject.getValue();
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedObject<Object> sObject, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            protected void run_() throws InterruptedException {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedObject<Object>)sObject);
            }
        };
    }

    private long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Command {
        public void execute(SynchronizedObject<Object> var1) throws InterruptedException;
    }
}

