/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListCurator;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListCuratorTests
extends TestCase {
    private TestSubject subject1;
    private WritablePropertyValueModel<TestSubject> subjectHolder1;
    private ListCurator<TestSubject, String> curator;
    private ListChangeListener listener1;
    private ListEvent event1;
    private TestSubject subject2;

    public ListCuratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject(this.subject1Names());
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.curator = this.buildListCurator((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildListChangeListener1();
        this.curator.addListChangeListener("list values", this.listener1);
        this.event1 = null;
        this.subject2 = new TestSubject(this.subject2Names());
    }

    private List<String> subject1Names() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("alpha");
        list.add("bravo");
        list.add("charlie");
        list.add("delta");
        return list;
    }

    private List<String> subject2Names() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("echo");
        list.add("foxtrot");
        list.add("glove");
        list.add("hotel");
        return list;
    }

    private ListCurator<TestSubject, String> buildListCurator(PropertyValueModel<TestSubject> subjectHolder) {
        return new ListCurator<TestSubject, String>(subjectHolder){

            public Iterator<String> iteratorForRecord() {
                return ((TestSubject)((Object)this.subject)).strings();
            }
        };
    }

    private ListChangeListener buildListChangeListener1() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }
        };
    }

    void value1Changed(ListEvent e) {
        this.event1 = e;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        ListCuratorTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals(this.subject2Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        this.event1 = null;
        this.subjectHolder1.setValue(null);
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertFalse((boolean)this.curator.iterator().hasNext());
        this.event1 = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
    }

    public void testAdd() {
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        ListCuratorTests.assertNull((Object)this.event1);
        this.subject1.addString("echo");
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals((int)this.subject1Names().size(), (int)((ListAddEvent)this.event1).getIndex());
        ListCuratorTests.assertEquals((Object)"echo", ((ListAddEvent)this.event1).getItems().iterator().next());
        List<String> stringsPlus = this.subject1Names();
        stringsPlus.add("echo");
        ListCuratorTests.assertEquals(stringsPlus, (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        this.event1 = null;
        this.subject1.addString(0, "zulu");
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals((int)0, (int)((ListAddEvent)this.event1).getIndex());
        ListCuratorTests.assertEquals((Object)"zulu", ((ListAddEvent)this.event1).getItems().iterator().next());
        stringsPlus.add(0, "zulu");
        ListCuratorTests.assertEquals(stringsPlus, (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
    }

    public void testRemove() {
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        ListCuratorTests.assertNull((Object)this.event1);
        String removedString = this.subject1.removeString(0);
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals((int)0, (int)((ListRemoveEvent)this.event1).getIndex());
        ListCuratorTests.assertEquals((Object)removedString, ((ListRemoveEvent)this.event1).getItems().iterator().next());
        List<String> stringsMinus = this.subject1Names();
        stringsMinus.remove(0);
        ListCuratorTests.assertEquals(stringsMinus, (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        removedString = this.subject1.removeString(2);
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals((int)2, (int)((ListRemoveEvent)this.event1).getIndex());
        ListCuratorTests.assertEquals((Object)removedString, ((ListRemoveEvent)this.event1).getItems().iterator().next());
        stringsMinus.remove(2);
        ListCuratorTests.assertEquals(stringsMinus, (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
    }

    public void testCompleteListChange() {
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
        ListCuratorTests.assertNull((Object)this.event1);
        this.subject1.setStrings(this.subject2Names());
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        List<String> newStrings = this.subject2Names();
        ListCuratorTests.assertEquals(newStrings, (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
    }

    public void testPartialListChange() {
        ArrayList startingList = CollectionTools.list((Iterator)this.curator.listIterator());
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)startingList);
        ListCuratorTests.assertNull((Object)this.event1);
        String identicalString = (String)startingList.get(1);
        String nonidenticalString = (String)startingList.get(0);
        ArrayList newStrings = CollectionTools.list((Object[])new String[]{new String("bravo"), new String("alpha"), "echo", "delta", "foxtrot"});
        this.subject1.setStrings(newStrings);
        ArrayList finalList = CollectionTools.list((Iterator)this.curator.listIterator());
        ListCuratorTests.assertNotNull((Object)this.event1);
        ListCuratorTests.assertEquals(this.curator, (Object)this.event1.getSource());
        ListCuratorTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListCuratorTests.assertEquals((Object)newStrings, (Object)finalList);
        ListCuratorTests.assertTrue((identicalString == finalList.get(0) ? 1 : 0) != 0);
        ListCuratorTests.assertTrue((nonidenticalString != finalList.get(1) ? 1 : 0) != 0);
    }

    public void testIterator() {
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list(this.subject1.strings()));
        ListCuratorTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.curator.listIterator()));
    }

    public void testGet() {
        ListCuratorTests.assertEquals((String)this.subject1Names().get(0), (String)this.subject1.getString(0));
        ListCuratorTests.assertEquals((String)this.subject1Names().get(0), (String)((String)this.curator.get(0)));
    }

    public void testSize() {
        ListCuratorTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size(this.subject1.strings()));
        ListCuratorTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size((Iterator)this.curator.listIterator()));
        ListCuratorTests.assertEquals((int)this.subject1Names().size(), (int)this.curator.size());
    }

    public void testHasListeners() {
        ListCuratorTests.assertTrue((boolean)this.curator.hasAnyListChangeListeners("list values"));
        ListCuratorTests.assertTrue((boolean)this.subject1.hasAnyStateChangeListeners());
        this.curator.removeListChangeListener("list values", this.listener1);
        ListCuratorTests.assertFalse((boolean)this.subject1.hasAnyStateChangeListeners());
        ListCuratorTests.assertFalse((boolean)this.curator.hasAnyListChangeListeners("list values"));
        ChangeListener listener2 = this.buildChangeListener();
        this.curator.addChangeListener(listener2);
        ListCuratorTests.assertTrue((boolean)this.curator.hasAnyListChangeListeners("list values"));
        ListCuratorTests.assertTrue((boolean)this.subject1.hasAnyStateChangeListeners());
        this.curator.removeChangeListener(listener2);
        ListCuratorTests.assertFalse((boolean)this.subject1.hasAnyStateChangeListeners());
        ListCuratorTests.assertFalse((boolean)this.curator.hasAnyListChangeListeners("list values"));
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(ListAddEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                ListCuratorTests.this.value1Changed((ListEvent)e);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestSubject
    extends AbstractModel {
        private List<String> strings = new ArrayList<String>();

        public TestSubject() {
        }

        public TestSubject(List<String> strings) {
            this();
            this.setStrings(strings);
        }

        public String getString(int index) {
            return this.strings.get(index);
        }

        public ListIterator<String> strings() {
            return new ReadOnlyListIterator(this.strings);
        }

        public void addString(int index, String string) {
            this.strings.add(index, string);
            this.fireStateChanged();
        }

        public void addString(String string) {
            this.addString(this.strings.size(), string);
        }

        public String removeString(int index) {
            String string = this.strings.get(index);
            this.removeString(string);
            return string;
        }

        public void removeString(String string) {
            this.strings.remove(string);
            this.fireStateChanged();
        }

        public void setStrings(List<String> strings) {
            this.strings = new ArrayList<String>(strings);
            this.fireStateChanged();
        }

        public void setStrings(String[] strings) {
            this.strings = CollectionTools.list((Object[])strings);
            this.fireStateChanged();
        }
    }
}

