/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToManyUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRelationFeaturesTest {
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        Thread.sleep(2000L);
    }

    @Test
    public void testCreateOneToOneUniDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateOneToOneUniDirRelationFeature ft = new CreateOneToOneUniDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        cu1.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        cu2.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        OneToOneUniDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.ONE_TO_ONE, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.UNI, (Object)rel.getRelDir());
        Assert.assertSame((Object)rel.getOwner(), (Object)t1);
        Assert.assertSame((Object)rel.getInverse(), (Object)t2);
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
        Assert.assertTrue((boolean)JpaArtifactFactory.instance().isMethodAnnotated(t1));
        JavaPersistentAttribute jpa = t1.getAttributeNamed("id");
        Assert.assertFalse((boolean)JpaArtifactFactory.instance().isRelationAnnotated(jpa));
        jpa = t1.getAttributeNamed(rel.getOwnerAttributeName());
        Assert.assertTrue((boolean)JpaArtifactFactory.instance().isRelationAnnotated(jpa));
    }

    @Test
    public void testCreateOneToOneBiDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateOneToOneBiDirRelationFeature ft = new CreateOneToOneBiDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        OneToOneBiDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.ONE_TO_ONE, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.BI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
        Assert.assertNotNull((Object)t2.getAttributeNamed(rel.getInverseAttributeName()));
    }

    @Test
    public void testCreateManyToOneUniDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateManyToOneUniDirRelationFeature ft = new CreateManyToOneUniDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        ManyToOneUniDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.MANY_TO_ONE, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.UNI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
    }

    @Test
    public void testCreateManyToOneBiDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateManyToOneBiDirRelationFeature ft = new CreateManyToOneBiDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        ManyToOneBiDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.MANY_TO_ONE, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.BI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
        Assert.assertNotNull((Object)t2.getAttributeNamed(rel.getInverseAttributeName()));
    }

    @Test
    public void testCreateOneToManyUniDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateOneToManyUniDirRelationFeature ft = new CreateOneToManyUniDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        OneToManyUniDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.ONE_TO_MANY, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.UNI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
    }

    @Test
    public void testCreateManyToManyUniDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateManyToManyUniDirRelationFeature ft = new CreateManyToManyUniDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        ManyToManyUniDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.MANY_TO_MANY, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.UNI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
    }

    @Test
    public void testCreateManyToManyBiDirRelationFeature() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.test.Address");
        Assert.assertNotNull((Object)addressType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        CreateManyToManyBiDirRelationFeature ft = new CreateManyToManyBiDirRelationFeature(featureProvider);
        ICreateConnectionContext ctx = (ICreateConnectionContext)EasyMock.createMock(ICreateConnectionContext.class);
        ContainerShape cs1 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        ContainerShape cs2 = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs1)).andStubReturn((Object)t1);
        EasyMock.expect((Object)featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs2)).andStubReturn((Object)t2);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t1)).andStubReturn((Object)cs1);
        EasyMock.expect((Object)featureProvider.getPictogramElementForBusinessObject((Object)t2)).andStubReturn((Object)cs2);
        Anchor a1 = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor a2 = (Anchor)EasyMock.createMock(Anchor.class);
        EasyMock.expect((Object)a1.getParent()).andStubReturn((Object)cs1);
        EasyMock.expect((Object)a2.getParent()).andStubReturn((Object)cs2);
        EasyMock.expect((Object)ctx.getSourceAnchor()).andStubReturn((Object)a1);
        EasyMock.expect((Object)ctx.getTargetAnchor()).andStubReturn((Object)a2);
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        ICompilationUnit cu2 = this.createCompilationUnitFrom(addressFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t2)).andStubReturn((Object)cu2);
        Connection conn = (Connection)EasyMock.createMock(Connection.class);
        EasyMock.expect((Object)featureProvider.addIfPossible((IAddContext)EasyMock.anyObject())).andStubReturn((Object)conn);
        EasyMock.replay((Object[])new Object[]{featureProvider, a1, a2, cs1, cs2, ctx});
        ft.create(ctx);
        ManyToManyBiDirRelation rel = ft.createRelation(featureProvider, (PictogramElement)cs1, (PictogramElement)cs2);
        Assert.assertNotNull((Object)rel);
        Assert.assertNotNull((Object)rel.getId());
        Assert.assertEquals((Object)IRelation.RelType.MANY_TO_MANY, (Object)rel.getRelType());
        Assert.assertEquals((Object)IRelation.RelDir.BI, (Object)rel.getRelDir());
        Assert.assertNotNull((Object)t1.getAttributeNamed(rel.getOwnerAttributeName()));
        Assert.assertNotNull((Object)t2.getAttributeNamed(rel.getInverseAttributeName()));
    }

    public static JavaPersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = CreateRelationFeaturesTest.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            JavaPersistentType entity = (JavaPersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }
}

