/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.FieldPartitioningPolicy;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashPartitioningPolicy
extends FieldPartitioningPolicy {
    protected List<String> connectionPools = new ArrayList<String>();

    public HashPartitioningPolicy() {
    }

    public HashPartitioningPolicy(String partitionField) {
        super(partitionField);
    }

    public HashPartitioningPolicy(String partitionField, boolean unionUnpartitionableQueries) {
        super(partitionField, unionUnpartitionableQueries);
    }

    @Override
    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (this.getConnectionPools().isEmpty() && session.isServerSession()) {
            this.getConnectionPools().addAll(((ServerSession)session).getConnectionPools().keySet());
        }
    }

    public List<String> getConnectionPools() {
        return this.connectionPools;
    }

    public void setConnectionPools(List<String> connectionPools) {
        this.connectionPools = connectionPools;
    }

    public void addConnectionPool(String connectionPool) {
        this.getConnectionPools().add(connectionPool);
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        Object value = arguments.get(this.partitionField);
        if (value == null) {
            if (this.unionUnpartitionableQueries) {
                ArrayList<Accessor> accessors = new ArrayList<Accessor>(this.connectionPools.size());
                for (String poolName : this.connectionPools) {
                    accessors.add(this.getAccessor(poolName, session, query, false));
                }
                return accessors;
            }
            return null;
        }
        int index = value.hashCode() % this.connectionPools.size();
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(index);
            return null;
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(1);
        String poolName = this.connectionPools.get(index);
        accessors.add(this.getAccessor(poolName, session, query, false));
        return accessors;
    }

    @Override
    public void partitionPersist(AbstractSession session, Object object, ClassDescriptor descriptor) {
        Object value = this.extractPartitionValueForPersist(session, object, descriptor);
        if (value == null) {
            return;
        }
        int index = value.hashCode() % this.connectionPools.size();
        if (session.getPlatform().hasPartitioningCallback()) {
            session.getPlatform().getPartitioningCallback().setPartitionId(index);
        } else {
            String poolName = this.connectionPools.get(index);
            this.getAccessor(poolName, session, null, false);
        }
    }
}

