/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAnnotation
extends SourceNode
implements Annotation {
    protected final AnnotatedElement annotatedElement;
    protected DeclarationAnnotationAdapter daa;
    protected AnnotationAdapter annotationAdapter;

    protected SourceAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, new ElementAnnotationAdapter(element, daa));
    }

    protected SourceAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.annotatedElement = element;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getAnnotationTextRange(astRoot);
    }

    @Override
    public org.eclipse.jdt.core.dom.Annotation getAstAnnotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    @Override
    public void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    @Override
    public boolean isUnset() {
        return true;
    }

    protected DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(this.daa, elementName);
    }

    protected DeclarationAnnotationElementAdapter<Boolean> buildBooleanElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans(this.daa, elementName);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildIntegerElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forNumbers(this.daa, elementName);
    }

    protected AnnotationElementAdapter<String> buildStringElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter<String>(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Boolean> buildBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter<Boolean>(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerElementAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new AnnotatedElementAnnotationElementAdapter<Integer>(this.annotatedElement, daea);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return astRoot == null ? null : this.getTextRange((ASTNode)this.getAstAnnotation(astRoot));
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getAnnotationTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.textRangeTouches(this.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean textRangeTouches(TextRange textRange, int pos) {
        return textRange != null && textRange.touches(pos);
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return astRoot == null ? null : this.getTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astRoot));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    protected TextRange getAnnotationElementSubvalueTextRange(IndexedDeclarationAnnotationElementAdapter<?> adapter, int index, CompilationUnit astRoot) {
        return astRoot == null ? null : this.getTextRange((ASTNode)this.getAnnotationElementSubvalueExpression(adapter, index, astRoot));
    }

    protected Expression getAnnotationElementSubvalueExpression(IndexedDeclarationAnnotationElementAdapter<?> adapter, int index, CompilationUnit astRoot) {
        return adapter.getSubvalueExpression(index, this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : ASTTools.buildTextRange(astNode);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AnnotationContainer<T extends NestableAnnotation>
    extends SourceNode.AnnotationContainer<T> {
        protected AnnotationContainer() {
            super(SourceAnnotation.this);
        }

        protected abstract String getAnnotationsPropertyName();

        @Override
        protected void fireItemAdded(int index, T addedItem) {
            SourceAnnotation.this.fireItemAdded(this.getAnnotationsPropertyName(), index, addedItem);
        }

        @Override
        protected void fireItemsRemoved(int index, List<T> removedItems) {
            SourceAnnotation.this.fireItemsRemoved(this.getAnnotationsPropertyName(), index, removedItems);
        }
    }
}

