/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceEnumConstant;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.Enum;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.internal.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceEnum
extends SourceAbstractType<Enum>
implements JavaResourceEnum {
    private final Vector<JavaResourceEnumConstant> enumConstants = new Vector();

    static JavaResourceEnum newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, EnumDeclaration enumDeclaration, CompilationUnit astRoot) {
        JDTEnum _enum = new JDTEnum(enumDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceEnum jre = new SourceEnum(javaResourceCompilationUnit, _enum);
        jre.initialize(astRoot);
        return jre;
    }

    protected static JavaResourceEnum newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, EnumDeclaration enumDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTEnum _enum = new JDTEnum(declaringType, enumDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourceEnum jre = new SourceEnum(javaResourceCompilationUnit, _enum);
        jre.initialize(astRoot);
        return jre;
    }

    private SourceEnum(JavaResourceCompilationUnit javaResourceCompilationUnit, Enum _enum) {
        super(javaResourceCompilationUnit, _enum);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.initializeEnumConstants(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncEnumConstants(astRoot);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        for (JavaResourceEnumConstant enumConstant : this.getEnumConstants()) {
            enumConstant.resolveTypes(astRoot);
        }
    }

    @Override
    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.ENUM;
    }

    @Override
    public Iterable<JavaResourceEnumConstant> getEnumConstants() {
        return new LiveCloneIterable(this.enumConstants);
    }

    private void addEnumConstant(JavaResourceEnumConstant enumConstant) {
        this.addItemToCollection(enumConstant, this.enumConstants, "enumConstants");
    }

    private JavaResourceEnumConstant getEnumConstant(String fieldName, int occurrence) {
        for (JavaResourceEnumConstant enumConstant : this.getEnumConstants()) {
            if (!enumConstant.isFor(fieldName, occurrence)) continue;
            return enumConstant;
        }
        return null;
    }

    private void removeEnumConstants(Collection<JavaResourceEnumConstant> remove) {
        this.removeItemsFromCollection(remove, this.enumConstants, "enumConstants");
    }

    private void initializeEnumConstants(CompilationUnit astRoot) {
        EnumConstantDeclaration[] enumConstantDeclarations = ((Enum)this.annotatedElement).getEnumConstants(astRoot);
        CounterMap counters = new CounterMap(enumConstantDeclarations.length);
        EnumConstantDeclaration[] enumConstantDeclarationArray = enumConstantDeclarations;
        int n = enumConstantDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            EnumConstantDeclaration enumConstantDeclaration = enumConstantDeclarationArray[n2];
            String constantName = enumConstantDeclaration.getName().getFullyQualifiedName();
            int occurrence = counters.increment(constantName);
            this.enumConstants.add(this.buildEnumConstant(constantName, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncEnumConstants(CompilationUnit astRoot) {
        EnumConstantDeclaration[] enumConstantDeclarations = ((Enum)this.annotatedElement).getEnumConstants(astRoot);
        CounterMap counters = new CounterMap(enumConstantDeclarations.length);
        HashSet<JavaResourceEnumConstant> enumConstantsToRemove = new HashSet<JavaResourceEnumConstant>(this.enumConstants);
        EnumConstantDeclaration[] enumConstantDeclarationArray = enumConstantDeclarations;
        int n = enumConstantDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            EnumConstantDeclaration enumConstantDeclaration = enumConstantDeclarationArray[n2];
            String constantName = enumConstantDeclaration.getName().getFullyQualifiedName();
            JavaResourceEnumConstant enumConstant = this.getEnumConstant(constantName, occurrence = counters.increment(constantName));
            if (enumConstant == null) {
                this.addEnumConstant(this.buildEnumConstant(constantName, occurrence, astRoot));
            } else {
                enumConstantsToRemove.remove(enumConstant);
                enumConstant.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeEnumConstants(enumConstantsToRemove);
    }

    private JavaResourceEnumConstant buildEnumConstant(String fieldName, int occurrence, CompilationUnit astRoot) {
        return SourceEnumConstant.newInstance(this, (Enum)this.annotatedElement, fieldName, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    @Override
    public Iterable<JavaResourceType> getTypes() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceType> getAllTypes() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceEnum> getEnums() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<JavaResourceEnum> getAllEnums() {
        return new SingleElementIterable((Object)this);
    }

    private static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

