/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaElementQName
extends AbstractJavaQName {
    public AbstractJavaElementQName(JavaContextNode parent, AbstractJavaQName.AnnotationProxy proxy) {
        super(parent, proxy);
    }

    @Override
    public String getReferencedComponentTypeDescription() {
        return JptJaxbCoreMessages.XML_ELEMENT_DESC;
    }

    protected abstract JaxbPersistentAttribute getPersistentAttribute();

    protected JaxbClassMapping getJaxbClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    @Override
    protected JaxbPackage getJaxbPackage() {
        return this.getJaxbClassMapping().getJaxbType().getJaxbPackage();
    }

    protected abstract XmlElementWrapper getElementWrapper();

    @Override
    public String getDefaultName() {
        return this.getPersistentAttribute().getJavaResourceAttribute().getName();
    }

    @Override
    public Iterable<String> getNameProposals(Filter<String> filter) {
        XsdTypeDefinition xsdType = this.getJaxbClassMapping().getXsdTypeDefinition();
        if (xsdType == null) {
            return EmptyIterable.instance();
        }
        XmlElementWrapper elementWrapper = this.getElementWrapper();
        if (elementWrapper == null) {
            return xsdType.getElementNameProposals(this.getNamespace(), filter);
        }
        XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
        if (xsdWrapperElement != null) {
            return xsdWrapperElement.getElementNameProposals(this.getNamespace(), filter);
        }
        return EmptyIterable.instance();
    }

    @Override
    public String getDefaultNamespace() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage != null && jaxbPackage.getElementFormDefault() == XmlNsForm.QUALIFIED ? this.getJaxbClassMapping().getQName().getNamespace() : "";
    }

    @Override
    public Iterable<String> getNamespaceProposals(Filter<String> filter) {
        XsdSchema schema = this.getXsdSchema();
        return schema == null ? EmptyIterable.instance() : schema.getNamespaceProposals(filter);
    }

    @Override
    protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        XsdTypeDefinition xsdType = this.getJaxbClassMapping().getXsdTypeDefinition();
        if (xsdType == null) {
            return;
        }
        XsdElementDeclaration resolvedXsdElement = null;
        XmlElementWrapper elementWrapper = this.getElementWrapper();
        if (elementWrapper == null) {
            resolvedXsdElement = xsdType.getElement(this.getNamespace(), this.getName());
        } else {
            XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
            if (xsdWrapperElement == null) {
                return;
            }
            resolvedXsdElement = xsdWrapperElement.getElement(this.getNamespace(), this.getName());
        }
        if (resolvedXsdElement == null) {
            messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
        }
    }
}

