/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaElementQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElement
extends AbstractJavaContextNode
implements XmlElement {
    protected final Context context;
    protected final JaxbQName qName;
    protected Boolean specifiedNillable;
    protected boolean defaultNillable;
    protected Boolean specifiedRequired;
    protected String defaultValue;
    protected String specifiedType;
    protected String defaultType;

    public GenericJavaXmlElement(JavaContextNode parent, Context context) {
        super(parent);
        this.context = context;
        this.qName = this.buildQName();
        this.specifiedNillable = this.buildSpecifiedNillable();
        this.defaultNillable = this.buildDefaultNillable();
        this.specifiedRequired = this.buildSpecifiedRequired();
        this.defaultValue = this.buildDefaultValue();
        this.specifiedType = this.buildSpecifiedType();
        this.defaultType = this.buildDefaultType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedNillable_(this.buildSpecifiedNillable());
        this.setDefaultNillable_(this.buildDefaultNillable());
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
        this.setDefaultValue_(this.buildDefaultValue());
        this.setSpecifiedType_(this.buildSpecifiedType());
        this.setDefaultType_(this.buildDefaultType());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public JavaContextNode getParent() {
        return (JavaContextNode)super.getParent();
    }

    protected Context getContext() {
        return this.context;
    }

    protected JaxbPersistentAttribute getPersistentAttribute() {
        return this.getContext().getAttributeMapping().getPersistentAttribute();
    }

    protected JaxbClassMapping getJaxbClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getJaxbClassMapping().getJaxbType().getJaxbPackage();
    }

    @Override
    public XmlElementAnnotation getAnnotation(boolean createIfNull) {
        return this.context.getAnnotation(createIfNull);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlElementQName(this);
    }

    @Override
    public boolean isNillable() {
        return this.specifiedNillable == null ? this.isDefaultNillable() : this.getSpecifiedNillable().booleanValue();
    }

    @Override
    public Boolean getSpecifiedNillable() {
        return this.specifiedNillable;
    }

    @Override
    public void setSpecifiedNillable(Boolean newSpecifiedNillable) {
        this.getAnnotation(true).setNillable(newSpecifiedNillable);
        this.setSpecifiedNillable_(newSpecifiedNillable);
    }

    protected void setSpecifiedNillable_(Boolean newSpecifiedNillable) {
        Boolean oldNillable = this.specifiedNillable;
        this.specifiedNillable = newSpecifiedNillable;
        this.firePropertyChanged("specifiedNillable", oldNillable, newSpecifiedNillable);
    }

    protected Boolean buildSpecifiedNillable() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getNillable();
    }

    @Override
    public boolean isDefaultNillable() {
        return this.defaultNillable;
    }

    protected void setDefaultNillable_(boolean newNillable) {
        boolean oldNillable = this.defaultNillable;
        this.defaultNillable = newNillable;
        this.firePropertyChanged("defaultNillable", oldNillable, newNillable);
    }

    protected boolean buildDefaultNillable() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getPersistentAttribute().isJavaResourceAttributeCollectionType() : false;
    }

    @Override
    public boolean isRequired() {
        return this.specifiedRequired == null ? this.isDefaultRequired() : this.specifiedRequired.booleanValue();
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        this.getAnnotation(true).setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getRequired();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.getAnnotation(true).setDefaultValue(defaultValue);
        this.setDefaultValue_(defaultValue);
    }

    protected void setDefaultValue_(String defaultValue) {
        String oldDefaultValue = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChanged("defaultValue", oldDefaultValue, defaultValue);
    }

    protected String buildDefaultValue() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getDefaultValue();
    }

    @Override
    public String getType() {
        return this.specifiedType == null ? this.getDefaultType() : this.specifiedType;
    }

    @Override
    public String getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(String newSpecifiedType) {
        this.getAnnotation(true).setType(newSpecifiedType);
        this.setSpecifiedType_(newSpecifiedType);
    }

    protected void setSpecifiedType_(String newSpecifiedType) {
        String oldType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", oldType, newSpecifiedType);
    }

    protected String buildSpecifiedType() {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? null : annotation.getType();
    }

    @Override
    public String getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType_(String newType) {
        String oldType = this.defaultType;
        this.defaultType = newType;
        this.firePropertyChanged("defaultType", oldType, newType);
    }

    protected String buildDefaultType() {
        return this.context.getDefaultType();
    }

    @Override
    public String getFullyQualifiedType() {
        return this.specifiedType == null ? this.getDefaultType() : this.getAnnotation(false).getFullyQualifiedTypeName();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return this.specifiedType == null ? EmptyIterable.instance() : new SingleElementIterable((Object)this.getFullyQualifiedType());
    }

    @Override
    public XsdElementDeclaration getXsdElement() {
        XsdTypeDefinition xsdType = this.getJaxbClassMapping().getXsdTypeDefinition();
        return xsdType == null ? null : xsdType.getElement(this.qName.getNamespace(), this.qName.getName());
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getParent().getValidationTextRange(astRoot) : annotation.getTextRange(astRoot);
    }

    @Override
    public TextRange getTypeTextRange(CompilationUnit astRoot) {
        XmlElementAnnotation annotation = this.getAnnotation(false);
        return annotation == null ? this.getParent().getValidationTextRange(astRoot) : annotation.getTypeTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.qName.validate(messages, reporter, astRoot);
        this.validateType(messages, reporter, astRoot);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        String fqType = this.getFullyQualifiedType();
        if (StringTools.stringIsEmpty((String)fqType)) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT__UNSPECIFIED_TYPE", this, this.getTypeTextRange(astRoot)));
        } else if (!StringTools.stringIsEmpty((String)this.specifiedType) && JDTTools.findType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType) != null) {
            String attributeBaseType = this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
            if (!JDTTools.typeIsSubType((IJavaProject)this.getJaxbProject().getJavaProject(), (String)fqType, (String)attributeBaseType)) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT__ILLEGAL_TYPE", new String[]{attributeBaseType}, this, this.getTypeTextRange(astRoot)));
            }
        }
    }

    public static interface Context {
        public JaxbAttributeMapping getAttributeMapping();

        public XmlElementAnnotation getAnnotation(boolean var1);

        public String getDefaultType();

        public XmlElementWrapper getElementWrapper();
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaXmlElement.this.getAnnotation(createIfNull);
        }
    }

    protected class XmlElementQName
    extends AbstractJavaElementQName {
        protected XmlElementQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        protected JaxbPersistentAttribute getPersistentAttribute() {
            return GenericJavaXmlElement.this.getPersistentAttribute();
        }

        protected XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElement.this.context.getElementWrapper();
        }
    }
}

