/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.BidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ManyToManyBiDirRelation
extends ManyToManyRelation
implements BidirectionalRelation {
    public ManyToManyBiDirRelation(IJPAEditorFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, String inverseAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        this.inverseAttributeName = inverseAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    public JavaPersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    public void setOwnerAnnotatedAttribute(JavaPersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    public JavaPersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    public void setInverseAnnotatedAttribute(JavaPersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        String inverseAttributeName = JPAEditorUtil.returnSimpleName(this.inverse.getName());
        String actInverseAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(this.inverse));
        String nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(inverseAttributeName);
        String actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actInverseAttributeName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(inverseAttributeName);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actInverseAttributeName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.owner, actNameWithNonCapitalLetter);
        this.ownerAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.owner, this.inverse, JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject()) ? JpaArtifactFactory.instance().getIdType(this.inverse) : null, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, true, ownerCU, inverseCU);
        String ownerAttributeName = JPAEditorUtil.returnSimpleName(this.owner.getName());
        String actOwnerAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(this.owner));
        nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(ownerAttributeName);
        actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actOwnerAttributeName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(this.inverse)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(ownerAttributeName);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actOwnerAttributeName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.inverse, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(this.inverse, actNameWithNonCapitalLetter);
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        this.inverseAnnotatedAttribute = JpaArtifactFactory.instance().addAttribute(fp, this.inverse, this.owner, isMap ? JpaArtifactFactory.instance().getIdType(this.owner) : null, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, true, inverseCU, ownerCU);
        JpaArtifactFactory.instance().addManyToManyBidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, this.inverse, this.inverseAnnotatedAttribute, isMap);
    }

    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.BI;
    }
}

