/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.internal.node.Node;
import org.eclipse.jpt.common.utility.internal.node.Problem;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.details.EclipseLinkUiDetailsMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseLinkConverterStateObject
extends AbstractNode {
    private String name;
    private Class<? extends EclipseLinkConverter> converterType;
    private Node.Validator validator;
    private EclipseLinkPersistenceUnit pUnit;
    static final String NAME_PROPERTY = "name";
    static final String CONVERTER_TYPE_PROPERTY = "converterType";

    EclipseLinkConverterStateObject(EclipseLinkPersistenceUnit pUnit) {
        super(null);
        this.pUnit = pUnit;
    }

    private void addNameProblemsTo(List<Problem> currentProblems) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            currentProblems.add(this.buildProblem(EclipseLinkUiDetailsMessages.EclipseLinkConverterStateObject_nameMustBeSpecified, 3));
        } else if (this.names().contains(this.name)) {
            currentProblems.add(this.buildProblem(EclipseLinkUiDetailsMessages.EclipseLinkConverterStateObject_nameExists, 2));
        } else if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            currentProblems.add(this.buildProblem(EclipseLinkUiDetailsMessages.EclipseLinkConverterStateObject_nameIsReserved, 3));
        }
    }

    private void addConverterTypeProblemsTo(List<Problem> currentProblems) {
        if (this.converterType == null) {
            currentProblems.add(this.buildProblem(EclipseLinkUiDetailsMessages.EclipseLinkConverterStateObject_typeMustBeSpecified, 3));
        }
    }

    protected void addProblemsTo(List<Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addNameProblemsTo(currentProblems);
        this.addConverterTypeProblemsTo(currentProblems);
    }

    private List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (EclipseLinkConverter converter : this.pUnit.getAllConverters()) {
            names.add(converter.getName());
        }
        return names;
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    Class<? extends EclipseLinkConverter> getConverterType() {
        return this.converterType;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
    }

    public void setConverterType(Class<? extends EclipseLinkConverter> newConverterType) {
        Class<? extends EclipseLinkConverter> oldConverterType = this.converterType;
        this.converterType = newConverterType;
        this.firePropertyChanged(CONVERTER_TYPE_PROPERTY, oldConverterType, newConverterType);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

