/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInJoiningStrategyDialog;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInJoiningStrategyStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnsComposite;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoiningStrategyJoinColumnsComposite
extends Pane<ReadOnlyJoinColumnRelationshipStrategy> {
    private JoinColumnsComposite<ReadOnlyJoinColumnRelationshipStrategy> joinColumnsComposite;

    public JoiningStrategyJoinColumnsComposite(Pane<?> parentPane, PropertyValueModel<ReadOnlyJoinColumnRelationshipStrategy> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initializeLayout(Composite container) {
        this.joinColumnsComposite = new JoinColumnsComposite<ReadOnlyJoinColumnRelationshipStrategy>(this, container, this.buildJoinColumnsProvider());
        this.joinColumnsComposite.installJoinColumnsPaneEnabler((PropertyValueModel<Boolean>)new JoinColumnPaneEnablerHolder());
    }

    private JoinColumnsComposite.JoinColumnsEditor<ReadOnlyJoinColumnRelationshipStrategy> buildJoinColumnsProvider() {
        return new JoinColumnsComposite.JoinColumnsEditor<ReadOnlyJoinColumnRelationshipStrategy>(){

            @Override
            public void addJoinColumn(ReadOnlyJoinColumnRelationshipStrategy subject) {
                JoiningStrategyJoinColumnsComposite.this.addJoinColumn(subject);
            }

            @Override
            public boolean hasSpecifiedJoinColumns(ReadOnlyJoinColumnRelationshipStrategy subject) {
                return subject.hasSpecifiedJoinColumns();
            }

            @Override
            public void editJoinColumn(ReadOnlyJoinColumnRelationshipStrategy subject, ReadOnlyJoinColumn joinColumn) {
                JoiningStrategyJoinColumnsComposite.this.editJoinColumn(subject, joinColumn);
            }

            @Override
            public ReadOnlyJoinColumn getDefaultJoinColumn(ReadOnlyJoinColumnRelationshipStrategy subject) {
                return subject.getDefaultJoinColumn();
            }

            @Override
            public String getDefaultPropertyName() {
                return "defaultJoinColumn";
            }

            @Override
            public String getSpecifiedJoinColumnsListPropertyName() {
                return "specifiedJoinColumns";
            }

            @Override
            public void removeJoinColumns(ReadOnlyJoinColumnRelationshipStrategy subject, int[] selectedIndices) {
                int index = selectedIndices.length;
                while (--index >= 0) {
                    ((JoinColumnRelationshipStrategy)subject).removeSpecifiedJoinColumn(selectedIndices[index]);
                }
            }

            @Override
            public ListIterable<ReadOnlyJoinColumn> getSpecifiedJoinColumns(ReadOnlyJoinColumnRelationshipStrategy subject) {
                return new SuperListIterableWrapper(subject.getSpecifiedJoinColumns());
            }

            @Override
            public int getSpecifiedJoinColumnsSize(ReadOnlyJoinColumnRelationshipStrategy subject) {
                return subject.getSpecifiedJoinColumnsSize();
            }
        };
    }

    void addJoinColumn(ReadOnlyJoinColumnRelationshipStrategy joiningStrategy) {
        JoinColumnInJoiningStrategyDialog dialog = new JoinColumnInJoiningStrategyDialog(this.getShell(), joiningStrategy, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    private PostExecution<JoinColumnInJoiningStrategyDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoiningStrategyDialog>(){

            public void execute(JoinColumnInJoiningStrategyDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoiningStrategyJoinColumnsComposite.this.addJoinColumn((JoinColumnInJoiningStrategyStateObject)dialog.getSubject());
                }
            }
        };
    }

    void addJoinColumn(JoinColumnInJoiningStrategyStateObject stateObject) {
        JoinColumnRelationshipStrategy subject = (JoinColumnRelationshipStrategy)this.getSubject();
        JoinColumn joinColumn = subject.addSpecifiedJoinColumn();
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        this.setSelectedJoinColumn(joinColumn);
    }

    public void setSelectedJoinColumn(JoinColumn joinColumn) {
        this.joinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    void editJoinColumn(ReadOnlyJoinColumnRelationshipStrategy joiningStrategy, ReadOnlyJoinColumn joinColumn) {
        JoinColumnInJoiningStrategyDialog dialog = new JoinColumnInJoiningStrategyDialog(this.getShell(), joiningStrategy, joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    private PostExecution<JoinColumnInJoiningStrategyDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInJoiningStrategyDialog>(){

            public void execute(JoinColumnInJoiningStrategyDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoiningStrategyJoinColumnsComposite.this.updateJoinColumn((JoinColumnInJoiningStrategyStateObject)dialog.getSubject());
                }
            }
        };
    }

    void updateJoinColumn(JoinColumnInJoiningStrategyStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    protected CachingTransformationPropertyValueModel<ReadOnlyJoinColumnRelationshipStrategy, Boolean> buildJoinColumnsPaneEnabledHolder() {
        return new CachingTransformationPropertyValueModel<ReadOnlyJoinColumnRelationshipStrategy, Boolean>((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(this.getSubjectHolder()), new String[]{"specifiedJoinColumns"})){

            protected Boolean transform(ReadOnlyJoinColumnRelationshipStrategy value) {
                if (value == null) {
                    return Boolean.FALSE;
                }
                return (Boolean)super.transform((Object)value);
            }

            protected Boolean transform_(ReadOnlyJoinColumnRelationshipStrategy value) {
                boolean virtual = value.getRelationship().getMapping().getPersistentAttribute().isVirtual();
                return !virtual && value.getSpecifiedJoinColumnsSize() > 0;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnPaneEnablerHolder
    extends CachingTransformationPropertyValueModel<ReadOnlyJoinColumnRelationshipStrategy, Boolean> {
        private StateChangeListener stateChangeListener;

        public JoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(JoiningStrategyJoinColumnsComposite.this.getSubjectHolder()), new String[]{"specifiedJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    JoinColumnPaneEnablerHolder.this.valueStateChanged();
                }
            };
        }

        void valueStateChanged() {
            Object oldValue = this.cachedValue;
            Object newValue = this.transformNew((ReadOnlyJoinColumnRelationshipStrategy)this.valueHolder.getValue());
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected Boolean transform(ReadOnlyJoinColumnRelationshipStrategy value) {
            if (value == null) {
                return Boolean.FALSE;
            }
            return (Boolean)super.transform((Object)value);
        }

        protected Boolean transform_(ReadOnlyJoinColumnRelationshipStrategy value) {
            boolean virtual = value.getRelationship().isVirtual();
            return !virtual && value.getSpecifiedJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueHolder.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageModel() {
            this.valueHolder.removeStateChangeListener(this.stateChangeListener);
            super.disengageModel();
        }
    }
}

