/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.ConverterTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConvertibleMapping;

public interface OrmEnumeratedConverter
extends EnumeratedConverter,
OrmConverter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    implements OrmConverter.Adapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        @Override
        public Class<? extends Converter> getConverterType() {
            return EnumeratedConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextNodeFactory factory) {
            XmlConvertibleMapping xmlMapping = (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getEnumerated() == null ? null : factory.buildOrmEnumeratedConverter(parent, this.buildOwner(xmlMapping));
        }

        protected Owner buildOwner(final XmlConvertibleMapping mapping) {
            return new Owner(){

                public void setXmlEnumType(EnumType enumType) {
                    mapping.setEnumerated(enumType);
                }

                public EnumType getXmlEnumType() {
                    return mapping.getEnumerated();
                }

                public TextRange getEnumTextRange() {
                    return mapping.getEnumeratedTextRange();
                }

                public JptValidator buildValidator(Converter converter, ConverterTextRangeResolver textRangeResolver) {
                    return JptValidator.Null.instance();
                }
            };
        }

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlConvertibleMapping)((Object)xmlMapping)).getEnumerated() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextNodeFactory factory) {
            return factory.buildOrmEnumeratedConverter(parent, this.buildOwner((XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlConvertibleMapping)((Object)xmlMapping)).setEnumerated(null);
        }
    }

    public static interface Owner
    extends Converter.Owner {
        public EnumType getXmlEnumType();

        public void setXmlEnumType(EnumType var1);

        public TextRange getEnumTextRange();
    }
}

