/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJarFile
extends AbstractPersistenceXmlContextNode
implements JarFile,
PersistentType.Owner {
    protected final JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot;
    protected final AbstractJpaNode.ContextCollectionContainer<JavaPersistentType, JavaResourceType> javaPersistentTypeContainer;

    public GenericJarFile(JarFileRef parent, JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot) {
        super(parent);
        this.jarResourcePackageFragmentRoot = jarResourcePackageFragmentRoot;
        this.javaPersistentTypeContainer = this.buildJavaPersistentTypeContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncJavaPersistentTypes();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes(this.getJavaPersistentTypes());
    }

    @Override
    public JavaResourcePackageFragmentRoot getJarResourcePackageFragmentRoot() {
        return this.jarResourcePackageFragmentRoot;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public JptResourceType getResourceType() {
        return JptCommonCorePlugin.JAR_RESOURCE_TYPE;
    }

    @Override
    public JavaPersistentType getPersistentType(String typeName) {
        for (JavaPersistentType pt : this.getJavaPersistentTypes()) {
            if (!pt.getName().equals(typeName)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public Iterable<JavaPersistentType> getJavaPersistentTypes() {
        return this.javaPersistentTypeContainer.getContextElements();
    }

    @Override
    public int getJavaPersistentTypesSize() {
        return this.javaPersistentTypeContainer.getContextElementsSize();
    }

    protected void syncJavaPersistentTypes() {
        this.javaPersistentTypeContainer.synchronizeWithResourceModel();
    }

    protected void addJavaPersistentType(JavaResourceType jrt) {
        this.javaPersistentTypeContainer.addContextElement(this.getJavaPersistentTypesSize(), jrt);
    }

    protected void removeJavaPersistentType(JavaPersistentType javaPersistentType) {
        this.javaPersistentTypeContainer.removeContextElement(javaPersistentType);
    }

    protected Iterable<JavaResourceType> getJavaResourceTypes() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JavaResourceAbstractType>(this.getJavaResourceAbstractTypes()){

            protected boolean accept(JavaResourceAbstractType o) {
                return o.getKind() == JavaResourceAnnotatedElement.Kind.TYPE;
            }
        });
    }

    protected Iterable<JavaResourceAbstractType> getJavaResourceAbstractTypes() {
        return this.jarResourcePackageFragmentRoot.getTypes();
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourceType jrt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrt);
    }

    protected AbstractJpaNode.ContextCollectionContainer<JavaPersistentType, JavaResourceType> buildJavaPersistentTypeContainer() {
        JavaPersistentTypeContainer container = new JavaPersistentTypeContainer();
        container.initialize();
        return container;
    }

    public Iterable<JavaPersistentType> getPersistentTypes() {
        return this.getJavaPersistentTypes();
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public JarFileRef getParent() {
        return (JarFileRef)super.getParent();
    }

    protected JarFileRef getJarFileRef() {
        return this.getParent();
    }

    @Override
    public IResource getResource() {
        return this.jarResourcePackageFragmentRoot.getFile();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    @Override
    public boolean isIn(IFolder folder) {
        IResource member = folder.findMember(this.jarResourcePackageFragmentRoot.getFile().getName());
        IFile file = this.jarResourcePackageFragmentRoot.getFile();
        return member != null && file != null && member.equals((Object)file);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJarFileRef().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaPersistentTypeContainer
    extends AbstractJpaNode.ContextCollectionContainer<JavaPersistentType, JavaResourceType> {
        protected JavaPersistentTypeContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "javaPersistentTypes";
        }

        @Override
        protected JavaPersistentType buildContextElement(JavaResourceType resourceElement) {
            return GenericJarFile.this.buildJavaPersistentType(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceType> getResourceElements() {
            return GenericJarFile.this.getJavaResourceTypes();
        }

        @Override
        protected JavaResourceType getResourceElement(JavaPersistentType contextElement) {
            return contextElement.getJavaResourceType();
        }
    }
}

