/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmRelationship;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinTable
extends GenericOrmReferenceTable<XmlJoinTable>
implements OrmJoinTable {
    protected final AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> specifiedInverseJoinColumnContainer;
    protected final OrmReadOnlyJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    protected OrmJoinColumn defaultInverseJoinColumn;

    public GenericOrmJoinTable(OrmJoinTableRelationshipStrategy parent, ReadOnlyTable.Owner owner) {
        super(parent, owner);
        this.specifiedInverseJoinColumnContainer = this.buildSpecifiedInverseJoinColumnContainer();
    }

    @Override
    protected OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedInverseJoinColumns();
        if (this.defaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedInverseJoinColumns());
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    protected XmlJoinTable getXmlTable() {
        return this.getRelationshipStrategy().getXmlJoinTable();
    }

    @Override
    protected XmlJoinTable buildXmlTable() {
        return this.getRelationshipStrategy().buildXmlJoinTable();
    }

    @Override
    protected void removeXmlTable() {
        this.getRelationshipStrategy().removeXmlJoinTable();
    }

    @Override
    public ListIterable<OrmJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int getInverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumnsSize() : this.getDefaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultInverseJoinColumnToSpecified() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public ListIterable<OrmJoinColumn> getSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumnsSize() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumnContainer.getContextElement(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn() {
        return this.addSpecifiedInverseJoinColumn(this.getSpecifiedInverseJoinColumnsSize());
    }

    @Override
    public OrmJoinColumn addSpecifiedInverseJoinColumn(int index) {
        XmlJoinTable xmlTable = (XmlJoinTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = (OrmJoinColumn)this.specifiedInverseJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        xmlTable.getInverseJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumnContainer.indexOfContextElement((OrmJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        this.specifiedInverseJoinColumnContainer.removeContextElement(index);
        this.getXmlTable().getInverseJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedInverseJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
        this.getXmlTable().getInverseJoinColumns().move(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.clearContextList();
        this.getXmlTable().getInverseJoinColumns().clear();
    }

    protected void syncSpecifiedInverseJoinColumns() {
        this.specifiedInverseJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJoinColumn> getXmlInverseJoinColumns() {
        XmlJoinTable xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : new LiveCloneListIterable(xmlTable.getInverseJoinColumns());
    }

    protected AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> buildSpecifiedInverseJoinColumnContainer() {
        SpecifiedInverseJoinColumnContainer container = new SpecifiedInverseJoinColumnContainer();
        container.initialize();
        return container;
    }

    protected OrmReadOnlyJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public OrmJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(null));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public OrmJoinTableRelationshipStrategy getParent() {
        return (OrmJoinTableRelationshipStrategy)super.getParent();
    }

    protected OrmJoinTableRelationshipStrategy getRelationshipStrategy() {
        return this.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : oldTable.getSpecifiedInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : virtualTable.getInverseJoinColumns()) {
            this.addSpecifiedInverseJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected OrmJoinColumn buildInverseJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.inverseJoinColumnOwner, xmlJoinColumn);
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        super.validateJoinColumns(messages, reporter);
        this.validateNodes((Iterable<? extends XmlContextNode>)this.getInverseJoinColumns(), messages, reporter);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements OrmReadOnlyJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((ReadOnlyJoinColumn)column, this);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return Tools.valuesAreDifferent((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return EmptyIterable.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return Tools.valuesAreEqual((Object)GenericOrmJoinTable.this.getName(), (Object)tableName) ? GenericOrmJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmJoinTable.this.getValidationTextRange();
        }

        protected OrmRelationship getRelationship() {
            return this.getRelationshipStrategy().getRelationship();
        }

        protected OrmJoinTableRelationshipStrategy getRelationshipStrategy() {
            return GenericOrmJoinTable.this.getRelationshipStrategy();
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericOrmJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            if (dbTable != null) {
                return dbTable;
            }
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int getJoinColumnsSize() {
            return GenericOrmJoinTable.this.getInverseJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableInverseJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return this.getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericOrmJoinTable.this.getRelationshipMapping());
        }

        public Table resolveDbTable(String tableName) {
            Table dbTable = super.resolveDbTable(tableName);
            return dbTable != null ? dbTable : this.getTypeMapping().resolveDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        protected TypeMapping getTypeMapping() {
            return this.getRelationship().getTypeMapping();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericOrmJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int getJoinColumnsSize() {
            return GenericOrmJoinTable.this.getJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return this.getRelationshipStrategy().buildJoinTableJoinColumnValidator((ReadOnlyJoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedInverseJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedInverseJoinColumns";
        }

        @Override
        protected OrmJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return GenericOrmJoinTable.this.buildInverseJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmJoinTable.this.getXmlInverseJoinColumns();
        }

        @Override
        protected XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

