/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReferenceTable;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericOrmReferenceTable<X extends AbstractXmlReferenceTable>
extends AbstractOrmTable<X>
implements OrmReferenceTable {
    protected final AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> specifiedJoinColumnContainer;
    protected final OrmReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmJoinColumn defaultJoinColumn;

    protected GenericOrmReferenceTable(XmlContextNode parent, ReadOnlyTable.Owner owner) {
        super(parent, owner);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<OrmJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultJoinColumnToSpecified() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterable<OrmJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = (OrmJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        xmlTable.getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOfContextElement((OrmJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.specifiedJoinColumnContainer.removeContextElement(index);
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJoinColumn> getXmlJoinColumns() {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTable();
        return xmlTable == null ? EmptyListIterable.instance() : new LiveCloneListIterable(xmlTable.getJoinColumns());
    }

    protected AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> buildSpecifiedJoinColumnContainer() {
        SpecifiedJoinColumnContainer container = new SpecifiedJoinColumnContainer();
        container.initialize();
        return container;
    }

    protected abstract OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(ReadOnlyReferenceTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : oldTable.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected void initializeFromVirtual(ReadOnlyReferenceTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : virtualTable.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.joinColumnOwner, xmlJoinColumn);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateNodes((Iterable<? extends XmlContextNode>)this.getJoinColumns(), messages, reporter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected OrmJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return GenericOrmReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmReferenceTable.this.getXmlJoinColumns();
        }

        @Override
        protected XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

