/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpql;

import java.util.List;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.internal.jpql.JpaQuery;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationPreferences;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaJpqlQueryHelper
extends JPQLQueryHelper {
    private JpaManagedTypeProvider managedTypeProvider;

    public int[] buildPositions(JPQLQueryProblem problem, String parsedJpqlQuery, String actualQuery) {
        int newStartPosition;
        int endPosition;
        int startPosition = problem.getStartPosition();
        if (startPosition == (endPosition = problem.getEndPosition())) {
            startPosition = Math.max(startPosition - 1, 0);
        }
        if ((newStartPosition = ExpressionTools.repositionCursor((CharSequence)parsedJpqlQuery, (int)startPosition, (CharSequence)actualQuery)) != startPosition) {
            endPosition += newStartPosition - startPosition;
            startPosition = newStartPosition;
        }
        return new int[]{startPosition, endPosition};
    }

    private IMessage buildProblem(NamedQuery namedQuery, TextRange textRange, JPQLQueryProblem problem, String parsedJpqlQuery, String actualQuery, int offset) {
        int[] positions = this.buildPositions(problem, parsedJpqlQuery, actualQuery);
        int[] newStartPosition = new int[]{positions[0]};
        ExpressionTools.escape((CharSequence)actualQuery, (int[])newStartPosition);
        int escapeOffset = positions[0] - newStartPosition[0];
        positions[0] = positions[0] - escapeOffset;
        positions[1] = positions[1] - escapeOffset;
        textRange = new SimpleTextRange(textRange.getOffset() + positions[0] + offset, positions[1] - positions[0], textRange.getLineNumber());
        IMessage message = DefaultJpaValidationMessages.buildMessage(this.severity(namedQuery), problem.getMessageKey(), problem.getMessageArguments(), namedQuery, textRange);
        message.setBundleName("jpa_jpql_validation");
        return message;
    }

    private JpaManagedTypeProvider buildProvider(NamedQuery query) {
        return new JpaManagedTypeProvider(query.getJpaProject(), query.getPersistenceUnit());
    }

    public void disposeProvider() {
        this.managedTypeProvider = null;
    }

    public void setQuery(NamedQuery namedQuery, String actualQuery) {
        if (this.managedTypeProvider == null) {
            this.managedTypeProvider = this.buildProvider(namedQuery);
        }
        JpaQuery query = new JpaQuery(this.managedTypeProvider, namedQuery, actualQuery);
        super.setQuery((IQuery)query);
    }

    private int severity(Object targetObject) {
        return JpaValidationPreferences.getProblemSeverityPreference(targetObject, "JPQL_QUERY_VALIDATION");
    }

    private boolean shouldValidate(NamedQuery namedQuery) {
        return JpaValidationPreferences.getProblemSeverityPreference(namedQuery, "JPQL_QUERY_VALIDATION") == -1;
    }

    public void validate(NamedQuery namedQuery, String jpqlQuery, TextRange textRange, int offset, List<IMessage> messages) {
        if (this.shouldValidate(namedQuery)) {
            this.setQuery(namedQuery, jpqlQuery);
            String parsedJpqlQuery = this.getParsedJPQLQuery();
            for (JPQLQueryProblem problem : this.validate()) {
                IMessage message = this.buildProblem(namedQuery, textRange, problem, parsedJpqlQuery, jpqlQuery, offset);
                messages.add(message);
            }
        }
    }
}

