/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMoveMappingFileParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected final Map<IFile, MoveArguments> originalMappingFiles = new HashMap<IFile, MoveArguments>();
    protected final Map<IFile, Iterable<ReplaceEdit>> persistenceXmlMappingFileReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();

    public String getName() {
        return JpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.originalMappingFiles.put((IFile)element, (MoveArguments)arguments);
    }

    protected MoveArguments getArguments(IFile element) {
        return this.originalMappingFiles.get(element);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        JpaProjectManager jpaProjectManager = JptJpaCorePlugin.getJpaProjectManager();
        if (jpaProjectManager.getJpaProjectsSize() == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(jpaProjectManager.getJpaProjectsSize() * 10 + 1));
        sm.subTask(JpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : JptJpaCorePlugin.getJpaProjectManager().getJpaProjects()) {
            this.createReplaceEdits(jpaProject);
            sm.worked(10);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileReplaceEdits.keySet()) {
            deltaFactory.change(persistenceXmlFile);
        }
        sm.worked(1);
        return null;
    }

    protected void createReplaceEdits(JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        Iterable<ReplaceEdit> replaceEdits = this.createPersistenceUnitReplaceEditsCheckClasspath(persistenceUnit);
        if (!CollectionTools.isEmpty(replaceEdits)) {
            this.persistenceXmlMappingFileReplaceEdits.put(jpaProject.getPersistenceXmlResource().getFile(), replaceEdits);
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlMappingFileReplaceEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.persistenceXmlMappingFileReplaceEdits.size());
        sm.subTask(JpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        CompositeChange compositeChange = new CompositeChange(JpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileReplaceEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addPersistenceXmlRenameMappingFileChange(persistenceXmlFile, compositeChange);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEditsCheckClasspath(final PersistenceUnit persistenceUnit) {
        return new CompositeIterable((Iterable)new TransformationIterable<IFile, Iterable<ReplaceEdit>>(this.getOriginalFoldersOnClasspath(persistenceUnit.getJpaProject())){

            protected Iterable<ReplaceEdit> transform(IFile mappingFile) {
                return JpaMoveMappingFileParticipant.this.createPersistenceUnitReplaceEdits(persistenceUnit, mappingFile, (IFolder)JpaMoveMappingFileParticipant.this.getArguments(mappingFile).getDestination());
            }
        });
    }

    protected Iterable<IFile> getOriginalFoldersOnClasspath(JpaProject jpaProject) {
        final IJavaProject javaProject = jpaProject.getJavaProject();
        return new FilteringIterable<IFile>(this.originalMappingFiles.keySet()){

            protected boolean accept(IFile file) {
                return javaProject.isOnClasspath((IResource)file);
            }
        };
    }

    private Iterable<ReplaceEdit> createPersistenceUnitReplaceEdits(PersistenceUnit persistenceUnit, IFile mappingFile, IFolder destination) {
        IProject project = destination.getProject();
        IPath fullPath = destination.getFullPath();
        IPath runtimePath = JptCommonCorePlugin.getResourceLocator((IProject)project).getRuntimePath(project, fullPath);
        return persistenceUnit.createMoveMappingFileEdits(mappingFile, runtimePath);
    }

    protected void addPersistenceXmlRenameMappingFileChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        Iterable<ReplaceEdit> mappingFileReplaceEdits = this.persistenceXmlMappingFileReplaceEdits.get(persistenceXmlFile);
        this.addEdits(textChange, mappingFileReplaceEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException e) {
                JptJpaCorePlugin.log(e);
            }
        }
    }
}

