/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.CompleteColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceCompleteColumnAnnotation
extends SourceBaseColumnAnnotation
implements CompleteColumnAnnotation {
    protected DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> lengthAdapter = this.buildLengthAdapter();
    protected Integer length;
    protected DeclarationAnnotationElementAdapter<Integer> precisionDeclarationAdapter = this.buildPrecisionDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> precisionAdapter = this.buildPrecisionAdapter();
    protected Integer precision;
    protected DeclarationAnnotationElementAdapter<Integer> scaleDeclarationAdapter = this.buildScaleDeclarationAdapter();
    protected AnnotationElementAdapter<Integer> scaleAdapter = this.buildScaleAdapter();
    protected Integer scale;

    protected SourceCompleteColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.length = this.buildLength(astRoot);
        this.precision = this.buildPrecision(astRoot);
        this.scale = this.buildScale(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncLength(this.buildLength(astRoot));
        this.syncPrecision(this.buildPrecision(astRoot));
        this.syncScale(this.buildScale(astRoot));
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (this.attributeValueHasChanged(this.length, length)) {
            this.length = length;
            this.lengthAdapter.setValue((Object)length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return (Integer)this.lengthAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getLengthTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.lengthDeclarationAdapter, astRoot);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildLengthDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getLengthElementName());
    }

    protected AnnotationElementAdapter<Integer> buildLengthAdapter() {
        return this.buildIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    protected abstract String getLengthElementName();

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(Integer precision) {
        if (this.attributeValueHasChanged(this.precision, precision)) {
            this.precision = precision;
            this.precisionAdapter.setValue((Object)precision);
        }
    }

    private void syncPrecision(Integer astPrecision) {
        Integer old = this.precision;
        this.precision = astPrecision;
        this.firePropertyChanged("precision", old, astPrecision);
    }

    private Integer buildPrecision(CompilationUnit astRoot) {
        return (Integer)this.precisionAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getPrecisionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.precisionDeclarationAdapter, astRoot);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildPrecisionDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getPrecisionElementName());
    }

    protected AnnotationElementAdapter<Integer> buildPrecisionAdapter() {
        return this.buildIntegerElementAdapter(this.precisionDeclarationAdapter);
    }

    protected abstract String getPrecisionElementName();

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Integer scale) {
        if (this.attributeValueHasChanged(this.scale, scale)) {
            this.scale = scale;
            this.scaleAdapter.setValue((Object)scale);
        }
    }

    private void syncScale(Integer astScale) {
        Integer old = this.scale;
        this.scale = astScale;
        this.firePropertyChanged("scale", old, astScale);
    }

    private Integer buildScale(CompilationUnit astRoot) {
        return (Integer)this.scaleAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getScaleTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.scaleDeclarationAdapter, astRoot);
    }

    protected DeclarationAnnotationElementAdapter<Integer> buildScaleDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getScaleElementName());
    }

    protected AnnotationElementAdapter<Integer> buildScaleAdapter() {
        return this.buildIntegerElementAdapter(this.scaleDeclarationAdapter);
    }

    protected abstract String getScaleElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.length == null && this.precision == null && this.scale == null;
    }
}

