/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceEntityAnnotation
extends SourceAnnotation
implements EntityAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Entity");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceEntityAnnotation.buildNameAdapter();
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    TextRange nameTextRange;

    public SourceEntityAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.nameAdapter = new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, NAME_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.Entity";
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"name");
    }
}

