/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NumberIntegerExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.GeneratorAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceGeneratorAnnotation
extends SourceAnnotation
implements GeneratorAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.getNameAdapter();
    final AnnotationElementAdapter<String> nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
    String name;
    TextRange nameTextRange;
    final DeclarationAnnotationElementAdapter<Integer> initialValueDeclarationAdapter = this.getInitialValueAdapter();
    final AnnotationElementAdapter<Integer> initialValueAdapter = this.buildIntegerAdapter(this.initialValueDeclarationAdapter);
    Integer initialValue;
    final DeclarationAnnotationElementAdapter<Integer> allocationSizeDeclarationAdapter = this.getAllocationSizeAdapter();
    final AnnotationElementAdapter<Integer> allocationSizeAdapter = this.buildIntegerAdapter(this.allocationSizeDeclarationAdapter);
    Integer allocationSize;

    SourceGeneratorAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super(parent, element, daa);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    protected AnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationElementAdapter<Integer> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.initialValue = this.buildInitialValue(astRoot);
        this.allocationSize = this.buildAllocationSize(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncInitialValue(this.buildInitialValue(astRoot));
        this.syncAllocationSize(this.buildAllocationSize(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.initialValue == null && this.allocationSize == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getNameAdapter();

    @Override
    public Integer getInitialValue() {
        return this.initialValue;
    }

    @Override
    public void setInitialValue(Integer initialValue) {
        if (this.attributeValueHasChanged(this.initialValue, initialValue)) {
            this.initialValue = initialValue;
            this.initialValueAdapter.setValue((Object)initialValue);
        }
    }

    private void syncInitialValue(Integer astIinitialValue) {
        Integer old = this.initialValue;
        this.initialValue = astIinitialValue;
        this.firePropertyChanged("initialValue", old, astIinitialValue);
    }

    private Integer buildInitialValue(CompilationUnit astRoot) {
        return (Integer)this.initialValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInitialValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.initialValueDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter();

    @Override
    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    @Override
    public void setAllocationSize(Integer allocationSize) {
        if (this.attributeValueHasChanged(this.allocationSize, allocationSize)) {
            this.allocationSize = allocationSize;
            this.allocationSizeAdapter.setValue((Object)allocationSize);
        }
    }

    private void syncAllocationSize(Integer astAllocationSize) {
        Integer old = this.allocationSize;
        this.allocationSize = astAllocationSize;
        this.firePropertyChanged("allocationSize", old, astAllocationSize);
    }

    private Integer buildAllocationSize(CompilationUnit astRoot) {
        return (Integer)this.allocationSizeAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getAllocationSizeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.allocationSizeDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter();

    static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)annotationAdapter, (String)elementName);
    }

    static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, NumberIntegerExpressionConverter.instance());
    }
}

