/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceUniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTableGeneratorAnnotation
extends SourceGeneratorAnnotation
implements TableGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.TableGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceTableGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> TABLE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("table");
    private final AnnotationElementAdapter<String> tableAdapter;
    private String table;
    private static final DeclarationAnnotationElementAdapter<String> SCHEMA_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("schema");
    private final AnnotationElementAdapter<String> schemaAdapter;
    private String schema;
    private static final DeclarationAnnotationElementAdapter<String> CATALOG_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("catalog");
    private final AnnotationElementAdapter<String> catalogAdapter;
    private String catalog;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnName");
    private final AnnotationElementAdapter<String> pkColumnNameAdapter;
    private String pkColumnName;
    private static final DeclarationAnnotationElementAdapter<String> VALUE_COLUMN_NAME_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("valueColumnName");
    private final AnnotationElementAdapter<String> valueColumnNameAdapter;
    private String valueColumnName;
    private static final DeclarationAnnotationElementAdapter<String> PK_COLUMN_VALUE_ADAPTER = SourceTableGeneratorAnnotation.buildAdapter("pkColumnValue");
    private final AnnotationElementAdapter<String> pkColumnValueAdapter;
    private String pkColumnValue;
    private final UniqueConstraintsAnnotationContainer uniqueConstraintsContainer = new UniqueConstraintsAnnotationContainer();

    public SourceTableGeneratorAnnotation(JavaResourceNode parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.tableAdapter = this.buildAdapter(TABLE_ADAPTER);
        this.catalogAdapter = this.buildAdapter(CATALOG_ADAPTER);
        this.schemaAdapter = this.buildAdapter(SCHEMA_ADAPTER);
        this.pkColumnNameAdapter = this.buildAdapter(PK_COLUMN_NAME_ADAPTER);
        this.valueColumnNameAdapter = this.buildAdapter(VALUE_COLUMN_NAME_ADAPTER);
        this.pkColumnValueAdapter = this.buildAdapter(PK_COLUMN_VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.TableGenerator";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.table = this.buildTable(astRoot);
        this.schema = this.buildSchema(astRoot);
        this.catalog = this.buildCatalog(astRoot);
        this.pkColumnName = this.buildPkColumnName(astRoot);
        this.valueColumnName = this.buildValueColumnName(astRoot);
        this.pkColumnValue = this.buildPkColumnValue(astRoot);
        this.uniqueConstraintsContainer.initialize(this.getAstAnnotation(astRoot));
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncTable(this.buildTable(astRoot));
        this.syncSchema(this.buildSchema(astRoot));
        this.syncCatalog(this.buildCatalog(astRoot));
        this.syncPkColumnName(this.buildPkColumnName(astRoot));
        this.syncValueColumnName(this.buildValueColumnName(astRoot));
        this.syncPkColumnValue(this.buildPkColumnValue(astRoot));
        this.uniqueConstraintsContainer.synchronize(this.getAstAnnotation(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.table == null && this.schema == null && this.catalog == null && this.pkColumnName == null && this.valueColumnName == null && this.pkColumnValue == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public void setTable(String table) {
        if (this.attributeValueHasChanged(this.table, table)) {
            this.table = table;
            this.tableAdapter.setValue((Object)table);
        }
    }

    private void syncTable(String astTable) {
        String old = this.table;
        this.table = astTable;
        this.firePropertyChanged("table", old, astTable);
    }

    private String buildTable(CompilationUnit astRoot) {
        return (String)this.tableAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TABLE_ADAPTER, astRoot);
    }

    @Override
    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(TABLE_ADAPTER, pos, astRoot);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        if (this.attributeValueHasChanged(this.schema, schema)) {
            this.schema = schema;
            this.schemaAdapter.setValue((Object)schema);
        }
    }

    private void syncSchema(String astSchema) {
        String old = this.schema;
        this.schema = astSchema;
        this.firePropertyChanged("schema", old, astSchema);
    }

    private String buildSchema(CompilationUnit astRoot) {
        return (String)this.schemaAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SCHEMA_ADAPTER, astRoot);
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(SCHEMA_ADAPTER, pos, astRoot);
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        if (this.attributeValueHasChanged(this.catalog, catalog)) {
            this.catalog = catalog;
            this.catalogAdapter.setValue((Object)catalog);
        }
    }

    private void syncCatalog(String astCatalog) {
        String old = this.catalog;
        this.catalog = astCatalog;
        this.firePropertyChanged("catalog", old, astCatalog);
    }

    private String buildCatalog(CompilationUnit astRoot) {
        return (String)this.catalogAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(CATALOG_ADAPTER, astRoot);
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(CATALOG_ADAPTER, pos, astRoot);
    }

    @Override
    public String getPkColumnName() {
        return this.pkColumnName;
    }

    @Override
    public void setPkColumnName(String pkColumnName) {
        if (this.attributeValueHasChanged(this.pkColumnName, pkColumnName)) {
            this.pkColumnName = pkColumnName;
            this.pkColumnNameAdapter.setValue((Object)pkColumnName);
        }
    }

    private void syncPkColumnName(String astPkColumnName) {
        String old = this.pkColumnName;
        this.pkColumnName = astPkColumnName;
        this.firePropertyChanged("pkColumnName", old, astPkColumnName);
    }

    private String buildPkColumnName(CompilationUnit astRoot) {
        return (String)this.pkColumnNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getPkColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    @Override
    public void setValueColumnName(String valueColumnName) {
        if (this.attributeValueHasChanged(this.valueColumnName, valueColumnName)) {
            this.valueColumnName = valueColumnName;
            this.valueColumnNameAdapter.setValue((Object)valueColumnName);
        }
    }

    private void syncValueColumnName(String astValueColumnName) {
        String old = this.valueColumnName;
        this.valueColumnName = astValueColumnName;
        this.firePropertyChanged("valueColumnName", old, astValueColumnName);
    }

    private String buildValueColumnName(CompilationUnit astRoot) {
        return (String)this.valueColumnNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_COLUMN_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean valueColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(VALUE_COLUMN_NAME_ADAPTER, pos, astRoot);
    }

    @Override
    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    @Override
    public void setPkColumnValue(String pkColumnValue) {
        if (this.attributeValueHasChanged(this.pkColumnValue, pkColumnValue)) {
            this.pkColumnValue = pkColumnValue;
            this.pkColumnValueAdapter.setValue((Object)pkColumnValue);
        }
    }

    private void syncPkColumnValue(String astPkColumnValue) {
        String old = this.pkColumnValue;
        this.pkColumnValue = astPkColumnValue;
        this.firePropertyChanged("pkColumnValue", old, astPkColumnValue);
    }

    private String buildPkColumnValue(CompilationUnit astRoot) {
        return (String)this.pkColumnValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getPkColumnValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(PK_COLUMN_VALUE_ADAPTER, astRoot);
    }

    @Override
    public boolean pkColumnValueTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(PK_COLUMN_VALUE_ADAPTER, pos, astRoot);
    }

    @Override
    public ListIterable<UniqueConstraintAnnotation> getUniqueConstraints() {
        return this.uniqueConstraintsContainer.getNestedAnnotations();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintsContainer.getNestedAnnotationsSize();
    }

    @Override
    public UniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.nestedAnnotationAt(index);
    }

    @Override
    public UniqueConstraintAnnotation addUniqueConstraint(int index) {
        return (UniqueConstraintAnnotation)this.uniqueConstraintsContainer.addNestedAnnotation(index);
    }

    private UniqueConstraintAnnotation buildUniqueConstraint(int index) {
        return new SourceUniqueConstraintAnnotation((JavaResourceNode)this, this.annotatedElement, this.buildUniqueConstraintIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildUniqueConstraintIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintsContainer.removeNestedAnnotation(index);
    }

    private static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    private static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceTableGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UniqueConstraintsAnnotationContainer
    extends SourceAnnotation.AnnotationContainer<UniqueConstraintAnnotation> {
        UniqueConstraintsAnnotationContainer() {
            super((SourceAnnotation)SourceTableGeneratorAnnotation.this);
        }

        protected String getAnnotationsPropertyName() {
            return "uniqueConstraints";
        }

        protected String getElementName() {
            return "uniqueConstraints";
        }

        protected String getNestedAnnotationName() {
            return "javax.persistence.UniqueConstraint";
        }

        protected UniqueConstraintAnnotation buildNestedAnnotation(int index) {
            return SourceTableGeneratorAnnotation.this.buildUniqueConstraint(index);
        }
    }
}

