/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NonEmptyStringFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.MappingFileRoot;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence.ImpliedMappingFileRef;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.JptJpaEclipseLinkCorePlugin;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.ReadOnlyTenantDiscriminatorColumn2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Connection;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Customization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceXmlContextNodeFactory;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.GeneralProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Logging;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Options;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.SchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkCustomization;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkGeneralProperties;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnit
extends AbstractPersistenceUnit {
    protected MappingFileRef impliedEclipseLinkMappingFileRef;
    public static final String IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY = "impliedEclipseLinkMappingFileRef";
    private GeneralProperties generalProperties;
    private Customization customization;
    private Caching caching;
    private Logging logging;
    private SchemaGeneration schemaGeneration;
    protected final Vector<EclipseLinkConverter> converters = new Vector();
    protected final Vector<ReadOnlyTenantDiscriminatorColumn2_3> defaultTenantDiscriminatorColumns = new Vector();
    public static final String DEFAULT_TENANT_DISCRIMINATOR_COLUMNS_LIST = "defaultTenantDiscriminatorColumns";
    public static final String CONVERTERS_COLLECTION = "converters";

    public EclipseLinkPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent, xmlPersistenceUnit);
    }

    public void update() {
        super.update();
        this.setConverters(this.buildConverters());
        OrmEclipseLinkPersistenceUnitMetadata metadata = this.getEclipseLinkMetadata();
        EclipseLinkPersistenceUnitDefaults defaults = metadata == null ? null : metadata.getPersistenceUnitDefaults();
        this.setDefaultTenantDiscriminatorColumns((Iterable<ReadOnlyTenantDiscriminatorColumn2_3>)this.buildDefaultTenantDiscriminatorColumns(defaults));
    }

    protected OrmEclipseLinkPersistenceUnitMetadata getEclipseLinkMetadata() {
        MappingFilePersistenceUnitMetadata metadata = super.getMetadata();
        if (metadata instanceof OrmEclipseLinkPersistenceUnitMetadata) {
            return (OrmEclipseLinkPersistenceUnitMetadata)metadata;
        }
        return null;
    }

    public GeneralProperties getGeneralProperties() {
        return this.generalProperties;
    }

    public Connection getConnection() {
        return (Connection)super.getConnection();
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public String getDefaultCacheTypePropertyValue() {
        PersistenceUnit.Property cacheTypeDefaultProperty = this.getCacheTypeDefaultProperty();
        return cacheTypeDefaultProperty != null ? cacheTypeDefaultProperty.getValue() : null;
    }

    public String getDefaultCacheSizePropertyValue() {
        PersistenceUnit.Property cacheSizeDefaultProperty = this.getCacheSizeDefaultProperty();
        return cacheSizeDefaultProperty != null ? cacheSizeDefaultProperty.getValue() : null;
    }

    public String getDefaultCacheSharedPropertyValue() {
        PersistenceUnit.Property cacheSharedDefaultProperty = this.getCacheSharedDefaultProperty();
        return cacheSharedDefaultProperty != null ? cacheSharedDefaultProperty.getValue() : null;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Options getOptions() {
        return (Options)super.getOptions();
    }

    public SchemaGeneration getSchemaGeneration() {
        return this.schemaGeneration;
    }

    protected GeneralProperties buildEclipseLinkGeneralProperties() {
        return new EclipseLinkGeneralProperties((PersistenceUnit)this);
    }

    protected Connection buildEclipseLinkConnection() {
        return (Connection)this.getContextNodeFactory().buildConnection((PersistenceUnit)this);
    }

    protected Customization buildEclipseLinkCustomization() {
        return new EclipseLinkCustomization((PersistenceUnit)this);
    }

    protected Caching buildEclipseLinkCaching() {
        return new EclipseLinkCaching((PersistenceUnit)this);
    }

    protected Logging buildEclipseLinkLogging() {
        return (Logging)this.getContextNodeFactory().buildLogging((PersistenceUnit)this);
    }

    protected Options buildEclipseLinkOptions() {
        return (Options)this.getContextNodeFactory().buildOptions((PersistenceUnit)this);
    }

    protected SchemaGeneration buildEclipseLinkSchemaGeneration() {
        return new EclipseLinkSchemaGeneration((PersistenceUnit)this);
    }

    protected void initializeProperties() {
        super.initializeProperties();
        this.generalProperties = this.buildEclipseLinkGeneralProperties();
        this.customization = this.buildEclipseLinkCustomization();
        this.caching = this.buildEclipseLinkCaching();
        this.logging = this.buildEclipseLinkLogging();
        this.schemaGeneration = this.buildEclipseLinkSchemaGeneration();
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        this.generalProperties.propertyValueChanged(propertyName, newValue);
        this.customization.propertyValueChanged(propertyName, newValue);
        this.caching.propertyValueChanged(propertyName, newValue);
        this.logging.propertyValueChanged(propertyName, newValue);
        this.schemaGeneration.propertyValueChanged(propertyName, newValue);
    }

    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        this.generalProperties.propertyRemoved(propertyName);
        this.customization.propertyRemoved(propertyName);
        this.caching.propertyRemoved(propertyName);
        this.logging.propertyRemoved(propertyName);
        this.schemaGeneration.propertyRemoved(propertyName);
    }

    public ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedEclipseLinkMappingFileRef == null ? super.getMappingFileRefs() : new CompositeListIterable(super.getMappingFileRefs(), (Object)this.impliedEclipseLinkMappingFileRef);
    }

    public int getMappingFileRefsSize() {
        return this.impliedEclipseLinkMappingFileRef == null ? super.getMappingFileRefsSize() : super.getMappingFileRefsSize() + 1;
    }

    public MappingFileRef getImpliedEclipseLinkMappingFileRef() {
        return this.impliedEclipseLinkMappingFileRef;
    }

    protected MappingFileRef addImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef != null) {
            throw new IllegalStateException("The implied EclipseLink mapping file ref is already present: " + this.impliedEclipseLinkMappingFileRef);
        }
        ImpliedMappingFileRef mappingFileRef = this.buildEclipseLinkImpliedMappingFileRef();
        this.impliedEclipseLinkMappingFileRef = mappingFileRef;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, null, mappingFileRef);
        return mappingFileRef;
    }

    private ImpliedMappingFileRef buildEclipseLinkImpliedMappingFileRef() {
        return new ImpliedMappingFileRef((PersistenceUnit)this, JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH.toString());
    }

    protected void removeImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            throw new IllegalStateException("The implied EclipseLink mapping file ref is null.");
        }
        MappingFileRef mappingFileRef = this.impliedEclipseLinkMappingFileRef;
        this.impliedEclipseLinkMappingFileRef.dispose();
        this.impliedEclipseLinkMappingFileRef = null;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, mappingFileRef, null);
    }

    protected void syncImpliedMappingFileRef() {
        super.syncImpliedMappingFileRef();
        if (this.impliedEclipseLinkMappingFileRef != null) {
            this.impliedEclipseLinkMappingFileRef.synchronizeWithResourceModel();
        }
    }

    protected void updateImpliedMappingFileRef() {
        super.updateImpliedMappingFileRef();
        if (this.buildsImpliedEclipseLinkMappingFile()) {
            if (this.impliedEclipseLinkMappingFileRef == null) {
                this.addImpliedEclipseLinkMappingFileRef();
            } else {
                this.impliedEclipseLinkMappingFileRef.update();
            }
        } else if (this.impliedEclipseLinkMappingFileRef != null) {
            this.removeImpliedEclipseLinkMappingFileRef();
        }
    }

    private boolean buildsImpliedEclipseLinkMappingFile() {
        return this.impliedEclipseLinkMappingFileIsNotExcluded() && this.impliedEclipseLinkMappingFileIsNotSpecified() && this.impliedEclipseLinkMappingFileExists();
    }

    protected boolean impliedEclipseLinkMappingFileIsNotExcluded() {
        return !this.impliedEclipseLinkMappingFileIsExcluded();
    }

    protected boolean impliedEclipseLinkMappingFileIsExcluded() {
        return this.getGeneralProperties().getExcludeEclipselinkOrm() == Boolean.TRUE;
    }

    protected boolean impliedEclipseLinkMappingFileIsNotSpecified() {
        return !this.impliedEclipseLinkMappingFileIsSpecified();
    }

    protected boolean impliedEclipseLinkMappingFileIsSpecified() {
        return this.mappingFileIsSpecified(JptJpaEclipseLinkCorePlugin.DEFAULT_ECLIPSELINK_ORM_XML_RUNTIME_PATH.toString());
    }

    protected boolean impliedEclipseLinkMappingFileExists() {
        return this.getJpaProject().getDefaultEclipseLinkOrmXmlResource() != null;
    }

    public ListIterable<ReadOnlyTenantDiscriminatorColumn2_3> getDefaultTenantDiscriminatorColumns() {
        return new LiveCloneListIterable(this.defaultTenantDiscriminatorColumns);
    }

    protected void setDefaultTenantDiscriminatorColumns(Iterable<ReadOnlyTenantDiscriminatorColumn2_3> tenantDiscriminatorColumns) {
        this.synchronizeList(tenantDiscriminatorColumns, this.defaultTenantDiscriminatorColumns, DEFAULT_TENANT_DISCRIMINATOR_COLUMNS_LIST);
    }

    protected ListIterable<ReadOnlyTenantDiscriminatorColumn2_3> buildDefaultTenantDiscriminatorColumns(EclipseLinkPersistenceUnitDefaults defaults) {
        return defaults == null ? EmptyListIterable.instance() : new SuperListIterableWrapper(defaults.getTenantDiscriminatorColumns());
    }

    public Iterable<EclipseLinkConverter> getAllConverters() {
        return this.getConverters();
    }

    public Iterable<EclipseLinkConverter> getConverters() {
        return new LiveCloneIterable(this.converters);
    }

    public int getConvertersSize() {
        return this.converters.size();
    }

    public Iterable<String> getUniqueConverterNames() {
        return CollectionTools.set(this.getNonEmptyConverterNames(), (int)this.getConvertersSize());
    }

    protected Iterable<String> getNonEmptyConverterNames() {
        return new FilteringIterable(this.getConverterNames(), NonEmptyStringFilter.instance());
    }

    protected Iterable<String> getConverterNames() {
        return new TransformationIterable(this.getConverters(), JpaNamedContextNode.NameTransformer.instance());
    }

    protected void setConverters(Iterable<EclipseLinkConverter> converters) {
        this.synchronizeCollection(converters, this.converters, CONVERTERS_COLLECTION);
    }

    protected Iterable<EclipseLinkConverter> buildConverters() {
        ArrayList result = CollectionTools.list(this.getMappingFileConverters());
        HashSet mappingFileConverterNames = this.convertToNames(result);
        HashMap javaConverters = this.mapByName(this.getAllJavaConverters());
        for (Map.Entry entry : javaConverters.entrySet()) {
            if (mappingFileConverterNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<EclipseLinkConverter> getMappingFileConverters() {
        return new CompositeIterable(this.getMappingFileConverterLists());
    }

    protected Iterable<Iterable<EclipseLinkConverter>> getMappingFileConverterLists() {
        return new TransformationIterable<MappingFile, Iterable<EclipseLinkConverter>>(this.getMappingFiles()){

            protected Iterable<EclipseLinkConverter> transform(MappingFile mappingFile) {
                MappingFileRoot root = mappingFile.getRoot();
                return root instanceof EclipseLinkEntityMappings ? ((EclipseLinkEntityMappings)root).getMappingFileConverters() : EmptyIterable.instance();
            }
        };
    }

    public Iterable<EclipseLinkConverter> getAllJavaConverters() {
        return new CompositeIterable(this.getAllJavaTypeMappingConverterLists());
    }

    protected Iterable<Iterable<EclipseLinkConverter>> getAllJavaTypeMappingConverterLists() {
        return new TransformationIterable<TypeMapping, Iterable<EclipseLinkConverter>>(this.getAllJavaTypeMappingsUnique()){

            protected Iterable<EclipseLinkConverter> transform(TypeMapping typeMapping) {
                return typeMapping instanceof EclipseLinkTypeMapping ? ((EclipseLinkTypeMapping)typeMapping).getConverters() : EmptyIterable.instance();
            }
        };
    }

    public EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    public EclipseLinkPersistenceXmlContextNodeFactory getContextNodeFactory() {
        return (EclipseLinkPersistenceXmlContextNodeFactory)super.getContextNodeFactory();
    }

    public void setSpecifiedSharedCacheMode(SharedCacheMode specifiedSharedCacheMode) {
        super.setSpecifiedSharedCacheMode(specifiedSharedCacheMode);
        if (specifiedSharedCacheMode == SharedCacheMode.NONE) {
            this.caching.removeDefaultCachingProperties();
        }
    }

    protected SharedCacheMode buildDefaultSharedCacheMode() {
        return SharedCacheMode.DISABLE_SELECTIVE;
    }

    public boolean calculateDefaultCacheable() {
        SharedCacheMode sharedCacheMode = this.getSharedCacheMode();
        if (sharedCacheMode == null) {
            return true;
        }
        switch (sharedCacheMode) {
            case NONE: 
            case ENABLE_SELECTIVE: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return true;
            }
        }
        return true;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConverters(messages, reporter);
    }

    protected void validateProperties(List<IMessage> messages, IReporter reporter) {
        if (this.isJpa2_0Compatible()) {
            for (PersistenceUnit.Property property : this.getLegacyEntityCachingProperties()) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_LEGACY_ENTITY_CACHING", new String[]{property.getName()}, this.getPersistenceUnit(), property.getValidationTextRange()));
            }
            for (PersistenceUnit.Property property : this.getLegacyDescriptorCustomizerProperties()) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_LEGACY_DESCRIPTOR_CUSTOMIZER", new String[]{property.getName()}, this.getPersistenceUnit(), property.getValidationTextRange()));
            }
            this.validateDefaultCachingProperty(this.getCacheTypeDefaultProperty(), messages);
            this.validateDefaultCachingProperty(this.getCacheSizeDefaultProperty(), messages);
            this.validateDefaultCachingProperty(this.getFlushClearCacheProperty(), messages);
            this.validateLoggerProperty(this.getLoggerProperty(), messages);
            this.validateExceptionHandlerProperty(this.getExceptionHandlerProperty(), messages);
            this.validatePerformanceProfilerProperty(this.getPerformanceProfilerProperty(), messages);
            this.validateSessionCustomizerProperty(this.getSessionCustomizerProperties(), messages);
        }
    }

    protected void validateDefaultCachingProperty(PersistenceUnit.Property cachingProperty, List<IMessage> messages) {
        if (this.getSharedCacheMode() == SharedCacheMode.NONE && cachingProperty != null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_CACHING_PROPERTY_IGNORED", new String[]{cachingProperty.getName()}, this.getPersistenceUnit(), cachingProperty.getValidationTextRange()));
        }
    }

    protected void validateLoggerProperty(PersistenceUnit.Property loggerProperty, List<IMessage> messages) {
        if (loggerProperty == null || loggerProperty.getValue() == null) {
            return;
        }
        if (ArrayTools.contains((Object[])Logging.RESERVED_LOGGER_NAMES, (Object)loggerProperty.getValue())) {
            return;
        }
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)loggerProperty.getValue())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_LOGGER_CLASS_NOT_SPECIFIED", EMPTY_STRING_ARRAY, this.getPersistenceUnit(), loggerProperty.getValidationTextRange()));
        } else if (JDTTools.findType((IJavaProject)javaProject, (String)loggerProperty.getValue()) == null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_LOGGER_CLASS_NOT_EXIST", new String[]{loggerProperty.getValue()}, this.getPersistenceUnit(), loggerProperty.getValidationTextRange()));
        } else if (!JDTTools.typeIsSubType((IJavaProject)javaProject, (String)loggerProperty.getValue(), (String)"org.eclipse.persistence.logging.SessionLog")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_LOGGER_CLASS_IMPLEMENTS_SESSION_LOG", new String[]{loggerProperty.getValue()}, this.getPersistenceUnit(), loggerProperty.getValidationTextRange()));
        }
    }

    private void validateExceptionHandlerProperty(PersistenceUnit.Property handlerProperty, List<IMessage> messages) {
        if (handlerProperty == null || handlerProperty.getValue() == null) {
            return;
        }
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)handlerProperty.getValue())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "EXCEPTION_HANDLER_CLASS_NOT_SPECIFIED", EMPTY_STRING_ARRAY, this.getPersistenceUnit(), handlerProperty.getValidationTextRange()));
        } else if (JDTTools.findType((IJavaProject)javaProject, (String)handlerProperty.getValue()) == null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "EXCEPTION_HANDLER_CLASS_NOT_EXIST", new String[]{handlerProperty.getValue()}, this.getPersistenceUnit(), handlerProperty.getValidationTextRange()));
        } else if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)handlerProperty.getValue())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "EXCEPTION_HANDLER_CLASS_NOT_VALID", new String[]{handlerProperty.getValue()}, this.getPersistenceUnit(), handlerProperty.getValidationTextRange()));
        } else if (!JDTTools.typeIsSubType((IJavaProject)javaProject, (String)handlerProperty.getValue(), (String)"org.eclipse.persistence.exceptions.ExceptionHandler")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "EXCEPTION_HANDLER_CLASS_IMPLEMENTS_EXCEPTION_HANDLER", new String[]{handlerProperty.getValue()}, this.getPersistenceUnit(), handlerProperty.getValidationTextRange()));
        }
    }

    private void validatePerformanceProfilerProperty(PersistenceUnit.Property profilerProperty, List<IMessage> messages) {
        if (profilerProperty == null || profilerProperty.getValue() == null) {
            return;
        }
        if (ArrayTools.contains((Object[])Customization.RESERVED_PROFILER_NAMES, (Object)profilerProperty.getValue())) {
            return;
        }
        IJavaProject javaProject = this.getJpaProject().getJavaProject();
        if (StringTools.stringIsEmpty((String)profilerProperty.getValue())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_PROFILER_CLASS_NOT_SPECIFIED", EMPTY_STRING_ARRAY, this.getPersistenceUnit(), profilerProperty.getValidationTextRange()));
        } else if (JDTTools.findType((IJavaProject)javaProject, (String)profilerProperty.getValue()) == null) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_PROFILER_CLASS_NOT_EXIST", new String[]{profilerProperty.getValue()}, this.getPersistenceUnit(), profilerProperty.getValidationTextRange()));
        } else if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)profilerProperty.getValue())) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_PROFILER_CLASS_NOT_VALID", new String[]{profilerProperty.getValue()}, this.getPersistenceUnit(), profilerProperty.getValidationTextRange()));
        } else if (!JDTTools.typeIsSubType((IJavaProject)javaProject, (String)profilerProperty.getValue(), (String)"org.eclipse.persistence.sessions.SessionProfiler")) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_PROFILER_CLASS_IMPLEMENTS_SESSION_PROFILER", new String[]{profilerProperty.getValue()}, this.getPersistenceUnit(), profilerProperty.getValidationTextRange()));
        }
    }

    private void validateSessionCustomizerProperty(Iterable<PersistenceUnit.Property> properties, List<IMessage> messages) {
        for (PersistenceUnit.Property property : properties) {
            if (property.getValue() == null) {
                return;
            }
            IJavaProject javaProject = this.getJpaProject().getJavaProject();
            if (StringTools.stringIsEmpty((String)property.getValue())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_CUSTOMIZER_CLASS_NOT_SPECIFIED", EMPTY_STRING_ARRAY, this.getPersistenceUnit(), property.getValidationTextRange()));
                continue;
            }
            if (JDTTools.findType((IJavaProject)javaProject, (String)property.getValue()) == null) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_CUSTOMIZER_CLASS_NOT_EXIST", new String[]{property.getValue()}, this.getPersistenceUnit(), property.getValidationTextRange()));
                continue;
            }
            if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)property.getValue())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_CUSTOMIZER_CLASS_NOT_VALID", new String[]{property.getValue()}, this.getPersistenceUnit(), property.getValidationTextRange()));
                continue;
            }
            if (JDTTools.typeIsSubType((IJavaProject)javaProject, (String)property.getValue(), (String)"org.eclipse.persistence.config.SessionCustomizer")) continue;
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "SESSION_CUSTOMIZER_CLASS_IMPLEMENTS_SESSION_CUSTOMIZER", new String[]{property.getValue()}, this.getPersistenceUnit(), property.getValidationTextRange()));
        }
    }

    protected ArrayList<PersistenceUnit.Property> getLegacyDescriptorCustomizerProperties() {
        ArrayList<PersistenceUnit.Property> result = new ArrayList<PersistenceUnit.Property>();
        CollectionTools.addAll(result, this.getDescriptorCustomizerProperties());
        return result;
    }

    protected ArrayList<PersistenceUnit.Property> getLegacyEntityCachingProperties() {
        ArrayList<PersistenceUnit.Property> result = new ArrayList<PersistenceUnit.Property>();
        CollectionTools.addAll(result, this.getSharedCacheProperties());
        CollectionTools.addAll(result, this.getEntityCacheTypeProperties());
        CollectionTools.addAll(result, this.getEntityCacheSizeProperties());
        return result;
    }

    private PersistenceUnit.Property getCacheTypeDefaultProperty() {
        return this.getProperty("eclipselink.cache.type.default");
    }

    private PersistenceUnit.Property getCacheSizeDefaultProperty() {
        return this.getProperty("eclipselink.cache.size.default");
    }

    private PersistenceUnit.Property getCacheSharedDefaultProperty() {
        return this.getProperty("eclipselink.cache.shared.default");
    }

    private PersistenceUnit.Property getFlushClearCacheProperty() {
        return this.getProperty("eclipselink.flush-clear.cache");
    }

    private Iterable<PersistenceUnit.Property> getSharedCacheProperties() {
        return this.getPropertiesWithNamePrefix("eclipselink.cache.shared.");
    }

    private Iterable<PersistenceUnit.Property> getEntityCacheSizeProperties() {
        return this.getEntityPropertiesWithPrefix("eclipselink.cache.size.");
    }

    private Iterable<PersistenceUnit.Property> getEntityCacheTypeProperties() {
        return this.getEntityPropertiesWithPrefix("eclipselink.cache.type.");
    }

    private Iterable<PersistenceUnit.Property> getDescriptorCustomizerProperties() {
        return this.getEntityPropertiesWithPrefix("eclipselink.descriptor.customizer.");
    }

    private Iterable<PersistenceUnit.Property> getEntityPropertiesWithPrefix(String prefix) {
        return new FilteringIterable<PersistenceUnit.Property>(this.getPropertiesWithNamePrefix(prefix)){

            protected boolean accept(PersistenceUnit.Property next) {
                return !next.getName().endsWith("default");
            }
        };
    }

    private PersistenceUnit.Property getLoggerProperty() {
        return this.getProperty("eclipselink.logging.logger");
    }

    private PersistenceUnit.Property getExceptionHandlerProperty() {
        return this.getProperty("eclipselink.exception-handler");
    }

    private PersistenceUnit.Property getPerformanceProfilerProperty() {
        return this.getProperty("eclipselink.profiler");
    }

    private Iterable<PersistenceUnit.Property> getSessionCustomizerProperties() {
        return this.getPropertiesWithNamePrefix("eclipselink.session.customizer");
    }

    protected void validateConverters(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateConverters(messages);
        for (EclipseLinkConverter converter : this.getConverters()) {
            this.validate(converter, messages, reporter);
        }
    }

    protected void checkForDuplicateConverters(List<IMessage> messages) {
        HashMap convertersByName = this.mapByName(this.getConverters());
        for (Map.Entry entry : convertersByName.entrySet()) {
            ArrayList dups;
            String converterName = (String)entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)converterName) || (dups = (ArrayList)entry.getValue()).size() <= 1) continue;
            HashMap convertersByType = this.mapByType(dups);
            if (convertersByType.size() > 1) {
                String[] parms = new String[]{converterName};
                for (EclipseLinkConverter dup : dups) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
                }
                continue;
            }
            for (EclipseLinkConverter dup : dups) {
                String[] parms = new String[]{dup.getName()};
                if (!this.hasDuplicateConverter(dup, dups)) continue;
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
            }
        }
    }

    private boolean hasDuplicateConverter(EclipseLinkConverter converter, ArrayList<EclipseLinkConverter> converters) {
        boolean isDuplicate = false;
        int i = 0;
        while (i < converters.size()) {
            if (converter != converters.get(i) && !converter.isIdentical(converters.get(i))) {
                isDuplicate = true;
            }
            ++i;
        }
        return isDuplicate;
    }

    protected TextRange extractNameTextRange(EclipseLinkConverter converter) {
        return converter instanceof OrmEclipseLinkConverter ? ((OrmEclipseLinkConverter)converter).getNameTextRange() : ((JavaEclipseLinkConverter)converter).getNameTextRange(null);
    }

    protected void validate(EclipseLinkConverter converter, List<IMessage> messages, IReporter reporter) {
        if (converter instanceof OrmEclipseLinkConverter) {
            ((OrmEclipseLinkConverter)converter).validate(messages, reporter);
        } else {
            ((JavaEclipseLinkConverter)converter).validate(messages, reporter, null);
        }
    }

    protected void checkForDuplicateGenerators(List<IMessage> messages) {
        HashMap generatorsByName = this.mapByName(this.getGenerators());
        for (Map.Entry entry : generatorsByName.entrySet()) {
            ArrayList dups;
            String generatorName = (String)entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)generatorName) || (dups = (ArrayList)entry.getValue()).size() <= 1) continue;
            HashMap generatorsByType = this.mapByType(dups);
            if (generatorsByType.size() > 1) {
                String[] parms = new String[]{generatorName};
                for (Generator dup : dups) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
                }
                continue;
            }
            for (Generator dup : dups) {
                String[] parms = new String[]{dup.getName()};
                if (this.hasDuplicateGenerator(dup, dups)) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
                    continue;
                }
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(4, "GENERATOR_IDENTICAL", parms, dup, this.extractNameTextRange(dup)));
            }
        }
    }

    private boolean hasDuplicateGenerator(Generator generator, ArrayList<Generator> generators) {
        boolean isDuplicate = false;
        int i = 0;
        while (i < generators.size()) {
            if (generator != generators.get(i) && !generator.isIdentical(generators.get(i))) {
                isDuplicate = true;
            }
            ++i;
        }
        return isDuplicate;
    }

    protected void checkForDuplicateQueries(List<IMessage> messages) {
        HashMap queriesByName = this.mapByName(this.getQueries());
        for (Map.Entry entry : queriesByName.entrySet()) {
            ArrayList dups;
            String queryName = (String)entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)queryName) || (dups = (ArrayList)entry.getValue()).size() <= 1) continue;
            HashMap querisByType = this.mapByType(dups);
            if (querisByType.size() > 1) {
                String[] parms = new String[]{queryName};
                for (Query dup : dups) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
                }
                continue;
            }
            for (Query dup : dups) {
                String[] parms = new String[]{dup.getName()};
                if (this.hasDuplicateQuery(dup, dups)) {
                    messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
                    continue;
                }
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(4, "QUERY_IDENTICAL", parms, dup, this.extractNameTextRange(dup)));
            }
        }
    }

    private boolean hasDuplicateQuery(Query query, ArrayList<Query> queries) {
        boolean isDuplicate = false;
        int i = 0;
        while (i < queries.size()) {
            if (query != queries.get(i) && !query.isIdentical(queries.get(i))) {
                isDuplicate = true;
            }
            ++i;
        }
        return isDuplicate;
    }

    private <N extends JpaNamedContextNode> HashMap<Class<? extends JpaNamedContextNode>, ArrayList<N>> mapByType(Iterable<N> nodes) {
        HashMap<Class<JpaNamedContextNode>, ArrayList<N>> map = new HashMap<Class<JpaNamedContextNode>, ArrayList<N>>();
        for (JpaNamedContextNode node : nodes) {
            Class type = node.getType();
            ArrayList<Object> list = map.get(type);
            if (list == null) {
                list = new ArrayList();
                map.put(type, list);
            }
            list.add(node);
        }
        return map;
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{super.createPersistenceUnitPropertiesRenameTypeEdits(originalType, newName), this.customization.createRenameTypeEdits(originalType, newName), this.logging.createRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{super.createPersistenceUnitPropertiesMoveTypeEdits(originalType, newPackage), this.customization.createMoveTypeEdits(originalType, newPackage), this.logging.createMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{super.createPersistenceUnitPropertiesRenamePackageEdits(originalPackage, newName), this.customization.createRenamePackageEdits(originalPackage, newName), this.logging.createRenamePackageEdits(originalPackage, newName)});
    }
}

