/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkObjectTypeConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkObjectTypeConverter
extends JavaEclipseLinkConverter<EclipseLinkObjectTypeConverterAnnotation>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String fullyQualifiedDataType;
    public static final String FULLY_QUALIFIED_DATA_TYPE_PROPERTY = "fullyQualifiedDataType";
    private String objectType;
    private String fullyQualifiedObjectType;
    public static final String FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY = "fullyQualifiedObjectType";
    protected final AbstractJpaNode.ContextListContainer<JavaEclipseLinkConversionValue, EclipseLinkConversionValueAnnotation> conversionValueContainer;
    private String defaultObjectValue;

    public JavaEclipseLinkObjectTypeConverter(JavaJpaContextNode parent, EclipseLinkObjectTypeConverterAnnotation converterAnnotation) {
        super(parent, converterAnnotation);
        this.dataType = converterAnnotation.getDataType();
        this.objectType = converterAnnotation.getObjectType();
        this.conversionValueContainer = this.buildConversionValueContainer();
        this.defaultObjectValue = converterAnnotation.getDefaultObjectValue();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDataType_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getDataType());
        this.setObjectType_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getObjectType());
        this.syncConversionValues();
        this.setDefaultObjectValue_(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getDefaultObjectValue());
    }

    @Override
    public void update() {
        super.update();
        this.setFullyQualifiedDataType(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedDataType());
        this.setFullyQualifiedObjectType(((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getFullyQualifiedObjectType());
        this.updateNodes((Iterable)this.getConversionValues());
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String dataType) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setDataType(dataType);
        this.setDataType_(dataType);
    }

    protected void setDataType_(String dataType) {
        String old = this.dataType;
        this.dataType = dataType;
        this.firePropertyChanged("dataType", old, dataType);
    }

    public String getFullyQualifiedDataType() {
        return this.fullyQualifiedDataType;
    }

    protected void setFullyQualifiedDataType(String dataType) {
        String old = this.fullyQualifiedDataType;
        this.fullyQualifiedDataType = dataType;
        this.firePropertyChanged(FULLY_QUALIFIED_DATA_TYPE_PROPERTY, old, dataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String objectType) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setObjectType(objectType);
        this.setObjectType_(objectType);
    }

    protected void setObjectType_(String objectType) {
        String old = this.objectType;
        this.objectType = objectType;
        this.firePropertyChanged("objectType", old, objectType);
    }

    public String getFullyQualifiedObjectType() {
        return this.fullyQualifiedObjectType;
    }

    protected void setFullyQualifiedObjectType(String objectType) {
        String old = this.fullyQualifiedObjectType;
        this.fullyQualifiedObjectType = objectType;
        this.firePropertyChanged(FULLY_QUALIFIED_OBJECT_TYPE_PROPERTY, old, objectType);
    }

    public ListIterable<JavaEclipseLinkConversionValue> getConversionValues() {
        return this.conversionValueContainer.getContextElements();
    }

    @Override
    public int getConversionValuesSize() {
        return this.conversionValueContainer.getContextElementsSize();
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.getConversionValuesSize());
    }

    @Override
    public JavaEclipseLinkConversionValue addConversionValue(int index) {
        EclipseLinkConversionValueAnnotation annotation = ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).addConversionValue(index);
        return (JavaEclipseLinkConversionValue)this.conversionValueContainer.addContextElement(index, (Object)annotation);
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValueContainer.indexOfContextElement((JpaContextNode)((JavaEclipseLinkConversionValue)conversionValue)));
    }

    @Override
    public void removeConversionValue(int index) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).removeConversionValue(index);
        this.conversionValueContainer.removeContextElement(index);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).moveConversionValue(targetIndex, sourceIndex);
        this.conversionValueContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected JavaEclipseLinkConversionValue buildConversionValue(EclipseLinkConversionValueAnnotation conversionValueAnnotation) {
        return new JavaEclipseLinkConversionValue(this, conversionValueAnnotation);
    }

    protected void syncConversionValues() {
        this.conversionValueContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<EclipseLinkConversionValueAnnotation> getConversionValueAnnotations() {
        return ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).getConversionValues();
    }

    protected AbstractJpaNode.ContextListContainer<JavaEclipseLinkConversionValue, EclipseLinkConversionValueAnnotation> buildConversionValueContainer() {
        ConversionValueContainer container = new ConversionValueContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getDataValues() {
        return new TransformationIterable<JavaEclipseLinkConversionValue, String>(this.getConversionValues()){

            protected String transform(JavaEclipseLinkConversionValue conversionValue) {
                return conversionValue.getDataValue();
            }
        };
    }

    @Override
    public int getDataValuesSize() {
        return this.getConversionValuesSize();
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String value) {
        ((EclipseLinkObjectTypeConverterAnnotation)this.converterAnnotation).setDefaultObjectValue(value);
        this.setDefaultObjectValue_(value);
    }

    protected void setDefaultObjectValue_(String value) {
        String old = this.defaultObjectValue;
        this.defaultObjectValue = value;
        this.firePropertyChanged("defaultObjectValue", old, value);
    }

    public Class<EclipseLinkObjectTypeConverter> getType() {
        return EclipseLinkObjectTypeConverter.class;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.checkForDuplicateDataValues(messages, astRoot);
        for (JavaEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            conversionValue.validate(messages, reporter, astRoot);
        }
    }

    protected void checkForDuplicateDataValues(List<IMessage> messages, CompilationUnit astRoot) {
        for (ArrayList<JavaEclipseLinkConversionValue> dups : this.mapConversionValuesByDataValue().values()) {
            if (dups.size() <= 1) continue;
            for (JavaEclipseLinkConversionValue dup : dups) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "MULTIPLE_OBJECT_VALUES_FOR_DATA_VALUE", new String[]{dup.getDataValue()}, this, dup.getDataValueTextRange(astRoot)));
            }
        }
    }

    protected HashMap<String, ArrayList<JavaEclipseLinkConversionValue>> mapConversionValuesByDataValue() {
        HashMap<String, ArrayList<JavaEclipseLinkConversionValue>> map = new HashMap<String, ArrayList<JavaEclipseLinkConversionValue>>(this.getConversionValuesSize());
        for (JavaEclipseLinkConversionValue conversionValue : this.getConversionValues()) {
            String dataValue = conversionValue.getDataValue();
            ArrayList<JavaEclipseLinkConversionValue> list = map.get(dataValue);
            if (list == null) {
                list = new ArrayList();
                map.put(dataValue, list);
            }
            list.add(conversionValue);
        }
        return map;
    }

    @Override
    public boolean isIdentical(EclipseLinkConverter eclipseLinkConverter) {
        return super.isIdentical(eclipseLinkConverter) && StringTools.stringsAreEqual((String)this.getFullyQualifiedObjectType(), (String)((JavaEclipseLinkObjectTypeConverter)eclipseLinkConverter).getFullyQualifiedObjectType()) && StringTools.stringsAreEqual((String)this.getFullyQualifiedDataType(), (String)((JavaEclipseLinkObjectTypeConverter)eclipseLinkConverter).getFullyQualifiedDataType()) && StringTools.stringsAreEqual((String)this.getDefaultObjectValue(), (String)((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getDefaultObjectValue()) && this.conversionValuesAreIdentical(((EclipseLinkObjectTypeConverter)eclipseLinkConverter).getConversionValues());
    }

    private boolean conversionValuesAreIdentical(ListIterable<? extends EclipseLinkConversionValue> conversionValues) {
        boolean isIdentical = true;
        if (this.getConversionValuesSize() != CollectionTools.size(conversionValues)) {
            return false;
        }
        int i = 0;
        while (i < this.getConversionValuesSize()) {
            if (!((JavaEclipseLinkConversionValue)CollectionTools.get(this.getConversionValues(), (int)i)).isIdentical((EclipseLinkConversionValue)CollectionTools.get(conversionValues, (int)i))) {
                isIdentical = false;
            }
            ++i;
        }
        return isIdentical;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Adapter
    extends JavaEclipseLinkConverter.AbstractAdapter {
        private static final Adapter INSTANCE = new Adapter();

        public static Adapter instance() {
            return INSTANCE;
        }

        private Adapter() {
        }

        public Class<EclipseLinkObjectTypeConverter> getConverterType() {
            return EclipseLinkObjectTypeConverter.class;
        }

        @Override
        protected String getAnnotationName() {
            return "org.eclipse.persistence.annotations.ObjectTypeConverter";
        }

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation converterAnnotation, JavaJpaContextNode parent) {
            return new JavaEclipseLinkObjectTypeConverter(parent, (EclipseLinkObjectTypeConverterAnnotation)converterAnnotation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConversionValueContainer
    extends AbstractJpaNode.ContextListContainer<JavaEclipseLinkConversionValue, EclipseLinkConversionValueAnnotation> {
        protected ConversionValueContainer() {
            super((AbstractJpaNode)JavaEclipseLinkObjectTypeConverter.this);
        }

        protected String getContextElementsPropertyName() {
            return "conversionValues";
        }

        protected JavaEclipseLinkConversionValue buildContextElement(EclipseLinkConversionValueAnnotation resourceElement) {
            return JavaEclipseLinkObjectTypeConverter.this.buildConversionValue(resourceElement);
        }

        protected ListIterable<EclipseLinkConversionValueAnnotation> getResourceElements() {
            return JavaEclipseLinkObjectTypeConverter.this.getConversionValueAnnotations();
        }

        protected EclipseLinkConversionValueAnnotation getResourceElement(JavaEclipseLinkConversionValue contextElement) {
            return contextElement.getConversionValueAnnotation();
        }
    }
}

