/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlCustomizerHolder;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkCustomizer
extends AbstractOrmXmlContextNode
implements EclipseLinkCustomizer {
    protected String specifiedCustomizerClass = this.buildSpecifiedCustomizerClass();
    protected String defaultCustomizerClass;

    public OrmEclipseLinkCustomizer(EclipseLinkOrmTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedCustomizerClass_(this.buildSpecifiedCustomizerClass());
    }

    public void update() {
        super.update();
        this.setDefaultCustomizerClass(this.buildDefaultCustomizerClass());
    }

    @Override
    public String getCustomizerClass() {
        return this.specifiedCustomizerClass != null ? this.specifiedCustomizerClass : this.defaultCustomizerClass;
    }

    @Override
    public String getSpecifiedCustomizerClass() {
        return this.specifiedCustomizerClass;
    }

    @Override
    public void setSpecifiedCustomizerClass(String customizerClass) {
        if (this.valuesAreDifferent(this.specifiedCustomizerClass, customizerClass)) {
            XmlClassReference xmlClassRef = this.getXmlCustomizerClassRefForUpdate();
            this.setSpecifiedCustomizerClass_(customizerClass);
            xmlClassRef.setClassName(customizerClass);
            this.removeXmlCustomizerClassRefIfUnset();
        }
    }

    protected void setSpecifiedCustomizerClass_(String customizerClass) {
        String old = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = customizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", old, customizerClass);
    }

    protected String buildSpecifiedCustomizerClass() {
        XmlClassReference xmlClassRef = this.getXmlCustomizerClassRef();
        return xmlClassRef == null ? null : xmlClassRef.getClassName();
    }

    @Override
    public String getDefaultCustomizerClass() {
        return this.defaultCustomizerClass;
    }

    protected void setDefaultCustomizerClass(String customizerClass) {
        String old = this.defaultCustomizerClass;
        this.defaultCustomizerClass = customizerClass;
        this.firePropertyChanged("defaultCustomizerClass", old, customizerClass);
    }

    protected String buildDefaultCustomizerClass() {
        JavaEclipseLinkCustomizer javaCustomizer = this.getJavaCustomizerForDefaults();
        return javaCustomizer == null ? null : javaCustomizer.getFullyQualifiedCustomizerClass();
    }

    protected XmlClassReference getXmlCustomizerClassRef() {
        return this.getXmlCustomizerHolder().getCustomizer();
    }

    protected XmlClassReference getXmlCustomizerClassRefForUpdate() {
        XmlClassReference xmlClassRef = this.getXmlCustomizerClassRef();
        return xmlClassRef != null ? xmlClassRef : this.buildXmlCustomizerClassRef();
    }

    protected XmlClassReference buildXmlCustomizerClassRef() {
        XmlClassReference ref = OrmFactory.eINSTANCE.createXmlClassReference();
        this.getXmlCustomizerHolder().setCustomizer(ref);
        return ref;
    }

    protected void removeXmlCustomizerClassRefIfUnset() {
        if (this.getXmlCustomizerClassRef().isUnset()) {
            this.removeXmlCustomizerClassRef();
        }
    }

    protected void removeXmlCustomizerClassRef() {
        this.getXmlCustomizerHolder().setCustomizer(null);
    }

    protected JavaResourceAbstractType getResourceCustomizerType() {
        XmlClassReference customizerClassRef = this.getXmlCustomizerClassRef();
        if (customizerClassRef == null) {
            return null;
        }
        String className = customizerClassRef.getClassName();
        if (className == null) {
            return null;
        }
        return this.getEntityMappings().resolveJavaResourceType(className);
    }

    public EclipseLinkOrmTypeMapping getParent() {
        return (EclipseLinkOrmTypeMapping)super.getParent();
    }

    protected EclipseLinkOrmTypeMapping getTypeMapping() {
        return this.getParent();
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.getTypeMapping().getXmlTypeMapping();
    }

    protected XmlCustomizerHolder getXmlCustomizerHolder() {
        return (XmlCustomizerHolder)this.getXmlTypeMapping();
    }

    protected EclipseLinkJavaTypeMapping getJavaTypeMappingForDefaults() {
        return this.getTypeMapping().getJavaTypeMappingForDefaults();
    }

    protected JavaEclipseLinkCustomizer getJavaCustomizerForDefaults() {
        EclipseLinkJavaTypeMapping javaTypeMapping = this.getJavaTypeMappingForDefaults();
        return javaTypeMapping == null ? null : (JavaEclipseLinkCustomizer)javaTypeMapping.getCustomizer();
    }

    protected EntityMappings getEntityMappings() {
        return this.getMappingFileRoot();
    }

    protected boolean isFor(String typeName) {
        JavaResourceAbstractType customizerType = this.getResourceCustomizerType();
        return customizerType != null && customizerType.getQualifiedName().equals(typeName);
    }

    protected boolean isIn(IPackageFragment packageFragment) {
        JavaResourceAbstractType customizerType = this.getResourceCustomizerType();
        return customizerType != null && customizerType.isIn(packageFragment);
    }

    @Override
    public char getCustomizerClassEnclosingTypeSeparator() {
        return '$';
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameTypeEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        return this.getXmlCustomizerClassRef().createRenameEdit(originalType, newName);
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.getXmlCustomizerClassRef().createRenamePackageEdit(newName);
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateCustomizerClass(messages);
    }

    protected void validateCustomizerClass(List<IMessage> messages) {
        IJavaProject javaProject = this.getPersistenceUnit().getJpaProject().getJavaProject();
        if (this.getCustomizerClass() != null) {
            if (StringTools.stringIsEmpty((String)this.getCustomizerClass())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_NOT_SPECIFIED", EMPTY_STRING_ARRAY, this, this.getValidationTextRange()));
            } else if (JDTTools.findType((IJavaProject)javaProject, (String)this.getCustomizerClass()) == null) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_NOT_EXIST", new String[]{this.getCustomizerClass()}, this, this.getValidationTextRange()));
            } else if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)this.getCustomizerClass())) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_NOT_VALID", new String[]{this.getCustomizerClass()}, this, this.getValidationTextRange()));
            } else if (!JDTTools.typeIsSubType((IJavaProject)javaProject, (String)this.getCustomizerClass(), (String)"org.eclipse.persistence.config.DescriptorCustomizer")) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "DESCRIPTOR_CUSTOMIZER_CLASS_IMPLEMENTS_DESCRIPTOR_CUSTOMIZER", new String[]{this.getCustomizerClass()}, this, this.getValidationTextRange()));
            }
        }
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlValidationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getXmlValidationTextRange() {
        XmlClassReference xmlClassRef = this.getXmlCustomizerClassRef();
        return xmlClassRef == null ? null : xmlClassRef.getClassNameTextRange();
    }
}

