/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Logging2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.LoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.EclipseLinkLogging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLogging2_0
extends EclipseLinkLogging
implements Logging2_0 {
    private Map<String, LoggingLevel> categoryValues;
    private Boolean connection;
    private LoggingLevel categoriesDefaultValue;

    public EclipseLinkLogging2_0(PersistenceUnit2_0 parent) {
        super((PersistenceUnit)parent);
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.connection = this.getBooleanValue("eclipselink.logging.connection");
        this.categoriesDefaultValue = (LoggingLevel)this.getEnumValue("eclipselink.logging.level", LoggingLevel.values());
        this.initializeCategory("sqlLoggingLevel");
        this.initializeCategory("transactionLoggingLevel");
        this.initializeCategory("eventLoggingLevel");
        this.initializeCategory("connectionLoggingLevel");
        this.initializeCategory("queryLoggingLevel");
        this.initializeCategory("cacheLoggingLevel");
        this.initializeCategory("propagationLoggingLevel");
        this.initializeCategory("sequencingLoggingLevel");
        this.initializeCategory("ejbLoggingLevel");
        this.initializeCategory("dmsLoggingLevel");
        this.initializeCategory("ejb_or_metadataLoggingLevel");
        this.initializeCategory("jpa_metamodelLoggingLevel");
        this.initializeCategory("weaverLoggingLevel");
        this.initializeCategory("propertiesLoggingLevel");
        this.initializeCategory("serverLoggingLevel");
    }

    protected void initialize() {
        super.initialize();
        this.categoryValues = new HashMap<String, LoggingLevel>();
    }

    private void initializeCategory(String categoryId) {
        String puKey = this.persistenceUnitKeyOf(categoryId);
        LoggingLevel puValue = (LoggingLevel)this.getEnumValue(puKey, LoggingLevel.values());
        this.categoryValues.put(categoryId, puValue);
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        if (propertyName.equals("eclipselink.logging.connection")) {
            this.connectionChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.level.sql")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.sql", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.transaction")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.transaction", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.event")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.event", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.connection")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.connection", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.query")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.query", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.cache")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.cache", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.propagation")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.propagation", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.sequencing")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.sequencing", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.ejb")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.ejb", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.dms")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.dms", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.ejb_or_metadata")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.ejb_or_metadata", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.jpa_metamodel")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.jpa_metamodel", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.weaver")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.weaver", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.properties")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.properties", newValue);
        } else if (propertyName.equals("eclipselink.logging.level.server")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.server", newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        if (propertyName.equals("eclipselink.logging.connection")) {
            this.connectionChanged(null);
        } else if (propertyName.equals("eclipselink.logging.level.sql")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.sql", null);
        } else if (propertyName.equals("eclipselink.logging.level.transaction")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.transaction", null);
        } else if (propertyName.equals("eclipselink.logging.level.event")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.event", null);
        } else if (propertyName.equals("eclipselink.logging.level.connection")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.connection", null);
        } else if (propertyName.equals("eclipselink.logging.level.query")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.query", null);
        } else if (propertyName.equals("eclipselink.logging.level.cache")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.cache", null);
        } else if (propertyName.equals("eclipselink.logging.level.propagation")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.propagation", null);
        } else if (propertyName.equals("eclipselink.logging.level.sequencing")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.sequencing", null);
        } else if (propertyName.equals("eclipselink.logging.level.ejb")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.ejb", null);
        } else if (propertyName.equals("eclipselink.logging.level.dms")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.dms", null);
        } else if (propertyName.equals("eclipselink.logging.level.ejb_or_metadata")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.ejb_or_metadata", null);
        } else if (propertyName.equals("eclipselink.logging.level.jpa_metamodel")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.jpa_metamodel", null);
        } else if (propertyName.equals("eclipselink.logging.level.weaver")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.weaver", null);
        } else if (propertyName.equals("eclipselink.logging.level.properties")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.properties", null);
        } else if (propertyName.equals("eclipselink.logging.level.server")) {
            this.categoryLoggingChanged_("eclipselink.logging.level.server", null);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.put("eclipselink.logging.connection", "connection");
        propertyNames.put("eclipselink.logging.level.sql", "sqlLoggingLevel");
        propertyNames.put("eclipselink.logging.level.transaction", "transactionLoggingLevel");
        propertyNames.put("eclipselink.logging.level.event", "eventLoggingLevel");
        propertyNames.put("eclipselink.logging.level.connection", "connectionLoggingLevel");
        propertyNames.put("eclipselink.logging.level.query", "queryLoggingLevel");
        propertyNames.put("eclipselink.logging.level.cache", "cacheLoggingLevel");
        propertyNames.put("eclipselink.logging.level.propagation", "propagationLoggingLevel");
        propertyNames.put("eclipselink.logging.level.sequencing", "sequencingLoggingLevel");
        propertyNames.put("eclipselink.logging.level.ejb", "ejbLoggingLevel");
        propertyNames.put("eclipselink.logging.level.dms", "dmsLoggingLevel");
        propertyNames.put("eclipselink.logging.level.ejb_or_metadata", "ejb_or_metadataLoggingLevel");
        propertyNames.put("eclipselink.logging.level.jpa_metamodel", "jpa_metamodelLoggingLevel");
        propertyNames.put("eclipselink.logging.level.weaver", "weaverLoggingLevel");
        propertyNames.put("eclipselink.logging.level.properties", "propertiesLoggingLevel");
        propertyNames.put("eclipselink.logging.level.server", "serverLoggingLevel");
    }

    @Override
    public Boolean getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Boolean newConnection) {
        Boolean old = this.connection;
        this.connection = newConnection;
        this.putProperty("connection", newConnection);
        this.firePropertyChanged("connection", old, newConnection);
    }

    private void connectionChanged(String stringValue) {
        Boolean newValue = EclipseLinkLogging2_0.getBooleanValueOf((String)stringValue);
        Boolean old = this.connection;
        this.connection = newValue;
        this.firePropertyChanged("connection", old, newValue);
    }

    @Override
    public Boolean getDefaultConnection() {
        return DEFAULT_CONNECTION;
    }

    @Override
    public LoggingLevel getLevel(String category) {
        return this.categoryValues.get(category);
    }

    @Override
    public void setLevel(String category, LoggingLevel newLevel) {
        LoggingLevel old = this.getLevel(category);
        this.categoryValues.put(category, newLevel);
        this.putProperty(category, (Object)newLevel);
        this.firePropertyChanged(category, (Object)old, (Object)newLevel);
    }

    private void categoryLoggingChanged_(String eclipselinkKey, String stringValue) {
        String category = this.propertyIdOf(eclipselinkKey);
        this.categoryLoggingChanged(category, stringValue);
    }

    private void categoryLoggingChanged(String category, String stringValue) {
        LoggingLevel enumValue = (LoggingLevel)EclipseLinkLogging2_0.getEnumValueOf((String)stringValue, (Enum[])LoggingLevel.values());
        LoggingLevel old = this.getLevel(category);
        this.categoryValues.put(category, enumValue);
        this.firePropertyChanged(category, (Object)old, (Object)enumValue);
    }

    @Override
    public LoggingLevel getCategoriesDefaultLevel() {
        return this.categoriesDefaultValue == null ? super.getDefaultLevel() : this.categoriesDefaultValue;
    }

    @Override
    public void setLevel(LoggingLevel level) {
        super.setLevel(level);
        this.setDefaultLevel(level);
    }

    @Override
    public void setDefaultLevel(LoggingLevel level) {
        LoggingLevel old = this.categoriesDefaultValue;
        this.categoriesDefaultValue = level;
        this.firePropertyChanged("categoriesDefaultLoggingLevel", (Object)old, (Object)level);
    }
}

