/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseEclipseLinkConvertAnnotation
extends SourceAnnotation
implements EclipseLinkConvertAnnotation {
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter = this.buildValueDeclarationAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    protected SourceBaseEclipseLinkConvertAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, element, daa);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.valueDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return (String)this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    @Override
    public boolean valueTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.valueDeclarationAdapter, pos, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildValueDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, this.getValueElementName(), StringExpressionConverter.instance());
    }

    protected abstract String getValueElementName();
}

