/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.AspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.jaxb.core.JaxbFactory;
import org.eclipse.jpt.jaxb.core.JaxbFile;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbNode
extends AbstractModel
implements JaxbNode {
    private final JaxbNode parent;
    private static final HashMap<Class<? extends AbstractJaxbNode>, HashSet<String>> nonUpdateAspectNameSets = new HashMap();

    protected AbstractJaxbNode(JaxbNode parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    protected void checkParent(JaxbNode p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected ChangeSupport buildChangeSupport() {
        return new AspectChangeSupport((Model)this, this.buildChangeSupportListener());
    }

    protected AspectChangeSupport.Listener buildChangeSupportListener() {
        return new AspectChangeSupport.Listener(){

            public void aspectChanged(String aspectName) {
                AbstractJaxbNode.this.aspectChanged(aspectName);
            }
        };
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public JaxbNode getParent() {
        return this.parent;
    }

    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this.parent.getJaxbProject();
    }

    protected JaxbPlatform getPlatform() {
        return this.getJaxbProject().getPlatform();
    }

    protected JaxbFactory getFactory() {
        return this.getPlatform().getFactory();
    }

    protected JaxbFile getJaxbFile(IFile file) {
        return this.getJaxbProject().getJaxbFile(file);
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectTriggersUpdate(aspectName)) {
            this.stateChanged();
        }
    }

    private boolean aspectTriggersUpdate(String aspectName) {
        return !this.aspectDoesNotTriggerUpdate(aspectName);
    }

    protected boolean aspectDoesNotTriggerUpdate(String aspectName) {
        return aspectName == null || this.nonUpdateAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonUpdateAspectNames() {
        HashMap<Class<? extends AbstractJaxbNode>, HashSet<String>> hashMap = nonUpdateAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> nonUpdateAspectNames = nonUpdateAspectNameSets.get(this.getClass());
            if (nonUpdateAspectNames == null) {
                nonUpdateAspectNames = new HashSet();
                this.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
                nonUpdateAspectNameSets.put(this.getClass(), nonUpdateAspectNames);
            }
            return nonUpdateAspectNames;
        }
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
    }

    @Override
    public void stateChanged() {
        this.fireStateChanged();
        if (this.parent != null) {
            this.parent.stateChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class CollectionContainer<C, R> {
        protected final Vector<C> contextElements = new Vector();

        protected CollectionContainer() {
        }

        protected abstract Iterable<R> getResourceElements();

        protected abstract R getResourceElement(C var1);

        protected abstract C buildContextElement(R var1);

        protected abstract String getContextElementsPropertyName();

        public void initialize() {
            for (R resourceElement : this.getResourceElements()) {
                this.contextElements.add(this.buildContextElement(resourceElement));
            }
        }

        public Iterable<C> getContextElements() {
            return new LiveCloneIterable(this.contextElements);
        }

        public int getContextElementsSize() {
            return this.contextElements.size();
        }

        public C addContextElement(int index, R resourceElement) {
            return this.addContextElement_(index, this.buildContextElement(resourceElement));
        }

        protected C addContextElement_(int index, C contextElement) {
            AbstractJaxbNode.this.addItemToCollection(contextElement, this.contextElements, this.getContextElementsPropertyName());
            return contextElement;
        }

        public void removeContextElement(C element) {
            AbstractJaxbNode.this.removeItemFromCollection(element, this.contextElements, this.getContextElementsPropertyName());
        }

        protected void moveContextElement(int index, C element) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ContextCollectionContainer<C extends JaxbContextNode, R>
    extends CollectionContainer<C, R> {
        protected ContextCollectionContainer() {
        }

        public void synchronizeWithResourceModel() {
            this.sync(true);
        }

        public void update() {
            this.sync(false);
        }

        protected void sync(boolean sync) {
            HashSet contextElements = CollectionTools.set(this.getContextElements());
            int resourceIndex = 0;
            for (Object resourceElement : this.getResourceElements()) {
                boolean match = false;
                Iterator stream = contextElements.iterator();
                while (stream.hasNext()) {
                    JaxbContextNode contextElement = (JaxbContextNode)stream.next();
                    if (!Tools.valuesAreEqual(this.getResourceElement(contextElement), resourceElement)) continue;
                    this.moveContextElement(resourceIndex, contextElement);
                    stream.remove();
                    if (sync) {
                        contextElement.synchronizeWithResourceModel();
                    } else {
                        contextElement.update();
                    }
                    match = true;
                    break;
                }
                if (!match) {
                    this.addContextElement(resourceIndex, resourceElement);
                }
                ++resourceIndex;
            }
            for (JaxbContextNode contextElement : contextElements) {
                this.removeContextElement(contextElement);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ContextListContainer<C extends JaxbContextNode, R>
    extends ContextCollectionContainer<C, R> {
        protected ContextListContainer() {
        }

        @Override
        public ListIterable<C> getContextElements() {
            return new LiveCloneListIterable((List)this.contextElements);
        }

        @Override
        protected abstract ListIterable<R> getResourceElements();

        public int indexOfContextElement(C contextElement) {
            return this.contextElements.indexOf(contextElement);
        }

        public C getContextElement(int index) {
            return (C)((JaxbContextNode)this.contextElements.elementAt(index));
        }

        @Override
        protected C addContextElement_(int index, C contextElement) {
            AbstractJaxbNode.this.addItemToList(index, contextElement, this.contextElements, this.getContextElementsPropertyName());
            return contextElement;
        }

        @Override
        public void moveContextElement(int targetIndex, int sourceIndex) {
            this.moveContextElement(targetIndex, (C)((JaxbContextNode)this.contextElements.get(sourceIndex)));
        }

        @Override
        public void moveContextElement(int index, C element) {
            AbstractJaxbNode.this.moveItemInList(index, element, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void removeContextElement(int index) {
            AbstractJaxbNode.this.removeItemFromList(index, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void removeContextElement(C contextElement) {
            AbstractJaxbNode.this.removeItemFromList(contextElement, this.contextElements, this.getContextElementsPropertyName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ListContainer<C, R>
    extends CollectionContainer<C, R> {
        protected ListContainer() {
        }

        @Override
        public ListIterable<C> getContextElements() {
            return new LiveCloneListIterable((List)this.contextElements);
        }

        @Override
        protected abstract ListIterable<R> getResourceElements();

        public int indexOfContextElement(C contextElement) {
            return this.contextElements.indexOf(contextElement);
        }

        public C getContextElement(int index) {
            return (C)this.contextElements.elementAt(index);
        }

        @Override
        protected C addContextElement_(int index, C contextElement) {
            AbstractJaxbNode.this.addItemToList(index, contextElement, this.contextElements, this.getContextElementsPropertyName());
            return contextElement;
        }

        @Override
        public void moveContextElement(int targetIndex, int sourceIndex) {
            this.moveContextElement(targetIndex, this.contextElements.get(sourceIndex));
        }

        @Override
        public void moveContextElement(int index, C element) {
            AbstractJaxbNode.this.moveItemInList(index, element, this.contextElements, this.getContextElementsPropertyName());
        }

        @Override
        public void removeContextElement(int index) {
            AbstractJaxbNode.this.removeItemFromList(index, this.contextElements, this.getContextElementsPropertyName());
        }

        public void synchronizeWithResourceModel() {
            ListIterable<R> resourceElements = this.getResourceElements();
            int index = 0;
            for (Object resourceElement : resourceElements) {
                if (this.getContextElementsSize() > index) {
                    if (this.getContextElement(index) != resourceElement) {
                        this.addContextElement(index, resourceElement);
                    }
                } else {
                    this.addContextElement(index, resourceElement);
                }
                ++index;
            }
            while (index < this.getContextElementsSize()) {
                this.removeContextElement(index);
            }
        }
    }
}

