/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaEntry;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.internal.SchemaEntryImpl;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaLibraryImpl
implements SchemaLibrary {
    private JaxbProject project;
    private final List<SchemaEntryImpl> schemaEntries;
    private final Map<String, SchemaEntryImpl> impliedEntries;

    SchemaLibraryImpl(JaxbProject project) {
        this.project = project;
        this.schemaEntries = new Vector<SchemaEntryImpl>();
        this.impliedEntries = new Hashtable<String, SchemaEntryImpl>();
        this.readProjectPreferences();
    }

    @Override
    public List<SchemaEntry> getSchemaEntries() {
        return Collections.unmodifiableList(this.schemaEntries);
    }

    @Override
    public List<String> getSchemaLocations() {
        return Collections.unmodifiableList(CollectionTools.list((Iterable)new TransformationIterable<SchemaEntry, String>(this.schemaEntries){

            protected String transform(SchemaEntry o) {
                return o.getLocation();
            }
        }));
    }

    @Override
    public void setSchemaLocations(List<String> schemaLocations) {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.dispose();
        }
        this.schemaEntries.clear();
        JptJaxbCorePlugin.setSchemaLocations(this.project.getProject(), schemaLocations);
        this.readProjectPreferences();
    }

    @Override
    public XsdSchema getSchema(String namespace) {
        for (SchemaEntry schemaEntry : this.schemaEntries) {
            if (!StringTools.stringsAreEqual((String)namespace, (String)schemaEntry.getNamespace())) continue;
            return schemaEntry.getXsdSchema(namespace);
        }
        if (!this.impliedEntries.containsKey(namespace)) {
            if (!StringTools.stringsAreEqual((String)XsdUtil.getResolvedUri(namespace), (String)namespace)) {
                this.impliedEntries.put(namespace, new SchemaEntryImpl(namespace));
            } else {
                return null;
            }
        }
        return this.impliedEntries.get(namespace).getXsdSchema(namespace);
    }

    protected void readProjectPreferences() {
        List<String> schemas = JptJaxbCorePlugin.getSchemaLocations(this.project.getProject());
        for (String schemaLocation : schemas) {
            SchemaEntryImpl entry = new SchemaEntryImpl(schemaLocation);
            this.schemaEntries.add(entry);
        }
    }

    @Override
    public void refreshSchema(String namespace) {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            if (!StringTools.stringsAreEqual((String)namespace, (String)entry.getNamespace())) continue;
            entry.refresh();
        }
    }

    @Override
    public void refreshAllSchemas() {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.refresh();
        }
    }

    void dispose() {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.dispose();
        }
        for (SchemaEntryImpl entry : this.impliedEntries.values()) {
            entry.dispose();
        }
        this.schemaEntries.clear();
        this.impliedEntries.clear();
    }

    public void validate(List<IMessage> messages) {
        HashBag namespaces = new HashBag();
        for (SchemaEntry schemaEntry : this.schemaEntries) {
            namespaces.add((Object)schemaEntry.getNamespace());
            if (schemaEntry.isLoaded()) continue;
            messages.add(DefaultValidationMessages.buildMessage(1, "PROJECT__UNRESOLVED_SCHEMA", new String[]{schemaEntry.getLocation()}, this.project));
        }
        Iterator iterator = namespaces.uniqueIterator();
        while (iterator.hasNext()) {
            String namespace = (String)iterator.next();
            if (namespaces.count((Object)namespace) <= 1) continue;
            messages.add(DefaultValidationMessages.buildMessage(1, "PROJECT__DUPLICATE_NAMESPACE", new String[]{namespace}, this.project));
        }
    }
}

