/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbContextRoot
extends AbstractJaxbContextNode
implements JaxbContextRoot {
    protected final JaxbProject jaxbProject;
    protected final Map<String, JaxbPackage> packages;
    protected final Map<String, JaxbType> types;

    public AbstractJaxbContextRoot(JaxbProject jaxbProject) {
        super(null);
        if (jaxbProject == null) {
            throw new NullPointerException();
        }
        this.jaxbProject = jaxbProject;
        this.packages = new Hashtable<String, JaxbPackage>();
        this.types = new Hashtable<String, JaxbType>();
        this.initialize();
    }

    @Override
    public JaxbContextRoot getContextRoot() {
        return this;
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    protected void initialize() {
        for (String pkg : this.calculateInitialPackageNames()) {
            this.packages.put(pkg, this.buildPackage(pkg));
        }
        HashSet<String> totalTypeNames = new HashSet<String>();
        for (JavaResourceAbstractType resourceType : this.calculateInitialTypes()) {
            totalTypeNames.add(resourceType.getQualifiedName());
            this.addType_(this.buildType(resourceType));
        }
        for (String pkg : this.calculatePackageNames(totalTypeNames)) {
            if (this.packages.containsKey(pkg)) continue;
            this.packages.put(pkg, this.buildPackage(pkg));
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            jaxbPackage.synchronizeWithResourceModel();
        }
        for (JaxbType jaxbType : this.getTypes()) {
            jaxbType.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        HashSet packagesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet typesToUpdate = CollectionTools.set((Object[])new String[0]);
        HashSet packagesToRemove = CollectionTools.set(this.packages.keySet());
        HashSet typesToRemove = CollectionTools.set(this.types.keySet());
        HashSet totalTypes = CollectionTools.set((Object[])new String[0]);
        HashSet typesToScan = CollectionTools.set((Object[])new String[0]);
        for (String pkg : this.calculateInitialPackageNames()) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        Set<JavaResourceAbstractType> resourceTypesToProcess = this.calculateInitialTypes();
        HashSet<JavaResourceAbstractType> referencedTypes = new HashSet<JavaResourceAbstractType>();
        while (!resourceTypesToProcess.isEmpty() || !typesToScan.isEmpty()) {
            for (JavaResourceAbstractType resourceType : new SnapshotCloneIterable(resourceTypesToProcess)) {
                String className = resourceType.getQualifiedName();
                typesToRemove.remove(className);
                totalTypes.add(className);
                typesToScan.add(className);
                this.processType(resourceType, typesToUpdate, referencedTypes.contains(resourceType));
                resourceTypesToProcess.remove(resourceType);
            }
            for (String typeToScan : new SnapshotCloneIterable((Collection)typesToScan)) {
                JaxbType jaxbType = this.getType(typeToScan);
                if (jaxbType != null) {
                    for (String referencedTypeName : jaxbType.getReferencedXmlTypeNames()) {
                        JavaResourceAbstractType referencedType;
                        if (StringTools.stringIsEmpty((String)referencedTypeName) || totalTypes.contains(referencedTypeName) || (referencedType = this.getJaxbProject().getJavaResourceType(referencedTypeName)) == null) continue;
                        resourceTypesToProcess.add(referencedType);
                        referencedTypes.add(referencedType);
                    }
                }
                typesToScan.remove(typeToScan);
            }
        }
        for (String pkg : this.calculatePackageNames(totalTypes)) {
            if (this.packages.containsKey(pkg)) {
                packagesToUpdate.add(pkg);
                packagesToRemove.remove(pkg);
                continue;
            }
            this.addPackage(this.buildPackage(pkg));
        }
        for (String packageToUpdate : packagesToUpdate) {
            this.packages.get(packageToUpdate).update();
        }
        for (String typeToUpdate : typesToUpdate) {
            this.types.get(typeToUpdate).update();
        }
        for (String packageToRemove : packagesToRemove) {
            this.removePackage(packageToRemove);
        }
        for (String typeToRemove : typesToRemove) {
            this.removeType(typeToRemove);
        }
    }

    protected Set<String> calculateInitialPackageNames() {
        return CollectionTools.set((Iterable)new TransformationIterable<JavaResourcePackage, String>(this.getJaxbProject().getAnnotatedJavaResourcePackages()){

            protected String transform(JavaResourcePackage o) {
                return o.getName();
            }
        });
    }

    protected Set<String> calculatePackageNames(Set<String> typeNames) {
        HashSet packageNames = CollectionTools.set((Object[])new String[0]);
        for (String typeName : typeNames) {
            JaxbType jaxbType = this.types.get(typeName);
            if (jaxbType == null) continue;
            packageNames.add(jaxbType.getPackageName());
        }
        return packageNames;
    }

    protected Set<JavaResourceAbstractType> calculateInitialTypes() {
        HashSet set = CollectionTools.set((Iterable)new FilteringIterable<JavaResourceAbstractType>(this.getJaxbProject().getJavaSourceResourceTypes()){

            protected boolean accept(JavaResourceAbstractType o) {
                if (o.getKind() == JavaResourceAnnotatedElement.Kind.TYPE && o.getAnnotation("javax.xml.bind.annotation.XmlRegistry") != null) {
                    return true;
                }
                if (o.getKind() == JavaResourceAnnotatedElement.Kind.ENUM && o.getAnnotation("javax.xml.bind.annotation.XmlEnum") != null) {
                    return true;
                }
                return o.getAnnotation("javax.xml.bind.annotation.XmlType") != null || o.getAnnotation("javax.xml.bind.annotation.XmlRootElement") != null || o.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter") != null;
            }
        });
        CollectionTools.addAll((Collection)set, (Iterable)new FilteringIterable((Iterable)new TransformationIterable<String, JavaResourceAbstractType>((Iterable)new CompositeIterable((Iterable)new TransformationIterable<JaxbIndexResource, Iterable<String>>(this.getJaxbProject().getJaxbIndexResources()){

            protected Iterable<String> transform(JaxbIndexResource o) {
                return o.getFullyQualifiedClassNames();
            }
        })){

            protected JavaResourceAbstractType transform(String o) {
                return AbstractJaxbContextRoot.this.getJaxbProject().getJavaResourceType(o);
            }
        }, NotNullFilter.instance()));
        return set;
    }

    protected void processType(JavaResourceAbstractType resourceType, Set<String> typesToUpdate, boolean defaultMapped) {
        JaxbType type;
        JaxbType.Kind jaxbTypeKind = this.calculateJaxbTypeKind(resourceType);
        String className = resourceType.getQualifiedName();
        if (this.types.containsKey(className)) {
            type = this.types.get(className);
            if (type.getKind() == jaxbTypeKind) {
                typesToUpdate.add(className);
                type.setDefaultMapped(defaultMapped);
                return;
            }
            this.removeType(className);
        }
        type = this.buildType(resourceType);
        type.setDefaultMapped(defaultMapped);
        this.addType(type);
    }

    protected JaxbType.Kind calculateJaxbTypeKind(JavaResourceAbstractType resourceType) {
        if (resourceType.getKind() == JavaResourceAnnotatedElement.Kind.ENUM) {
            return JaxbType.Kind.ENUM;
        }
        return JaxbType.Kind.CLASS;
    }

    protected JaxbType buildType(JavaResourceAbstractType resourceType) {
        JaxbType.Kind kind = this.calculateJaxbTypeKind(resourceType);
        if (kind == JaxbType.Kind.ENUM) {
            return this.buildJaxbEnum((JavaResourceEnum)resourceType);
        }
        return this.buildJaxbClass((JavaResourceType)resourceType);
    }

    @Override
    public JaxbProject getJaxbProject() {
        return this.jaxbProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jaxbProject.getProject();
    }

    @Override
    public Iterable<JaxbPackage> getPackages() {
        return new LiveCloneIterable(this.packages.values());
    }

    @Override
    public int getPackagesSize() {
        return this.packages.size();
    }

    @Override
    public JaxbPackage getPackage(String packageName) {
        for (JaxbPackage jaxbPackage : this.getPackages()) {
            if (!StringTools.stringsAreEqual((String)jaxbPackage.getName(), (String)packageName)) continue;
            return jaxbPackage;
        }
        return null;
    }

    protected JaxbPackage addPackage(JaxbPackage contextPackage) {
        if (this.packages.containsKey(contextPackage.getName())) {
            throw new IllegalArgumentException("Package with that name already exists.");
        }
        this.packages.put(contextPackage.getName(), contextPackage);
        this.fireItemAdded("packages", contextPackage);
        return contextPackage;
    }

    protected void removePackage(JaxbPackage contextPackage) {
        this.removePackage(contextPackage.getName());
    }

    protected void removePackage(String packageName) {
        if (!this.packages.containsKey(packageName)) {
            throw new IllegalArgumentException("No package with that name exists.");
        }
        JaxbPackage removedPackage = this.packages.remove(packageName);
        this.fireItemRemoved("packages", removedPackage);
    }

    protected JaxbPackage buildPackage(String packageName) {
        return this.getFactory().buildPackage(this, packageName);
    }

    protected boolean isEmpty(JaxbPackage jaxbPackage) {
        return jaxbPackage.isEmpty();
    }

    @Override
    public Iterable<JaxbType> getTypes() {
        return new LiveCloneIterable(this.types.values());
    }

    @Override
    public int getTypesSize() {
        return this.types.size();
    }

    @Override
    public JaxbType getType(String typeName) {
        return typeName == null ? null : this.types.get(typeName);
    }

    protected void addType_(JaxbType type) {
        this.types.put(type.getFullyQualifiedName(), type);
    }

    protected void addType(JaxbType type) {
        if (this.types.containsKey(type.getFullyQualifiedName())) {
            throw new IllegalArgumentException("Type with that name already exists.");
        }
        this.addType_(type);
        this.fireItemAdded("types", type);
    }

    protected void removeType(JaxbType type) {
        this.removeType(type.getFullyQualifiedName());
    }

    protected void removeType(String typeName) {
        if (!this.types.containsKey(typeName)) {
            throw new IllegalArgumentException("No type with that name exists.");
        }
        JaxbType removedType = this.types.remove(typeName);
        this.fireItemRemoved("types", removedType);
    }

    @Override
    public Iterable<JaxbType> getTypes(final JaxbPackage jaxbPackage) {
        return new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getPackageName().equals(jaxbPackage.getName());
            }
        };
    }

    @Override
    public Iterable<JaxbClass> getClasses() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.CLASS;
            }
        });
    }

    @Override
    public Iterable<JaxbClass> getClasses(JaxbPackage jaxbPackage) {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes(jaxbPackage)){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.CLASS;
            }
        });
    }

    @Override
    public Iterable<JaxbEnum> getEnums() {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes()){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.ENUM;
            }
        });
    }

    @Override
    public Iterable<JaxbEnum> getEnums(JaxbPackage jaxbPackage) {
        return new SubIterableWrapper((Iterable)new FilteringIterable<JaxbType>(this.getTypes(jaxbPackage)){

            protected boolean accept(JaxbType o) {
                return o.getKind() == JaxbType.Kind.ENUM;
            }
        });
    }

    protected JaxbClass buildJaxbClass(JavaResourceType resourceType) {
        return this.getFactory().buildJaxbClass(this, resourceType);
    }

    protected JaxbEnum buildJaxbEnum(JavaResourceEnum resourceEnum) {
        return this.getFactory().buildJaxbEnum(this, resourceEnum);
    }

    @Override
    public Iterable<XmlRegistry> getXmlRegistries(JaxbPackage jaxbPackage) {
        return new FilteringIterable((Iterable)new TransformationIterable<JaxbClass, XmlRegistry>(this.getClasses(jaxbPackage)){

            protected XmlRegistry transform(JaxbClass o) {
                return o.getXmlRegistry();
            }
        }, NotNullFilter.INSTANCE);
    }

    @Override
    public JaxbTypeMapping getTypeMapping(String typeName) {
        JaxbType type = this.getType(typeName);
        return type == null ? null : type.getMapping();
    }

    @Override
    public JaxbClassMapping getClassMapping(String typeName) {
        JaxbType type = this.getType(typeName);
        return type == null || type.getKind() != JaxbType.Kind.CLASS ? null : ((JaxbClass)type).getMapping();
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.jaxbProject.stateChanged();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        for (JaxbPackage pkg : this.packages.values()) {
            pkg.validate(messages, reporter);
        }
        for (JaxbType type : this.types.values()) {
            type.validate(messages, reporter);
        }
    }
}

