/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQName
extends AbstractJavaContextNode
implements JaxbQName {
    protected final AnnotationProxy proxy;
    protected String specifiedNamespace;
    protected String specifiedName;

    public AbstractJavaQName(JavaContextNode parent, AnnotationProxy proxy) {
        super(parent);
        this.proxy = proxy;
        this.specifiedNamespace = this.getAnnotationNamespace();
        this.specifiedName = this.getAnnotationName();
    }

    @Override
    public JavaContextNode getParent() {
        return (JavaContextNode)super.getParent();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedNamespace_(this.getAnnotationNamespace());
        this.setSpecifiedName_(this.getAnnotationName());
    }

    protected abstract JaxbPackage getJaxbPackage();

    protected final XsdSchema getXsdSchema() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage == null ? null : jaxbPackage.getXsdSchema();
    }

    @Override
    public String getNamespace() {
        return StringTools.stringIsEmpty((String)this.getSpecifiedNamespace()) ? this.getDefaultNamespace() : this.getSpecifiedNamespace();
    }

    @Override
    public abstract String getDefaultNamespace();

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String newSpecifiedNamespace) {
        this.setAnnotationNamespace(newSpecifiedNamespace);
        this.setSpecifiedNamespace_(newSpecifiedNamespace);
    }

    protected void setSpecifiedNamespace_(String newSpecifiedNamespace) {
        String oldNamespace = this.specifiedNamespace;
        this.specifiedNamespace = newSpecifiedNamespace;
        this.firePropertyChanged("specifiedNamespace", oldNamespace, newSpecifiedNamespace);
    }

    protected void setAnnotationNamespace(String newNamespace) {
        this.proxy.setNamespace(newNamespace);
    }

    protected String getAnnotationNamespace() {
        return this.proxy.getNamespace();
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public abstract String getDefaultName();

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        this.setAnnotationName(newSpecifiedName);
        this.setSpecifiedName_(newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String old = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedName", old, newSpecifiedName);
    }

    protected void setAnnotationName(String newName) {
        this.proxy.setName(newName);
    }

    protected String getAnnotationName() {
        return this.proxy.getName();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.proxy.namespaceTouches(pos, astRoot)) {
            return this.getNamespaceProposals(filter);
        }
        if (this.proxy.nameTouches(pos, astRoot)) {
            return this.getNameProposals(filter);
        }
        return EmptyIterable.instance();
    }

    protected abstract Iterable<String> getNamespaceProposals(Filter<String> var1);

    protected abstract Iterable<String> getNameProposals(Filter<String> var1);

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.proxy.getNamespaceTextRange(astRoot), astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getTextRange(this.proxy.getNameTextRange(astRoot), astRoot);
    }

    protected String getReferencedComponentTypeDescription() {
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateName(messages, reporter, astRoot);
        if (!StringTools.stringIsEmpty((String)this.getName())) {
            this.validateReference(messages, reporter, astRoot);
        }
    }

    protected void validateName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.getName())) {
            messages.add(DefaultValidationMessages.buildMessage(1, "QNAME__MISSING_NAME", new String[]{this.getReferencedComponentTypeDescription()}, this, this.getNameTextRange(astRoot)));
        }
    }

    protected abstract void validateReference(List<IMessage> var1, IReporter var2, CompilationUnit var3);

    protected IMessage getUnresolveSchemaComponentMessage(CompilationUnit astRoot) {
        return DefaultValidationMessages.buildMessage(1, "QNAME__UNRESOLVED_COMPONENT", new String[]{this.getReferencedComponentTypeDescription(), this.getNamespace(), this.getName()}, this, this.getNameTextRange(astRoot));
    }

    public static abstract class AbstractQNameAnnotationProxy
    implements AnnotationProxy {
        protected abstract QNameAnnotation getAnnotation(boolean var1);

        public String getNamespace() {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? null : annotation.getNamespace();
        }

        public void setNamespace(String newSpecifiedNamespace) {
            this.getAnnotation(true).setNamespace(newSpecifiedNamespace);
        }

        public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? false : annotation.namespaceTouches(pos, astRoot);
        }

        public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? null : annotation.getNamespaceTextRange(astRoot);
        }

        public String getName() {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? null : annotation.getName();
        }

        public void setName(String newSpecifiedName) {
            this.getAnnotation(true).setName(newSpecifiedName);
        }

        public boolean nameTouches(int pos, CompilationUnit astRoot) {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? false : annotation.nameTouches(pos, astRoot);
        }

        public TextRange getNameTextRange(CompilationUnit astRoot) {
            QNameAnnotation annotation = this.getAnnotation(false);
            return annotation == null ? null : annotation.getNameTextRange(astRoot);
        }
    }

    public static interface AnnotationProxy {
        public String getNamespace();

        public void setNamespace(String var1);

        public boolean namespaceTouches(int var1, CompilationUnit var2);

        public TextRange getNamespaceTextRange(CompilationUnit var1);

        public String getName();

        public void setName(String var1);

        public boolean nameTouches(int var1, CompilationUnit var2);

        public TextRange getNameTextRange(CompilationUnit var1);
    }
}

