/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceXmlNsAnnotation
extends SourceAnnotation
implements XmlNsAnnotation {
    private final DeclarationAnnotationElementAdapter<String> namespaceURIDeclarationAdapter;
    private final AnnotationElementAdapter<String> namespaceURIAdapter;
    private String namespaceURI;
    private final DeclarationAnnotationElementAdapter<String> prefixDeclarationAdapter;
    private final AnnotationElementAdapter<String> prefixAdapter;
    private String prefix;

    public SourceXmlNsAnnotation(JavaResourceNode parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(annotatedElement, idaa));
        this.namespaceURIDeclarationAdapter = this.buildNamespaceURIDeclarationAdapter((DeclarationAnnotationAdapter)idaa);
        this.namespaceURIAdapter = this.buildAdapter(this.namespaceURIDeclarationAdapter);
        this.prefixDeclarationAdapter = this.buildPrefixDeclarationAdapter((DeclarationAnnotationAdapter)idaa);
        this.prefixAdapter = this.buildAdapter(this.prefixDeclarationAdapter);
    }

    protected DeclarationAnnotationElementAdapter<String> buildNamespaceURIDeclarationAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"namespaceURI");
    }

    protected DeclarationAnnotationElementAdapter<String> buildPrefixDeclarationAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"prefix");
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlNs";
    }

    public void initialize(CompilationUnit astRoot) {
        this.namespaceURI = this.buildNamespaceURI(astRoot);
        this.prefix = this.buildPrefix(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncNamespaceURI(this.buildNamespaceURI(astRoot));
        this.syncPrefix(this.buildPrefix(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.namespaceURI);
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public void setNamespaceURI(String namespaceURI) {
        if (this.attributeValueHasChanged(this.namespaceURI, namespaceURI)) {
            this.namespaceURI = namespaceURI;
            this.namespaceURIAdapter.setValue((Object)namespaceURI);
        }
    }

    private String buildNamespaceURI(CompilationUnit astRoot) {
        return (String)this.namespaceURIAdapter.getValue(astRoot);
    }

    private void syncNamespaceURI(String namespaceURI) {
        String old = this.namespaceURI;
        this.namespaceURI = namespaceURI;
        this.firePropertyChanged("namespaceURI", old, namespaceURI);
    }

    @Override
    public TextRange getNamespaceURITextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.namespaceURIDeclarationAdapter, astRoot);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        if (this.attributeValueHasChanged(this.prefix, prefix)) {
            this.prefix = prefix;
            this.prefixAdapter.setValue((Object)prefix);
        }
    }

    private String buildPrefix(CompilationUnit astRoot) {
        return (String)this.prefixAdapter.getValue(astRoot);
    }

    private void syncPrefix(String prefix) {
        String old = this.prefix;
        this.prefix = prefix;
        this.firePropertyChanged("prefix", old, prefix);
    }

    @Override
    public TextRange getPrefixTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.prefixDeclarationAdapter, astRoot);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

