/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.jaxbindex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.resource.jaxbindex.JaxbIndexResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbIndexResourceImpl
implements JaxbIndexResource {
    protected final ListenerList<JptResourceModelListener> resourceModelListenerList = new ListenerList(JptResourceModelListener.class);
    protected IFile file;
    protected String packageName;
    protected final List<String> classNames = new Vector<String>();

    public JaxbIndexResourceImpl(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        this.file = file;
        this.packageName = this.buildPackageName();
        this.buildClassNames();
    }

    protected String buildPackageName() {
        IJavaElement javaElement = JavaCore.create((IResource)this.file.getParent());
        if (javaElement != null && javaElement.getElementType() == 4) {
            return ((IPackageFragment)javaElement).getElementName();
        }
        return null;
    }

    private void buildClassNames() {
        InputStream stream = null;
        try {
            stream = this.file.getContents();
        }
        catch (CoreException ce) {
            JptJaxbCorePlugin.log(ce);
            return;
        }
        if (stream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            try {
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String className = line.trim();
                        this.classNames.add(className);
                        line = reader.readLine();
                    }
                }
                catch (Exception ex) {
                    JptJaxbCorePlugin.log(ex);
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        JptJaxbCorePlugin.log(ioe);
                    }
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    JptJaxbCorePlugin.log(ioe);
                }
            }
        }
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Iterable<String> getFullyQualifiedClassNames() {
        String packageName = this.getPackageName();
        final String packagePrefix = StringTools.stringIsEmpty((String)packageName) ? "" : String.valueOf(packageName) + ".";
        return new TransformationIterable<String, String>((Iterable)new SnapshotCloneIterable(this.classNames)){

            protected String transform(String shortClassName) {
                return String.valueOf(packagePrefix) + shortClassName;
            }
        };
    }

    void update() {
        this.classNames.clear();
        this.buildClassNames();
        this.resourceModelChanged();
    }

    public JptResourceType getResourceType() {
        return JptJaxbCorePlugin.JAXB_INDEX_RESOURCE_TYPE;
    }

    public void addResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.add((EventListener)listener);
    }

    public void removeResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.remove((EventListener)listener);
    }

    protected void resourceModelChanged() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelChanged((JptResourceModel)this);
        }
    }
}

