/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.LobConverter;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.internal.details.ColumnComposite;
import org.eclipse.jpt.jpa.ui.internal.details.EnumTypeComposite;
import org.eclipse.jpt.jpa.ui.internal.details.FetchTypeComposite;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.OptionalComposite;
import org.eclipse.jpt.jpa.ui.internal.details.TemporalTypeComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicMappingComposite<T extends BasicMapping>
extends Pane<T>
implements JpaComposite {
    protected AbstractBasicMappingComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.initializeBasicCollapsibleSection(container);
        this.initializeTypeCollapsibleSection(container);
    }

    protected void initializeBasicCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.BasicSection_title, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.TRUE));
        this.initializeBasicSection(container);
    }

    protected void initializeBasicSection(Composite container) {
        new ColumnComposite(this, this.buildColumnHolder(), container);
        new FetchTypeComposite(this, container);
        new OptionalComposite(this, this.addSubPane(container, 4));
    }

    protected void initializeTypeCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.TypeSection_type);
        this.initializeTypeSection(container);
    }

    protected void initializeTypeSection(Composite container) {
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiDetailsMessages.TypeSection_default, this.buildConverterBooleanHolder(null), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        Button lobButton = this.addRadioButton(container, JptUiDetailsMessages.TypeSection_lob, this.buildConverterBooleanHolder(LobConverter.class), null);
        ((GridData)lobButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(container, JptUiDetailsMessages.TypeSection_temporal, this.buildConverterBooleanHolder(TemporalConverter.class), null);
        this.registerSubPane(new TemporalTypeComposite(this.buildTemporalConverterHolder(converterHolder), container, this.getWidgetFactory()));
        this.addRadioButton(container, JptUiDetailsMessages.TypeSection_enumerated, this.buildConverterBooleanHolder(EnumeratedConverter.class), null);
        this.registerSubPane(new EnumTypeComposite(this.buildEnumeratedConverterHolder(converterHolder), container, this.getWidgetFactory()));
    }

    protected PropertyValueModel<Column> buildColumnHolder() {
        return new TransformationPropertyValueModel<T, Column>(this.getSubjectHolder()){

            protected Column transform_(T value) {
                return value.getColumn();
            }
        };
    }

    protected PropertyValueModel<Converter> buildConverterHolder() {
        return new PropertyAspectAdapter<T, Converter>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Converter buildValue_() {
                return ((BasicMapping)this.subject).getConverter();
            }
        };
    }

    protected PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter.getType() == TemporalConverter.class ? (TemporalConverter)converter : null;
            }
        };
    }

    protected PropertyValueModel<EnumeratedConverter> buildEnumeratedConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, EnumeratedConverter>(converterHolder){

            protected EnumeratedConverter transform_(Converter converter) {
                return converter.getType() == EnumeratedConverter.class ? (EnumeratedConverter)converter : null;
            }
        };
    }

    protected WritablePropertyValueModel<Boolean> buildConverterBooleanHolder(final Class<? extends Converter> converterType) {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getConverter();
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setConverter(converterType);
                }
            }
        };
    }
}

