/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.jface.AbstractTreeItemContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.common.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.common.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.common.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.structure.ResourceModelItemContentProvider;

public class PersistenceItemContentProviderFactory
implements TreeItemContentProviderFactory {
    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        DelegatingTreeContentAndLabelProvider treeContentProvider = (DelegatingTreeContentAndLabelProvider)contentAndLabelProvider;
        if (item instanceof JpaFile) {
            return new ResourceModelItemContentProvider((JpaFile)item, treeContentProvider);
        }
        if (item instanceof Persistence) {
            return new PersistenceItemContentProvider((Persistence)item, treeContentProvider);
        }
        if (item instanceof PersistenceUnit) {
            return new PersistenceUnitItemContentProvider((PersistenceUnit)item, treeContentProvider);
        }
        if (item instanceof MappingFileRef) {
            return new MappingFileRefItemContentProvider((MappingFileRef)item, treeContentProvider);
        }
        if (item instanceof ClassRef) {
            return new ClassRefItemContentProvider((ClassRef)item, treeContentProvider);
        }
        if (item instanceof JarFileRef) {
            return new JarFileRefItemContentProvider((JarFileRef)item, treeContentProvider);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassRefItemContentProvider
    extends AbstractTreeItemContentProvider<ClassRef> {
        public ClassRefItemContentProvider(ClassRef classRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)classRef, contentProvider);
        }

        public ClassRef getModel() {
            return (ClassRef)super.getModel();
        }

        public Object getParent() {
            return this.getModel().getPersistenceUnit();
        }

        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JarFileRefItemContentProvider
    extends AbstractTreeItemContentProvider<JarFileRef> {
        public JarFileRefItemContentProvider(JarFileRef jarFileRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)jarFileRef, contentProvider);
        }

        public JarFileRef getModel() {
            return (JarFileRef)super.getModel();
        }

        public Object getParent() {
            return this.getModel().getPersistenceUnit();
        }

        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MappingFileRefItemContentProvider
    extends AbstractTreeItemContentProvider<MappingFileRef> {
        public MappingFileRefItemContentProvider(MappingFileRef mappingFileRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)mappingFileRef, contentProvider);
        }

        public MappingFileRef getModel() {
            return (MappingFileRef)super.getModel();
        }

        public Object getParent() {
            return this.getModel().getPersistenceUnit();
        }

        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceItemContentProvider
    extends AbstractTreeItemContentProvider<PersistenceUnit> {
        public PersistenceItemContentProvider(Persistence persistence, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistence, contentProvider);
        }

        public Persistence getModel() {
            return (Persistence)super.getModel();
        }

        public Object getParent() {
            return null;
        }

        protected CollectionValueModel<PersistenceUnit> buildChildrenModel() {
            return new ListCollectionValueModelAdapter((ListValueModel)new ListAspectAdapter<Persistence, PersistenceUnit>("persistenceUnits", this.getModel()){

                protected ListIterable<PersistenceUnit> getListIterable() {
                    return ((Persistence)this.subject).getPersistenceUnits();
                }

                protected int size_() {
                    return ((Persistence)this.subject).getPersistenceUnitsSize();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitItemContentProvider
    extends AbstractTreeItemContentProvider<JpaStructureNode> {
        public PersistenceUnitItemContentProvider(PersistenceUnit persistenceUnit, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceUnit, contentProvider);
        }

        public PersistenceUnit getModel() {
            return (PersistenceUnit)super.getModel();
        }

        public Persistence getParent() {
            return this.getModel().getParent();
        }

        protected CollectionValueModel<JpaStructureNode> buildChildrenModel() {
            ListAspectAdapter<PersistenceUnit, MappingFileRef> specifiedMappingFileLvm = new ListAspectAdapter<PersistenceUnit, MappingFileRef>("specifiedMappingFileRefs", this.getModel()){

                protected ListIterable<MappingFileRef> getListIterable() {
                    return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefsSize();
                }
            };
            PropertyListValueModelAdapter impliedMappingFileCvm = new PropertyListValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<PersistenceUnit, MappingFileRef>("impliedMappingFileRef", this.getModel()){

                protected MappingFileRef buildValue_() {
                    return ((PersistenceUnit)this.subject).getImpliedMappingFileRef();
                }
            });
            ListAspectAdapter<PersistenceUnit, ClassRef> specifiedClassCvm = new ListAspectAdapter<PersistenceUnit, ClassRef>("specifiedClassRefs", this.getModel()){

                protected ListIterable<ClassRef> getListIterable() {
                    return ((PersistenceUnit)this.subject).getSpecifiedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).getSpecifiedClassRefsSize();
                }
            };
            CollectionListValueModelAdapter impliedClassCvm = new CollectionListValueModelAdapter((CollectionValueModel)new CollectionAspectAdapter<PersistenceUnit, ClassRef>("impliedClassRefs", this.getModel()){

                protected Iterable<ClassRef> getIterable() {
                    return ((PersistenceUnit)this.subject).getImpliedClassRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).getImpliedClassRefsSize();
                }
            });
            ListAspectAdapter<PersistenceUnit, JarFileRef> jarFileCvm = new ListAspectAdapter<PersistenceUnit, JarFileRef>("jarFileRefs", this.getModel()){

                protected ListIterable<JarFileRef> getListIterable() {
                    return ((PersistenceUnit)this.subject).getJarFileRefs();
                }

                protected int size_() {
                    return ((PersistenceUnit)this.subject).getJarFileRefsSize();
                }
            };
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(specifiedMappingFileLvm);
            list.add(impliedMappingFileCvm);
            list.add(specifiedClassCvm);
            list.add(impliedClassCvm);
            list.add(jarFileCvm);
            return new ListCollectionValueModelAdapter((ListValueModel)new CompositeListValueModel(list));
        }
    }
}

