/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jpt.jpa.gen.internal.AssociationRole;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class CascadeDialog
extends TrayDialog {
    private static String[] ALL_CASCADES = new String[]{"all", "persist", "merge", "remove", "refresh"};
    private static String[] ALL_CASCADES_LABELS = new String[]{"&all", "&persist", "&merge", "&remove", "r&efresh"};
    private Button[] allButtons = new Button[ALL_CASCADES.length];
    private AssociationRole associationRole;
    private List<String> cascades;

    protected CascadeDialog(Shell parentShell) {
        super(parentShell);
    }

    public static CascadeDialog create(AssociationRole role) {
        CascadeDialog dlg = new CascadeDialog(Display.getDefault().getActiveShell());
        dlg.setAssociationRole(role);
        return dlg;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JptUiEntityGenMessages.selectCascadeDlgTitle);
        this.getHelpSystem().setHelp((Control)newShell, "org.eclipse.jpt.jpa.ui.dialog_selectCascade");
    }

    private void setAssociationRole(AssociationRole role) {
        this.associationRole = role;
        List list = StringUtil.strToList((String)this.associationRole.getCascade(), (char)',', (boolean)true);
        if (list == null) {
            list = Collections.emptyList();
        }
        this.cascades = list;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createCascadeTypesGroup(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createCascadeTypesGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 275;
        group.setLayoutData((Object)gd);
        group.setText(JptUiEntityGenMessages.cascade);
        int i = 0;
        while (i < ALL_CASCADES.length) {
            Button checkbox = new Button((Composite)group, 32);
            checkbox.setText(ALL_CASCADES_LABELS[i]);
            checkbox.setSelection(this.isInList(ALL_CASCADES[i]));
            checkbox.setData((Object)ALL_CASCADES[i]);
            this.allButtons[i] = checkbox;
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.getSource();
                    if (b.getSelection()) {
                        if (b == CascadeDialog.this.allButtons[0]) {
                            Button[] buttonArray = CascadeDialog.this.allButtons;
                            int n = buttonArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Button btn = buttonArray[n2];
                                if (btn != e.getSource()) {
                                    btn.setSelection(false);
                                }
                                ++n2;
                            }
                        } else {
                            CascadeDialog.this.allButtons[0].setSelection(false);
                        }
                    }
                }
            });
            ++i;
        }
    }

    protected void okPressed() {
        StringBuilder builder = new StringBuilder();
        Button[] buttonArray = this.allButtons;
        int n = this.allButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            if (b.getSelection()) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(b.getData());
            }
            ++n2;
        }
        this.associationRole.setCascade(builder.toString());
        super.okPressed();
    }

    private boolean isInList(String cascade) {
        for (String s : this.cascades) {
            if (!s.equals(cascade)) continue;
            return true;
        }
        return false;
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }
}

