/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAnnotatedElement
extends BinaryNode
implements JavaResourceAnnotatedElement {
    final Adapter adapter;
    final Vector<Annotation> annotations = new Vector();
    final Map<String, AnnotationContainer> annotationContainers = new HashMap<String, AnnotationContainer>();
    private final HashMap<String, Annotation> nullAnnotationsCache = new HashMap();
    private static final IAnnotation[] EMPTY_JDT_ANNOTATION_ARRAY = new IAnnotation[0];
    private static final IMemberValuePair[] EMPTY_MEMBER_VALUE_PAIR_ARRAY = new IMemberValuePair[0];

    public BinaryAnnotatedElement(JavaResourceNode parent, Adapter adapter) {
        super(parent);
        this.adapter = adapter;
        this.initializeAnnotations();
    }

    private void initializeAnnotations() {
        IAnnotation[] iAnnotationArray = this.getJdtAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.addAnnotation(annotation);
            ++n2;
        }
    }

    private void addAnnotation(IAnnotation jdtAnnotation) {
        String jdtAnnotationName = jdtAnnotation.getElementName();
        if (this.annotationIsValid(jdtAnnotationName)) {
            this.annotations.add(this.getAnnotationProvider().buildAnnotation(this, jdtAnnotation));
        }
        if (this.annotationIsValidNestable(jdtAnnotationName)) {
            AnnotationContainer container = new AnnotationContainer(jdtAnnotation);
            this.annotationContainers.put(jdtAnnotationName, container);
        }
        if (this.annotationIsValidContainer(jdtAnnotationName)) {
            String nestableAnnotationName = this.getNestableAnnotationName(jdtAnnotationName);
            AnnotationContainer container = new AnnotationContainer(jdtAnnotation);
            this.annotationContainers.put(nestableAnnotationName, container);
        }
    }

    private boolean annotationIsValid(String annotationName) {
        return CollectionTools.contains(this.getValidAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidContainer(String annotationName) {
        return CollectionTools.contains(this.getValidContainerAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidNestable(String annotationName) {
        return CollectionTools.contains(this.getValidNestableAnnotationNames(), (Object)annotationName);
    }

    Iterable<String> getValidAnnotationNames() {
        return this.getAnnotationProvider().getAnnotationNames();
    }

    Iterable<String> getValidContainerAnnotationNames() {
        return this.getAnnotationProvider().getContainerAnnotationNames();
    }

    Iterable<String> getValidNestableAnnotationNames() {
        return this.getAnnotationProvider().getNestableAnnotationNames();
    }

    private String getNestableAnnotationName(String containerAnnotationName) {
        return this.getAnnotationProvider().getNestableAnnotationName(containerAnnotationName);
    }

    @Override
    public void update() {
        super.update();
        this.updateAnnotations();
    }

    private void updateAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int getAnnotationsSize() {
        return this.annotations.size();
    }

    protected Iterable<NestableAnnotation> getNestableAnnotations() {
        return new CompositeIterable(this.getNestableAnnotationLists());
    }

    private Iterable<Iterable<NestableAnnotation>> getNestableAnnotationLists() {
        return new TransformationIterable<AnnotationContainer, Iterable<NestableAnnotation>>(this.annotationContainers.values()){

            protected Iterable<NestableAnnotation> transform(AnnotationContainer container) {
                return container.getNestedAnnotations();
            }
        };
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.getNullAnnotation(annotationName);
    }

    private synchronized Annotation getNullAnnotation(String annotationName) {
        Annotation annotation = this.nullAnnotationsCache.get(annotationName);
        if (annotation == null) {
            annotation = this.buildNullAnnotation(annotationName);
            this.nullAnnotationsCache.put(annotationName, annotation);
        }
        return annotation;
    }

    private Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAnnotation(this, annotationName);
    }

    @Override
    public ListIterable<NestableAnnotation> getAnnotations(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container != null ? container.getNestedAnnotations() : EmptyListIterable.instance();
    }

    @Override
    public int getAnnotationsSize(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? 0 : container.getNestedAnnotationsSize();
    }

    @Override
    public NestableAnnotation getAnnotation(int index, String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? null : container.nestedAnnotationAt(index);
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public boolean isAnnotatedWith(Iterable<String> annotationNames) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!CollectionTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            return true;
        }
        for (Annotation annotation : this.getNestableAnnotations()) {
            if (!CollectionTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            return true;
        }
        return false;
    }

    IJavaElement getAnnotatedElement() {
        return this.adapter.getElement();
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> annotationList, String annotationName) {
        for (Annotation annotation : annotationList) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private IAnnotation[] getJdtAnnotations() {
        try {
            return this.adapter.getAnnotations();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_JDT_ANNOTATION_ARRAY;
        }
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getTextRange(String nestableAnnotationName, CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter {
        public IJavaElement getElement();

        public IAnnotation[] getAnnotations() throws JavaModelException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationContainer {
        private final IAnnotation containerAnnotation;
        final Vector<NestableAnnotation> nestedAnnotations = new Vector();

        protected AnnotationContainer(IAnnotation containerAnnotation) {
            this.containerAnnotation = containerAnnotation;
        }

        protected void initializeNestedAnnotations() {
            int index = 0;
            IMemberValuePair[] iMemberValuePairArray = this.getJdtMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair valuePair = iMemberValuePairArray[n2];
                IAnnotation nestedAnnotation = (IAnnotation)valuePair.getValue();
                this.nestedAnnotations.add(BinaryAnnotatedElement.this.getAnnotationProvider().buildAnnotation((JavaResourceAnnotatedElement)BinaryAnnotatedElement.this, nestedAnnotation, index++));
                ++n2;
            }
        }

        public ListIterable<NestableAnnotation> getNestedAnnotations() {
            return new LiveCloneListIterable(this.nestedAnnotations);
        }

        public int getNestedAnnotationsSize() {
            return this.nestedAnnotations.size();
        }

        public NestableAnnotation nestedAnnotationAt(int index) {
            return this.nestedAnnotations.get(index);
        }

        private IMemberValuePair[] getJdtMemberValuePairs() {
            try {
                return this.containerAnnotation.getMemberValuePairs();
            }
            catch (JavaModelException ex) {
                JptCommonCorePlugin.log(ex);
                return EMPTY_MEMBER_VALUE_PAIR_ARRAY;
            }
        }
    }
}

