/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

final class BinaryEnumConstant
extends BinaryMember
implements JavaResourceEnumConstant {
    BinaryEnumConstant(JavaResourceEnum parent, IField enumConstant) {
        super((JavaResourceNode)parent, new EnumConstantAdapter(enumConstant));
    }

    IField getMember() {
        return (IField)super.getMember();
    }

    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.ENUM_CONSTANT;
    }

    public String getName() {
        return this.getMember().getElementName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnumConstantAdapter
    implements BinaryMember.Adapter {
        private final IField enumConstant;

        EnumConstantAdapter(IField enumConstant) {
            this.enumConstant = enumConstant;
        }

        public IField getElement() {
            return this.enumConstant;
        }

        @Override
        public Iterable<ITypeParameter> getTypeParameters() {
            try {
                return new ArrayIterable((Object[])this.enumConstant.getDeclaringType().getTypeParameters());
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
                return EmptyIterable.instance();
            }
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.enumConstant.getAnnotations();
        }
    }
}

