/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryMember
extends BinaryAnnotatedElement
implements JavaResourceMember {
    private boolean final_ = this.buildFinal();
    private boolean transient_ = this.buildTransient();
    private boolean public_ = this.buildPublic();
    private boolean static_ = this.buildStatic();

    public BinaryMember(JavaResourceNode parent, Adapter adapter) {
        super(parent, adapter);
    }

    @Override
    public void update() {
        super.update();
        this.setFinal(this.buildFinal());
        this.setTransient(this.buildTransient());
        this.setPublic(this.buildPublic());
        this.setStatic(this.buildStatic());
    }

    @Override
    public boolean isFinal() {
        return this.final_;
    }

    private void setFinal(boolean final_) {
        boolean old = this.final_;
        this.final_ = final_;
        this.firePropertyChanged("final", old, final_);
    }

    private boolean buildFinal() {
        try {
            return Flags.isFinal((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isTransient() {
        return this.transient_;
    }

    private void setTransient(boolean transient_) {
        boolean old = this.transient_;
        this.transient_ = transient_;
        this.firePropertyChanged("transient", old, transient_);
    }

    private boolean buildTransient() {
        try {
            return Flags.isTransient((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isPublic() {
        return this.public_;
    }

    private void setPublic(boolean public_) {
        boolean old = this.public_;
        this.public_ = public_;
        this.firePropertyChanged("public", old, public_);
    }

    private boolean buildPublic() {
        try {
            return Flags.isPublic((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void setStatic(boolean static_) {
        boolean old = this.static_;
        this.static_ = static_;
        this.firePropertyChanged("static", old, static_);
    }

    private boolean buildStatic() {
        try {
            return Flags.isStatic((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    IMember getMember() {
        return this.getAdapter().getElement();
    }

    private Adapter getAdapter() {
        return (Adapter)this.adapter;
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName_(typeSignature, typeParameters);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return BinaryMember.convertTypeSignatureToTypeName(typeSignature, EmptyIterable.instance());
    }

    static String convertTypeSignatureToTypeName_(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        String erasureSignature = Signature.getTypeErasure((String)typeSignature);
        if (Signature.getTypeSignatureKind((String)erasureSignature) == 3) {
            try {
                String typeParameterName = Signature.toString((String)erasureSignature);
                for (ITypeParameter typeParameter : typeParameters) {
                    String[] bounds;
                    if (!typeParameterName.equals(typeParameter.getElementName())) continue;
                    String[] stringArray = bounds = typeParameter == null ? new String[]{} : typeParameter.getBoundsSignatures();
                    if (bounds.length <= 0) continue;
                    return BinaryMember.convertTypeSignatureToTypeName_(bounds[0], typeParameters);
                }
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
            }
        } else {
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 4) {
                int dim = Signature.getArrayCount((String)erasureSignature);
                String arrayTypeName = BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)erasureSignature), typeParameters);
                return Signature.toString((String)Signature.createArraySignature((String)Signature.createTypeSignature((String)arrayTypeName, (boolean)true), (int)dim));
            }
            if (Signature.getTypeSignatureKind((String)erasureSignature) == 5) {
                if (String.valueOf('*').equals(erasureSignature) || erasureSignature.startsWith(String.valueOf('-'))) {
                    return "java.lang.Object";
                }
                return Signature.toString((String)erasureSignature.substring(1));
            }
        }
        return Signature.toString((String)erasureSignature);
    }

    static boolean convertTypeSignatureToTypeIsArray(String typeSignature) {
        return typeSignature == null ? false : Signature.getTypeSignatureKind((String)typeSignature) == 4;
    }

    static int convertTypeSignatureToTypeArrayDimensionality(String typeSignature) {
        return typeSignature == null ? 0 : Signature.getArrayCount((String)typeSignature);
    }

    static String convertTypeSignatureToTypeArrayComponentTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return typeSignature == null ? null : BinaryMember.convertTypeSignatureToTypeName(Signature.getElementType((String)typeSignature), typeParameters);
    }

    static List<String> convertTypeSignatureToTypeTypeArgumentNames(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        if (typeSignature == null) {
            return Collections.emptyList();
        }
        String[] typeArgumentSignatures = Signature.getTypeArguments((String)typeSignature);
        if (typeArgumentSignatures.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArgumentSignatures.length);
        String[] stringArray = typeArgumentSignatures;
        int n = typeArgumentSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String typeArgumentSignature = stringArray[n2];
            names.add(BinaryMember.convertTypeSignatureToTypeName(typeArgumentSignature, typeParameters));
            ++n2;
        }
        return names;
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Adapter
    extends BinaryAnnotatedElement.Adapter {
        public IMember getElement();

        public Iterable<ITypeParameter> getTypeParameters();
    }
}

