/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryField;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryType
extends BinaryAbstractType
implements JavaResourceType {
    private String superclassQualifiedName = this.buildSuperclassQualifiedName();
    private boolean abstract_ = this.buildAbstract();
    private boolean hasNoArgConstructor = this.buildHasNoArgConstructor();
    private boolean hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor();
    private final Vector<JavaResourceField> fields = this.buildFields();
    private final Vector<JavaResourceMethod> methods = this.buildMethods();
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

    BinaryType(JavaResourceNode parent, IType type) {
        super(parent, type);
    }

    @Override
    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.TYPE;
    }

    @Override
    public void update() {
        super.update();
        this.setSuperclassQualifiedName(this.buildSuperclassQualifiedName());
        this.setAbstract(this.buildAbstract());
        this.setHasNoArgConstructor(this.buildHasNoArgConstructor());
        this.setHasPrivateNoArgConstructor(this.buildHasPrivateNoArgConstructor());
        this.updateFields();
        this.updateMethods();
    }

    private void updateFields() {
        throw new UnsupportedOperationException();
    }

    private void updateMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void setSuperclassQualifiedName(String superclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = superclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, superclassQualifiedName);
    }

    private String buildSuperclassQualifiedName() {
        return BinaryType.convertTypeSignatureToTypeName(this.getSuperclassTypeSignature());
    }

    private String getSuperclassTypeSignature() {
        try {
            return this.getMember().getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void setAbstract(boolean abstract_) {
        boolean old = this.abstract_;
        this.abstract_ = abstract_;
        this.firePropertyChanged("abstract", old, abstract_);
    }

    private boolean buildAbstract() {
        try {
            return Flags.isAbstract((int)this.getMember().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void setHasNoArgConstructor(boolean hasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = hasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, hasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor() {
        return this.findNoArgConstructor() != null;
    }

    private IMethod findNoArgConstructor() {
        try {
            IMethod[] iMethodArray = this.getMember().getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
        }
        return null;
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private void setHasPrivateNoArgConstructor(boolean hasPrivateNoArgConstructor) {
        boolean old = this.hasPrivateNoArgConstructor;
        this.hasPrivateNoArgConstructor = hasPrivateNoArgConstructor;
        this.firePropertyChanged("privateNoArgConstructor", old, hasPrivateNoArgConstructor);
    }

    private boolean buildHasPrivateNoArgConstructor() {
        IMethod method = this.findNoArgConstructor();
        try {
            return method != null && Flags.isPrivate((int)method.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean hasPublicOrProtectedNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (CollectionTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers()) || Modifier.isProtected((int)constructor.getModifiers());
        }
        return false;
    }

    protected Iterable<JavaResourceMethod> getConstructors() {
        return new FilteringIterable<JavaResourceMethod>(this.getMethods()){

            protected boolean accept(JavaResourceMethod o) {
                return o.isConstructor();
            }
        };
    }

    @Override
    public boolean hasAnyAnnotatedFields() {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnyAnnotatedMethods() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IType getMember() {
        return super.getMember();
    }

    @Override
    public Iterable<JavaResourceField> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    private void addField(JavaResourceField field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourceField getField(String fieldName, int occurrence) {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourceField> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private Vector<JavaResourceField> buildFields() {
        IField[] jdtFields = this.getFields(this.getMember());
        Vector<JavaResourceField> result = new Vector<JavaResourceField>(jdtFields.length);
        IField[] iFieldArray = jdtFields;
        int n = jdtFields.length;
        int n2 = 0;
        while (n2 < n) {
            IField jdtField = iFieldArray[n2];
            result.add(this.buildField(jdtField));
            ++n2;
        }
        return result;
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    private JavaResourceField buildField(IField jdtField) {
        return new BinaryField((JavaResourceType)this, jdtField);
    }

    @Override
    public Iterable<JavaResourceMethod> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    private JavaResourceMethod getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourceMethod method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourceMethod> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private Vector<JavaResourceMethod> buildMethods() {
        IMethod[] jdtMethods = this.getMethods(this.getMember());
        Vector<JavaResourceMethod> result = new Vector<JavaResourceMethod>(jdtMethods.length);
        IMethod[] iMethodArray = jdtMethods;
        int n = jdtMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod jdtMethod = iMethodArray[n2];
            result.add(this.buildMethod(jdtMethod));
            ++n2;
        }
        return result;
    }

    private IMethod[] getMethods(IType type) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_METHOD_ARRAY;
        }
    }

    private JavaResourceMethod buildMethod(IMethod jdtMethod) {
        return new BinaryMethod((JavaResourceType)this, jdtMethod);
    }
}

