/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedExpressionConverter;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayExpressionConverter
extends AbstractExpressionConverter<String[]>
implements IndexedExpressionConverter<String> {
    private final ExpressionConverter<String> elementConverter;
    private final boolean removeArrayInitializerWhenEmpty;

    public StringArrayExpressionConverter(ExpressionConverter<String> elementConverter) {
        this(elementConverter, true);
    }

    public StringArrayExpressionConverter(ExpressionConverter<String> elementConverter, boolean removeArrayInitializerWhenEmpty) {
        this.elementConverter = elementConverter;
        this.removeArrayInitializerWhenEmpty = removeArrayInitializerWhenEmpty;
    }

    public ArrayInitializer convertObject(String[] strings, AST ast) {
        if (strings.length == 0 && this.removeArrayInitializerWhenEmpty) {
            return null;
        }
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        List<Expression> expressions = this.expressions(arrayInitializer);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            expressions.add(this.elementConverter.convert(string, ast));
            ++n2;
        }
        return arrayInitializer;
    }

    private List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    @Override
    public String[] convertNull() {
        return StringTools.EMPTY_STRING_ARRAY;
    }

    @Override
    protected String[] convertExpression(Expression expression) {
        return expression.getNodeType() == 4 ? this.convertArrayInitializer((ArrayInitializer)expression) : StringTools.EMPTY_STRING_ARRAY;
    }

    public String[] convertArrayInitializer(ArrayInitializer arrayInitializer) {
        List<Expression> expressions = this.expressions(arrayInitializer);
        int len = expressions.size();
        String[] strings = new String[len];
        int i = len;
        while (i-- > 0) {
            strings[i] = this.elementConverter.convert(expressions.get(i));
        }
        return strings;
    }

    @Override
    public Expression getSubexpression(int index, Expression expression) {
        if (expression.getNodeType() == 4) {
            return this.expressions((ArrayInitializer)expression).get(index);
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

